/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

public final class MathUtil {
    private MathUtil() {
    }

    public static int findNextPositivePowerOfTwo(int value) {
        int n;
        assert (value > Integer.MIN_VALUE && value < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int value) {
        int n;
        if (value <= 0) {
            return 1;
        }
        if (value >= 0x40000000) {
            return 0x40000000;
        }
        return MathUtil.findNextPositivePowerOfTwo(n);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOutOfBounds(int index, int length, int capacity) {
        void var1_1;
        int n;
        void var2_2;
        return (index | length | capacity | index + length | var2_2 - (n + var1_1)) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int x, int y) {
        void var1_1;
        int n;
        if (x < y) {
            return -1;
        }
        if (n > var1_1) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long x, long y) {
        void var2_1;
        long l;
        if (x < y) {
            return -1;
        }
        if (l > var2_1) {
            return 1;
        }
        return 0;
    }
}

