/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.NetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);
    private static final int EUI64_MAC_ADDRESS_LENGTH = 8;
    private static final int EUI48_MAC_ADDRESS_LENGTH = 6;

    /*
     * WARNING - void declaration
     */
    public static byte[] bestAvailableMac() {
        void var0;
        Object bestMacAddr = EmptyArrays.EMPTY_BYTES;
        InetAddress bestInetAddr = NetUtil.LOCALHOST4;
        LinkedHashMap<NetworkInterface, InetAddress> ifaces = new LinkedHashMap<NetworkInterface, InetAddress>();
        for (NetworkInterface iface : NetUtil.NETWORK_INTERFACES) {
            InetAddress a;
            Enumeration<InetAddress> addrs = SocketUtils.addressesFromNetworkInterface(iface);
            if (!addrs.hasMoreElements() || (a = addrs.nextElement()).isLoopbackAddress()) continue;
            ifaces.put(iface, a);
        }
        Iterator<Object> iterator = ifaces.entrySet().iterator();
        while (iterator.hasNext()) {
            void var2_2;
            byte[] macAddr;
            Map.Entry entry = (Map.Entry)iterator.next();
            NetworkInterface iface = (NetworkInterface)entry.getKey();
            InetAddress inetAddr = (InetAddress)entry.getValue();
            if (iface.isVirtual()) continue;
            try {
                macAddr = SocketUtils.hardwareAddressFromNetworkInterface(iface);
            }
            catch (SocketException e) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)iface, (Object)e);
                continue;
            }
            boolean replace = false;
            int res = MacAddressUtil.compareAddresses(bestMacAddr, macAddr);
            if (res < 0) {
                replace = true;
            } else if (res == 0) {
                res = MacAddressUtil.compareAddresses(bestInetAddr, inetAddr);
                if (res < 0) {
                    replace = true;
                } else if (res == 0 && ((byte[])bestMacAddr).length < macAddr.length) {
                    replace = true;
                }
            }
            if (!replace) continue;
            bestMacAddr = var2_2;
            bestInetAddr = inetAddr;
        }
        if (bestMacAddr == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        if (((byte[])bestMacAddr).length == 6) {
            byte[] newAddr = new byte[8];
            System.arraycopy(bestMacAddr, 0, newAddr, 0, 3);
            newAddr[3] = -1;
            newAddr[4] = -2;
            System.arraycopy(bestMacAddr, 3, newAddr, 5, 3);
            bestMacAddr = iterator;
        } else {
            bestMacAddr = Arrays.copyOf(bestMacAddr, 8);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] defaultMachineId() {
        void var0;
        byte[] bestMacAddr = MacAddressUtil.bestAvailableMac();
        if (bestMacAddr == null) {
            bestMacAddr = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(bestMacAddr));
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] parseMAC(String value) {
        void var1_2;
        String string;
        byte[] machineId;
        char separator;
        switch (value.length()) {
            case 17: {
                separator = value.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[6];
                break;
            }
            case 23: {
                separator = value.charAt(2);
                MacAddressUtil.validateMacSeparator(separator);
                machineId = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int end = machineId.length - 1;
        int j = 0;
        int i = 0;
        while (i < end) {
            int sIndex = j + 2;
            machineId[i] = StringUtil.decodeHexByte(value, j);
            if (value.charAt(sIndex) != separator) {
                throw new IllegalArgumentException("expected separator '" + separator + " but got '" + value.charAt(sIndex) + "' at index: " + sIndex);
            }
            ++i;
            j += 3;
        }
        machineId[var3_3] = StringUtil.decodeHexByte(string, j);
        return var1_2;
    }

    private static void validateMacSeparator(char separator) {
        if (separator != ':' && separator != '-') {
            char c;
            throw new IllegalArgumentException("unsupported separator: " + c + " (expected: [:-])");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String formatAddress(byte[] addr) {
        void var1_1;
        byte[] byArray;
        StringBuilder buf = new StringBuilder(24);
        for (byte b : byArray) {
            buf.append(String.format("%02x:", b & 0xFF));
        }
        return buf.substring(0, var1_1.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    static int compareAddresses(byte[] current, byte[] candidate) {
        byte[] byArray;
        void var1_1;
        void var2_2;
        if (candidate == null || candidate.length < 6) {
            return 1;
        }
        boolean onlyZeroAndOne = true;
        byte[] byArray2 = candidate;
        int n = candidate.length;
        for (int i = 0; i < n; ++i) {
            byte b = byArray2[i];
            if (b == 0 || b == 1) continue;
            onlyZeroAndOne = false;
            break;
        }
        if (var2_2 != false) {
            return 1;
        }
        if ((candidate[0] & 1) != 0) {
            return 1;
        }
        if ((var1_1[0] & 2) == 0) {
            if (current.length != 0 && (current[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (current.length != 0 && (byArray[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static int compareAddresses(InetAddress current, InetAddress candidate) {
        void var1_1;
        return MacAddressUtil.scoreAddress(current) - MacAddressUtil.scoreAddress((InetAddress)var1_1);
    }

    private static int scoreAddress(InetAddress addr) {
        InetAddress inetAddress;
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return 0;
        }
        if (addr.isMulticastAddress()) {
            return 1;
        }
        if (addr.isLinkLocalAddress()) {
            return 2;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

