/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.IntegerHolder;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.TypeParameterMatcher;
import io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    private static final ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = new ThreadLocal();
    private static final AtomicInteger nextIndex = new AtomicInteger();
    public static final int VARIABLES_TO_REMOVE_INDEX = InternalThreadLocalMap.nextVariableIndex();
    private static final int DEFAULT_ARRAY_LIST_INITIAL_CAPACITY = 8;
    private static final int ARRAY_LIST_CAPACITY_EXPAND_THRESHOLD = 0x40000000;
    private static final int ARRAY_LIST_CAPACITY_MAX_SIZE = 0x7FFFFFF7;
    private static final int HANDLER_SHARABLE_CACHE_INITIAL_CAPACITY = 4;
    private static final int INDEXED_VARIABLE_TABLE_INITIAL_SIZE = 32;
    private static final int STRING_BUILDER_INITIAL_SIZE;
    private static final int STRING_BUILDER_MAX_SIZE;
    private static final InternalLogger logger;
    public static final Object UNSET;
    private Object[] indexedVariables = InternalThreadLocalMap.newIndexedVariableTable();
    private int futureListenerStackDepth;
    private int localChannelReaderStackDepth;
    private Map<Class<?>, Boolean> handlerSharableCache;
    private IntegerHolder counterHashCode;
    private ThreadLocalRandom random;
    private Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache;
    private Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache;
    private StringBuilder stringBuilder;
    private Map<Charset, CharsetEncoder> charsetEncoderCache;
    private Map<Charset, CharsetDecoder> charsetDecoderCache;
    private ArrayList<Object> arrayList;
    private BitSet cleanerFlags;
    public long rp1;
    public long rp2;
    public long rp3;
    public long rp4;
    public long rp5;
    public long rp6;
    public long rp7;
    public long rp8;

    /*
     * WARNING - void declaration
     */
    public static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            void var0;
            return ((FastThreadLocalThread)var0).threadLocalMap();
        }
        return slowThreadLocalMap.get();
    }

    /*
     * WARNING - void declaration
     */
    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            void var0;
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)var0);
        }
        return InternalThreadLocalMap.slowGet();
    }

    /*
     * WARNING - void declaration
     */
    private static InternalThreadLocalMap fastGet(FastThreadLocalThread thread) {
        void var1_1;
        InternalThreadLocalMap threadLocalMap = thread.threadLocalMap();
        if (threadLocalMap == null) {
            FastThreadLocalThread fastThreadLocalThread;
            threadLocalMap = new InternalThreadLocalMap();
            fastThreadLocalThread.setThreadLocalMap(threadLocalMap);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static InternalThreadLocalMap slowGet() {
        void var0;
        InternalThreadLocalMap ret = slowThreadLocalMap.get();
        if (ret == null) {
            ret = new InternalThreadLocalMap();
            slowThreadLocalMap.set(ret);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            void var0;
            ((FastThreadLocalThread)var0).setThreadLocalMap(null);
            return;
        }
        slowThreadLocalMap.remove();
    }

    public static void destroy() {
        slowThreadLocalMap.remove();
    }

    /*
     * WARNING - void declaration
     */
    public static int nextVariableIndex() {
        void var0;
        int index = nextIndex.getAndIncrement();
        if (index >= 0x7FFFFFF7 || index < 0) {
            nextIndex.set(0x7FFFFFF7);
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return (int)var0;
    }

    public static int lastVariableIndex() {
        return nextIndex.get() - 1;
    }

    private InternalThreadLocalMap() {
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] newIndexedVariableTable() {
        void var0;
        Object[] array = new Object[32];
        Arrays.fill(array, UNSET);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void var1_1;
        Object v;
        int count = 0;
        if (this.futureListenerStackDepth != 0) {
            ++count;
        }
        if (this.localChannelReaderStackDepth != 0) {
            ++count;
        }
        if (this.handlerSharableCache != null) {
            ++count;
        }
        if (this.counterHashCode != null) {
            ++count;
        }
        if (this.random != null) {
            ++count;
        }
        if (this.typeParameterMatcherGetCache != null) {
            ++count;
        }
        if (this.typeParameterMatcherFindCache != null) {
            ++count;
        }
        if (this.stringBuilder != null) {
            ++count;
        }
        if (this.charsetEncoderCache != null) {
            ++count;
        }
        if (this.charsetDecoderCache != null) {
            ++count;
        }
        if (this.arrayList != null) {
            ++count;
        }
        if ((v = this.indexedVariable(VARIABLES_TO_REMOVE_INDEX)) != null && v != UNSET) {
            void var2_2;
            Set variablesToRemove = (Set)v;
            count += var2_2.size();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuilder stringBuilder() {
        void var1_1;
        StringBuilder sb = this.stringBuilder;
        if (sb == null) {
            this.stringBuilder = new StringBuilder(STRING_BUILDER_INITIAL_SIZE);
            return this.stringBuilder;
        }
        if (sb.capacity() > STRING_BUILDER_MAX_SIZE) {
            sb.setLength(STRING_BUILDER_INITIAL_SIZE);
            sb.trimToSize();
        }
        sb.setLength(0);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<Charset, CharsetEncoder> charsetEncoderCache() {
        void var1_1;
        Map<Charset, CharsetEncoder> cache = this.charsetEncoderCache;
        if (cache == null) {
            this.charsetEncoderCache = cache = new IdentityHashMap<Charset, CharsetEncoder>();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<Charset, CharsetDecoder> charsetDecoderCache() {
        void var1_1;
        Map<Charset, CharsetDecoder> cache = this.charsetDecoderCache;
        if (cache == null) {
            this.charsetDecoderCache = cache = new IdentityHashMap<Charset, CharsetDecoder>();
        }
        return var1_1;
    }

    public final <E> ArrayList<E> arrayList() {
        return this.arrayList(8);
    }

    /*
     * WARNING - void declaration
     */
    public final <E> ArrayList<E> arrayList(int minCapacity) {
        void var2_2;
        void var1_1;
        ArrayList<Object> list = this.arrayList;
        if (list == null) {
            this.arrayList = new ArrayList(minCapacity);
            return this.arrayList;
        }
        list.clear();
        list.ensureCapacity((int)var1_1);
        return var2_2;
    }

    public final int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFutureListenerStackDepth(int futureListenerStackDepth) {
        void var1_1;
        this.futureListenerStackDepth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ThreadLocalRandom random() {
        void var1_1;
        ThreadLocalRandom r = this.random;
        if (r == null) {
            this.random = r = new ThreadLocalRandom();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        void var1_1;
        Map<Class<?>, TypeParameterMatcher> cache = this.typeParameterMatcherGetCache;
        if (cache == null) {
            this.typeParameterMatcherGetCache = cache = new IdentityHashMap();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        void var1_1;
        Map<Class<?>, Map<String, TypeParameterMatcher>> cache = this.typeParameterMatcherFindCache;
        if (cache == null) {
            this.typeParameterMatcherFindCache = cache = new IdentityHashMap();
        }
        return var1_1;
    }

    @Deprecated
    public final IntegerHolder counterHashCode() {
        return this.counterHashCode;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setCounterHashCode(IntegerHolder counterHashCode) {
        void var1_1;
        this.counterHashCode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<Class<?>, Boolean> handlerSharableCache() {
        void var1_1;
        Map<Class<?>, Boolean> cache = this.handlerSharableCache;
        if (cache == null) {
            this.handlerSharableCache = cache = new WeakHashMap(4);
        }
        return var1_1;
    }

    public final int localChannelReaderStackDepth() {
        return this.localChannelReaderStackDepth;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLocalChannelReaderStackDepth(int localChannelReaderStackDepth) {
        void var1_1;
        this.localChannelReaderStackDepth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Object indexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            void var1_1;
            void var2_2;
            return var2_2[var1_1];
        }
        return UNSET;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setIndexedVariable(int index, Object value) {
        void var2_2;
        void var1_1;
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            Object oldValue = lookup[index];
            var3_3[index] = value;
            return oldValue == UNSET;
        }
        this.expandIndexedVariableTableAndSet((int)var1_1, var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void expandIndexedVariableTableAndSet(int index, Object value) {
        void var3_3;
        void var2_2;
        int newCapacity;
        Object[] oldArray = this.indexedVariables;
        int oldCapacity = this.indexedVariables.length;
        if (index < 0x40000000) {
            newCapacity = index;
            newCapacity |= newCapacity >>> 1;
            newCapacity |= newCapacity >>> 2;
            newCapacity |= newCapacity >>> 4;
            newCapacity |= newCapacity >>> 8;
            newCapacity |= newCapacity >>> 16;
            ++newCapacity;
        } else {
            newCapacity = 0x7FFFFFF7;
        }
        Object[] newArray = Arrays.copyOf(oldArray, newCapacity);
        Arrays.fill(newArray, oldCapacity, newArray.length, UNSET);
        newArray[var1_1] = var2_2;
        this.indexedVariables = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final Object removeIndexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            void var3_3;
            Object v = lookup[index];
            var2_2[var1_1] = UNSET;
            return var3_3;
        }
        return UNSET;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isIndexedVariableSet(int index) {
        void var1_1;
        void var2_2;
        Object[] lookup = this.indexedVariables;
        return index < lookup.length && var2_2[var1_1] != UNSET;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCleanerFlagSet(int index) {
        void var1_1;
        return this.cleanerFlags != null && this.cleanerFlags.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCleanerFlag(int index) {
        void var1_1;
        if (this.cleanerFlags == null) {
            this.cleanerFlags = new BitSet();
        }
        this.cleanerFlags.set((int)var1_1);
    }

    static {
        UNSET = new Object();
        STRING_BUILDER_INITIAL_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalMap.stringBuilder.initialSize", 1024);
        STRING_BUILDER_MAX_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalMap.stringBuilder.maxSize", 4096);
        logger = InternalLoggerFactory.getInstance(InternalThreadLocalMap.class);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.initialSize: {}", (Object)STRING_BUILDER_INITIAL_SIZE);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.maxSize: {}", (Object)STRING_BUILDER_MAX_SIZE);
    }
}

