/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DefaultPriorityQueue<T extends PriorityQueueNode>
extends AbstractQueue<T>
implements PriorityQueue<T> {
    private static final PriorityQueueNode[] EMPTY_ARRAY = new PriorityQueueNode[0];
    private final Comparator<T> comparator;
    private T[] queue;
    private int size;

    /*
     * WARNING - void declaration
     */
    public DefaultPriorityQueue(Comparator<T> comparator, int initialSize) {
        void var2_2;
        void var1_1;
        this.comparator = (Comparator)ObjectUtil.checkNotNull(var1_1, "comparator");
        this.queue = initialSize != 0 ? new PriorityQueueNode[var2_2] : EMPTY_ARRAY;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        void var1_1;
        if (!(o instanceof PriorityQueueNode)) {
            return false;
        }
        PriorityQueueNode node = (PriorityQueueNode)o;
        void v0 = var1_1;
        return this.contains((PriorityQueueNode)v0, v0.priorityQueueIndex(this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsTyped(T node) {
        void var1_1;
        void v0 = var1_1;
        return this.contains((PriorityQueueNode)v0, v0.priorityQueueIndex(this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        for (int i = 0; i < this.size; ++i) {
            void var2_2;
            T node = this.queue[i];
            if (node == null) continue;
            var2_2.priorityQueueIndex(this, -1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public final void clearIgnoringIndexes() {
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean offer(T e) {
        void var1_1;
        if (e.priorityQueueIndex(this) != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + e.priorityQueueIndex(this) + " (expected: -1" + ") + e: " + e);
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        DefaultPriorityQueue defaultPriorityQueue = this;
        defaultPriorityQueue.bubbleUp(defaultPriorityQueue.size++, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T poll() {
        void var1_1;
        if (this.size == 0) {
            return null;
        }
        T result = this.queue[0];
        result.priorityQueueIndex(this, -1);
        T last = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            void var2_2;
            this.bubbleDown(0, var2_2);
        }
        return var1_1;
    }

    @Override
    public final T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object o) {
        void var1_1;
        try {
            PriorityQueueNode node = (PriorityQueueNode)o;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.removeTyped(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeTyped(T node) {
        void var1_1;
        int i = node.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)node, i)) {
            return false;
        }
        node.priorityQueueIndex(this, -1);
        if (--this.size == 0 || this.size == i) {
            this.queue[i] = null;
            return true;
        }
        T moved = this.queue[i] = this.queue[this.size];
        this.queue[this.size] = null;
        if (this.comparator.compare(var1_1, (void)moved) < 0) {
            this.bubbleDown(i, moved);
        } else {
            void var3_3;
            void var2_2;
            this.bubbleUp((int)var2_2, var3_3);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void priorityChanged(T node) {
        void var1_1;
        void var2_2;
        int i = node.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)node, i)) {
            return;
        }
        if (i != 0) {
            void var3_4;
            int iParent = i - 1 >>> 1;
            T parent = this.queue[iParent];
            if (this.comparator.compare((void)node, var3_4) < 0) {
                this.bubbleUp(i, node);
                return;
            }
        }
        this.bubbleDown((int)var2_2, var1_1);
    }

    @Override
    public final Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <X> X[] toArray(X[] a) {
        void var1_1;
        if (a.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, a.getClass());
        }
        System.arraycopy(this.queue, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return var1_1;
    }

    @Override
    public final Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    /*
     * WARNING - void declaration
     */
    private boolean contains(PriorityQueueNode node, int i) {
        void var2_2;
        void var1_1;
        return i >= 0 && i < this.size && var1_1.equals(this.queue[var2_2]);
    }

    /*
     * WARNING - void declaration
     */
    private void bubbleDown(int k, T node) {
        void var1_1;
        void var2_2;
        int half = this.size >>> 1;
        while (k < half) {
            int iChild = (k << 1) + 1;
            T child = this.queue[iChild];
            int rightChild = iChild + 1;
            if (rightChild < this.size && this.comparator.compare(child, this.queue[rightChild]) > 0) {
                iChild = rightChild;
                child = this.queue[iChild];
            }
            if (this.comparator.compare(node, child) <= 0) break;
            this.queue[k] = child;
            child.priorityQueueIndex(this, k);
            k = iChild;
        }
        this.queue[k] = node;
        var2_2.priorityQueueIndex(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void bubbleUp(int k, T node) {
        void var1_1;
        void var2_2;
        int iParent;
        T parent;
        while (k > 0 && this.comparator.compare(node, parent = this.queue[iParent = k - 1 >>> 1]) < 0) {
            void var3_3;
            this.queue[k] = parent;
            parent.priorityQueueIndex(this, k);
            k = var3_3;
        }
        this.queue[k] = node;
        var2_2.priorityQueueIndex(this, (int)var1_1);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.index < DefaultPriorityQueue.this.size;
        }

        @Override
        public final T next() {
            if (this.index >= DefaultPriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return DefaultPriorityQueue.this.queue[this.index++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

