/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.Cleaner;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void freeDirectBuffer(ByteBuffer buffer) {
        void var1_1;
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, buffer);
                return;
            }
            catch (Throwable throwable) {
                buffer = throwable;
                PlatformDependent0.throwException(throwable);
                return;
            }
        }
        CleanerJava9.freeDirectBufferPrivileged((ByteBuffer)var1_1);
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer buffer) {
        Exception error = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

            @Override
            public final Exception run() {
                try {
                    INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, buffer);
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    return invocationTargetException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    return illegalAccessException;
                }
                return null;
            }
        });
        if (error != null) {
            Exception exception;
            PlatformDependent0.throwException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Throwable error;
        Method method;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            final ByteBuffer buffer = ByteBuffer.allocateDirect(1);
            Object maybeInvokeMethod = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Object run() {
                    try {
                        void var1_1;
                        Method m = PlatformDependent0.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        m.invoke((Object)PlatformDependent0.UNSAFE, buffer);
                        return var1_1;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                        return noSuchMethodException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InvocationTargetException invocationTargetException2 = invocationTargetException;
                        return invocationTargetException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                }
            });
            if (maybeInvokeMethod instanceof Throwable) {
                method = null;
                error = (Throwable)maybeInvokeMethod;
            } else {
                method = (Method)((Object)error);
                error = null;
            }
        } else {
            method = null;
            error = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (error == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            void var1_1;
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", (Throwable)var1_1);
        }
        INVOKE_CLEANER = var0;
    }
}

