/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.Cleaner;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class CleanerJava6
implements Cleaner {
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;
    private static final Field CLEANER_FIELD;
    private static final InternalLogger logger;

    CleanerJava6() {
    }

    static boolean isSupported() {
        return CLEANER_FIELD_OFFSET != -1L || CLEANER_FIELD != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void freeDirectBuffer(ByteBuffer buffer) {
        void var1_1;
        if (!((ByteBuffer)buffer).isDirect()) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                CleanerJava6.freeDirectBuffer0((ByteBuffer)buffer);
                return;
            }
            catch (Throwable throwable) {
                buffer = throwable;
                PlatformDependent0.throwException(throwable);
                return;
            }
        }
        CleanerJava6.freeDirectBufferPrivileged((ByteBuffer)var1_1);
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer buffer) {
        Throwable cause = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

            @Override
            public final Throwable run() {
                try {
                    CleanerJava6.freeDirectBuffer0(buffer);
                    return null;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    return throwable;
                }
            }
        });
        if (cause != null) {
            Throwable throwable;
            PlatformDependent0.throwException(throwable);
        }
    }

    private static void freeDirectBuffer0(ByteBuffer buffer) throws Exception {
        Object cleaner;
        cleaner = CLEANER_FIELD_OFFSET == -1L ? CLEANER_FIELD.get(buffer) : PlatformDependent0.getObject(cleaner, CLEANER_FIELD_OFFSET);
        if (cleaner != null) {
            Object object;
            CLEAN_METHOD.invoke(object, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_1;
        void var0_4;
        void var3_2;
        Method clean;
        long fieldOffset;
        Field cleanerField;
        logger = InternalLoggerFactory.getInstance(CleanerJava6.class);
        Throwable error = null;
        final ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            Object cleaner;
            Object mayBeCleanerField = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Object run() {
                    try {
                        void var1_1;
                        Field cleanerField = direct.getClass().getDeclaredField("cleaner");
                        if (!PlatformDependent.hasUnsafe()) {
                            cleanerField.setAccessible(true);
                        }
                        return var1_1;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        return throwable;
                    }
                }
            });
            if (mayBeCleanerField instanceof Throwable) {
                throw (Throwable)mayBeCleanerField;
            }
            cleanerField = (Field)mayBeCleanerField;
            if (PlatformDependent.hasUnsafe()) {
                fieldOffset = PlatformDependent0.objectFieldOffset(cleanerField);
                cleaner = PlatformDependent0.getObject(direct, fieldOffset);
            } else {
                fieldOffset = -1L;
                cleaner = cleanerField.get(direct);
            }
            clean = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
            clean.invoke(cleaner, new Object[0]);
        }
        catch (Throwable t) {
            fieldOffset = -1L;
            clean = null;
            error = t;
            cleanerField = null;
        }
        if (error == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", error);
        }
        CLEANER_FIELD = var3_2;
        CLEANER_FIELD_OFFSET = var0_4;
        CLEAN_METHOD = var2_1;
    }
}

