/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;

public final class AppendableCharSequence
implements Appendable,
CharSequence {
    private char[] chars;
    private int pos;

    /*
     * WARNING - void declaration
     */
    public AppendableCharSequence(int length) {
        void var1_1;
        this.chars = new char[ObjectUtil.checkPositive((int)var1_1, "length")];
    }

    /*
     * WARNING - void declaration
     */
    private AppendableCharSequence(char[] chars) {
        void var1_1;
        this.chars = ObjectUtil.checkNonEmpty(chars, "chars");
        this.pos = ((void)var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLength(int length) {
        void var1_1;
        if (length < 0 || length > this.pos) {
            throw new IllegalArgumentException("length: " + length + " (length: >= 0, <= " + this.pos + ')');
        }
        this.pos = var1_1;
    }

    @Override
    public final int length() {
        return this.pos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char charAt(int index) {
        void var1_1;
        if (index > this.pos) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final char charAtUnsafe(int index) {
        void var1_1;
        return this.chars[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AppendableCharSequence subSequence(int start, int end) {
        void var2_2;
        void var1_1;
        if (start == end) {
            return new AppendableCharSequence(Math.min(16, this.chars.length));
        }
        return new AppendableCharSequence(Arrays.copyOfRange(this.chars, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AppendableCharSequence append(char c) {
        void var1_1;
        if (this.pos == this.chars.length) {
            void var2_2;
            char[] old = this.chars;
            this.chars = new char[old.length << 1];
            System.arraycopy(old, 0, this.chars, 0, ((void)var2_2).length);
        }
        this.chars[this.pos++] = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AppendableCharSequence append(CharSequence csq) {
        void var1_1;
        return this.append(csq, 0, var1_1.length());
    }

    @Override
    public final AppendableCharSequence append(CharSequence csq, int start, int end) {
        if (csq.length() < end) {
            throw new IndexOutOfBoundsException("expected: csq.length() >= (" + end + "),but actual is (" + csq.length() + ")");
        }
        int length = end - start;
        if (length > this.chars.length - this.pos) {
            this.chars = AppendableCharSequence.expand(this.chars, this.pos + length, this.pos);
        }
        if (csq instanceof AppendableCharSequence) {
            AppendableCharSequence appendableCharSequence = (AppendableCharSequence)csq;
            csq = appendableCharSequence.chars;
            System.arraycopy(appendableCharSequence.chars, start, this.chars, this.pos, length);
            this.pos += length;
            return this;
        }
        for (void i = var2_2; i < end; ++i) {
            this.chars[this.pos++] = csq.charAt((int)i);
        }
        return this;
    }

    public final void reset() {
        this.pos = 0;
    }

    @Override
    public final String toString() {
        return new String(this.chars, 0, this.pos);
    }

    /*
     * WARNING - void declaration
     */
    public final String substring(int start, int end) {
        void var2_2;
        void var1_1;
        int length = end - start;
        if (start > this.pos || length > this.pos) {
            throw new IndexOutOfBoundsException("expected: start and length <= (" + this.pos + ")");
        }
        return new String(this.chars, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String subStringUnsafe(int start, int end) {
        void var1_1;
        void var2_2;
        return new String(this.chars, start, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static char[] expand(char[] array, int neededSpace, int size) {
        void var1_2;
        void var2_3;
        char[] cArray;
        void var3_4;
        int newCapacity = array.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        char[] newArray = new char[var3_4];
        System.arraycopy(cArray, 0, newArray, 0, (int)var2_3);
        return var1_2;
    }
}

