/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseTask;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SucceededFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class UnorderedThreadPoolEventExecutor
extends ScheduledThreadPoolExecutor
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UnorderedThreadPoolEventExecutor.class);
    private final Promise<?> terminationFuture = GlobalEventExecutor.INSTANCE.newPromise();
    private final Set<EventExecutor> executorSet = Collections.singleton(this);

    /*
     * WARNING - void declaration
     */
    public UnorderedThreadPoolEventExecutor(int corePoolSize) {
        this((int)var1_1, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super((int)var1_1, (ThreadFactory)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UnorderedThreadPoolEventExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        this((int)var1_1, new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class), (RejectedExecutionHandler)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super((int)var1_1, (ThreadFactory)var2_2, (RejectedExecutionHandler)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final EventExecutor next() {
        return this;
    }

    @Override
    public final EventExecutorGroup parent() {
        return this;
    }

    @Override
    public final boolean inEventLoop() {
        return false;
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return false;
    }

    @Override
    public final <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    public final <V> ProgressivePromise<V> newProgressivePromise() {
        return new DefaultProgressivePromise(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V> Future<V> newSucceededFuture(V result) {
        void var1_1;
        return new SucceededFuture<void>(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V> Future<V> newFailedFuture(Throwable cause) {
        void var1_1;
        return new FailedFuture(this, (Throwable)var1_1);
    }

    @Override
    public final boolean isShuttingDown() {
        return this.isShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Runnable> shutdownNow() {
        void var1_1;
        List<Runnable> tasks = super.shutdownNow();
        this.terminationFuture.trySuccess(null);
        return var1_1;
    }

    @Override
    public final void shutdown() {
        super.shutdown();
        this.terminationFuture.trySuccess(null);
    }

    @Override
    public final Future<?> shutdownGracefully() {
        return this.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        this.shutdown();
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public final Iterator<EventExecutor> iterator() {
        return this.executorSet.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        void var2_2;
        if (runnable instanceof NonNotifyRunnable) {
            return task;
        }
        return new RunnableScheduledFutureTask((EventExecutor)this, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        void var2_2;
        return new RunnableScheduledFutureTask((EventExecutor)this, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return (ScheduledFuture)super.schedule((Runnable)var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return (ScheduledFuture)super.schedule(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return (ScheduledFuture)super.scheduleAtFixedRate((Runnable)var1_1, (long)var2_2, period, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return (ScheduledFuture)super.scheduleWithFixedDelay((Runnable)var1_1, (long)var2_2, delay, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable task) {
        void var1_1;
        return (Future)super.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Runnable task, T result) {
        void var2_2;
        void var1_1;
        return (Future)super.submit((Runnable)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        void var1_1;
        return (Future)super.submit(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command) {
        void var1_1;
        super.schedule(new NonNotifyRunnable((Runnable)var1_1), 0L, TimeUnit.NANOSECONDS);
    }

    private static final class NonNotifyRunnable
    implements Runnable {
        private final Runnable task;

        /*
         * WARNING - void declaration
         */
        NonNotifyRunnable(Runnable task) {
            void var1_1;
            this.task = var1_1;
        }

        @Override
        public final void run() {
            this.task.run();
        }
    }

    private static final class RunnableScheduledFutureTask<V>
    extends PromiseTask<V>
    implements ScheduledFuture<V>,
    RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> future;
        private final boolean wasCallable;

        /*
         * WARNING - void declaration
         */
        RunnableScheduledFutureTask(EventExecutor executor, RunnableScheduledFuture<V> future, boolean wasCallable) {
            super((EventExecutor)var1_1, future);
            void var3_3;
            void var2_2;
            void var1_1;
            this.future = var2_2;
            this.wasCallable = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final V runTask() throws Throwable {
            void var1_1;
            Object result = super.runTask();
            if (result == null && this.wasCallable) {
                assert (this.future.isDone());
                try {
                    return this.future.get();
                }
                catch (ExecutionException executionException) {
                    result = executionException;
                    throw executionException.getCause();
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            block4: {
                if (!this.isPeriodic()) {
                    super.run();
                    return;
                }
                if (!this.isDone()) {
                    try {
                        this.runTask();
                        return;
                    }
                    catch (Throwable cause) {
                        void var1_1;
                        if (this.tryFailureInternal(cause)) break block4;
                        logger.warn("Failure during execution of task", (Throwable)var1_1);
                    }
                }
            }
        }

        @Override
        public final boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long getDelay(TimeUnit unit) {
            void var1_1;
            return this.future.getDelay((TimeUnit)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compareTo(Delayed o) {
            void var1_1;
            return this.future.compareTo(var1_1);
        }
    }
}

