/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.concurrent.ThreadProperties;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTTING_DOWN = 3;
    private static final int ST_SHUTDOWN = 4;
    private static final int ST_TERMINATED = 5;
    private static final Runnable NOOP_TASK = new Runnable(){

        @Override
        public final void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventExecutor(EventExecutorGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        this((EventExecutorGroup)var1_1, new ThreadPerTaskExecutor((ThreadFactory)var2_2), (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventExecutor(EventExecutorGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this((EventExecutorGroup)var1_1, (Executor)new ThreadPerTaskExecutor((ThreadFactory)var2_2), (boolean)var3_3, maxPendingTasks, rejectedHandler);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventExecutor(EventExecutorGroup parent, Executor executor, boolean addTaskWakesUp) {
        this((EventExecutorGroup)var1_1, (Executor)var2_2, (boolean)var3_3, DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventExecutor(EventExecutorGroup parent, Executor executor, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        super((EventExecutorGroup)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.addTaskWakesUp = var3_3;
        this.maxPendingTasks = Math.max(16, maxPendingTasks);
        this.executor = ThreadExecutorMap.apply((Executor)var2_2, (EventExecutor)this);
        this.taskQueue = this.newTaskQueue(this.maxPendingTasks);
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedHandler, "rejectedHandler");
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventExecutor(EventExecutorGroup parent, Executor executor, boolean addTaskWakesUp, Queue<Runnable> taskQueue, RejectedExecutionHandler rejectedHandler) {
        super((EventExecutorGroup)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.addTaskWakesUp = var3_3;
        this.maxPendingTasks = DEFAULT_MAX_PENDING_EXECUTOR_TASKS;
        this.executor = ThreadExecutorMap.apply((Executor)var2_2, (EventExecutor)this);
        this.taskQueue = ObjectUtil.checkNotNull(taskQueue, "taskQueue");
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedHandler, "rejectedHandler");
    }

    @Deprecated
    protected Queue<Runnable> newTaskQueue() {
        SingleThreadEventExecutor singleThreadEventExecutor = this;
        return singleThreadEventExecutor.newTaskQueue(singleThreadEventExecutor.maxPendingTasks);
    }

    /*
     * WARNING - void declaration
     */
    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        void var1_1;
        return new LinkedBlockingQueue<Runnable>((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void interruptThread() {
        void var1_1;
        Thread currentThread = this.thread;
        if (currentThread == null) {
            this.interrupted = true;
            return;
        }
        var1_1.interrupt();
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    /*
     * WARNING - void declaration
     */
    protected static Runnable pollTaskFrom(Queue<Runnable> taskQueue) {
        void var1_1;
        Runnable task;
        while ((task = taskQueue.poll()) == WAKEUP_TASK) {
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Runnable takeTask() {
        void var2_2;
        Runnable task;
        assert (this.inEventLoop());
        if (!(this.taskQueue instanceof BlockingQueue)) {
            throw new UnsupportedOperationException();
        }
        BlockingQueue taskQueue = (BlockingQueue)this.taskQueue;
        do {
            ScheduledFutureTask<?> scheduledTask;
            if ((scheduledTask = this.peekScheduledTask()) == null) {
                Runnable task2 = null;
                try {
                    task2 = (Runnable)taskQueue.take();
                    if (task2 == WAKEUP_TASK) {
                        task2 = null;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return task2;
            }
            long delayNanos = scheduledTask.delayNanos();
            task = null;
            if (delayNanos > 0L) {
                try {
                    void var3_3;
                    task = (Runnable)taskQueue.poll((long)var3_3, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (task != null) continue;
            this.fetchFromScheduledTaskQueue();
            task = (Runnable)taskQueue.poll();
        } while (task == null);
        if (task == WAKEUP_TASK) {
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean fetchFromScheduledTaskQueue() {
        void var3_2;
        Runnable scheduledTask;
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long nanoTime = this.getCurrentTimeNanos();
        do {
            if ((scheduledTask = this.pollScheduledTask(nanoTime)) != null) continue;
            return true;
        } while (this.taskQueue.offer(scheduledTask));
        this.scheduledTaskQueue.add((ScheduledFutureTask)var3_2);
        return false;
    }

    private boolean executeExpiredScheduledTasks() {
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return false;
        }
        long nanoTime = this.getCurrentTimeNanos();
        Runnable scheduledTask = this.pollScheduledTask(nanoTime);
        if (scheduledTask == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(scheduledTask);
        } while ((scheduledTask = this.pollScheduledTask(nanoTime)) != null);
        return true;
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    public int pendingTasks() {
        return this.taskQueue.size();
    }

    /*
     * WARNING - void declaration
     */
    protected void addTask(Runnable task) {
        ObjectUtil.checkNotNull(task, "task");
        if (!this.offerTask(task)) {
            void var1_1;
            this.reject((Runnable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean offerTask(Runnable task) {
        void var1_1;
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean removeTask(Runnable task) {
        void var1_1;
        return this.taskQueue.remove(ObjectUtil.checkNotNull(var1_1, "task"));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean runAllTasks() {
        void var2_1;
        void var1_2;
        assert (this.inEventLoop());
        boolean ranAtLeastOne = false;
        do {
            boolean fetchedAll = this.fetchFromScheduledTaskQueue();
            SingleThreadEventExecutor singleThreadEventExecutor = this;
            if (!singleThreadEventExecutor.runAllTasksFrom(singleThreadEventExecutor.taskQueue)) continue;
            ranAtLeastOne = true;
        } while (var1_2 == false);
        if (ranAtLeastOne) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return (boolean)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean runScheduledAndExecutorTasks(int maxDrainAttempts) {
        void var3_2;
        SingleThreadEventExecutor singleThreadEventExecutor;
        boolean bl;
        assert (this.inEventLoop());
        int drainAttempt = 0;
        do {
            singleThreadEventExecutor = this;
        } while ((bl = singleThreadEventExecutor.runExistingTasksFrom(singleThreadEventExecutor.taskQueue) | this.executeExpiredScheduledTasks()) && ++drainAttempt < maxDrainAttempts);
        if (drainAttempt > 0) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return var3_2 > 0;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> taskQueue) {
        Runnable task = SingleThreadEventExecutor.pollTaskFrom(taskQueue);
        if (task == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(task);
        } while ((task = SingleThreadEventExecutor.pollTaskFrom(taskQueue)) != null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean runExistingTasksFrom(Queue<Runnable> taskQueue) {
        Runnable task = SingleThreadEventExecutor.pollTaskFrom(taskQueue);
        if (task == null) {
            return false;
        }
        int remaining = Math.min(this.maxPendingTasks, taskQueue.size());
        SingleThreadEventExecutor.safeExecute(task);
        while (remaining-- > 0 && (task = taskQueue.poll()) != null) {
            void var2_2;
            SingleThreadEventExecutor.safeExecute((Runnable)var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean runAllTasks(long timeoutNanos) {
        long lastExecutionTime;
        block2: {
            void var1_1;
            this.fetchFromScheduledTaskQueue();
            Runnable task = this.pollTask();
            if (task == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long deadline = timeoutNanos > 0L ? this.getCurrentTimeNanos() + var1_1 : 0L;
            long runTasks = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(task);
                if ((++runTasks & 0x3FL) == 0L && (lastExecutionTime = this.getCurrentTimeNanos()) >= deadline) break block2;
            } while ((task = this.pollTask()) != null);
            lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = lastExecutionTime;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    /*
     * WARNING - void declaration
     */
    protected long delayNanos(long currentTimeNanos) {
        void var1_1;
        void var3_2;
        currentTimeNanos -= SingleThreadEventExecutor.initialNanoTime();
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return var3_2.delayNanos((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected long deadlineNanos() {
        void var1_1;
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask == null) {
            return this.getCurrentTimeNanos() + SCHEDULE_PURGE_INTERVAL;
        }
        return var1_1.deadlineNanos();
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = this.getCurrentTimeNanos();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    /*
     * WARNING - void declaration
     */
    public void addShutdownHook(Runnable task) {
        void var1_1;
        if (this.inEventLoop()) {
            this.shutdownHooks.add(task);
            return;
        }
        this.execute(new Runnable(this, (Runnable)var1_1){
            final /* synthetic */ Runnable val$task;
            final /* synthetic */ SingleThreadEventExecutor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$task = runnable;
            }

            @Override
            public void run() {
                this.this$0.shutdownHooks.add(this.val$task);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void removeShutdownHook(Runnable task) {
        void var1_1;
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(task);
            return;
        }
        this.execute(new Runnable(this, (Runnable)var1_1){
            final /* synthetic */ Runnable val$task;
            final /* synthetic */ SingleThreadEventExecutor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$task = runnable;
            }

            @Override
            public void run() {
                this.this$0.shutdownHooks.remove(this.val$task);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean runShutdownHooks() {
        boolean bl;
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            Iterator iterator;
            ArrayList<Runnable> copy = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Runnable task2 = (Runnable)iterator.next();
                try {
                    SingleThreadEventExecutor.runTask(task2);
                    boolean task2 = true;
                }
                catch (Throwable t) {
                    void var1_3;
                    logger.warn("Shutdown hook raised an exception.", (Throwable)var1_3);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        void var3_2;
        void var1_1;
        boolean wakeup;
        int newState;
        int oldState;
        ObjectUtil.checkPositiveOrZero(quietPeriod, "quietPeriod");
        if (timeout < quietPeriod) {
            throw new IllegalArgumentException("timeout: " + timeout + " (expected >= quietPeriod (" + quietPeriod + "))");
        }
        ObjectUtil.checkNotNull(unit, "unit");
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean inEventLoop = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            wakeup = true;
            oldState = this.state;
            if (inEventLoop) {
                newState = 3;
                continue;
            }
            switch (oldState) {
                case 1: 
                case 2: {
                    newState = 3;
                    break;
                }
                default: {
                    newState = oldState;
                    wakeup = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState));
        this.gracefulShutdownQuietPeriod = unit.toNanos((long)var1_1);
        this.gracefulShutdownTimeout = unit.toNanos((long)var3_2);
        if (this.ensureThreadStarted(oldState)) {
            return this.terminationFuture;
        }
        if (wakeup) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(inEventLoop);
            }
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public void shutdown() {
        void var2_2;
        void var3_3;
        int newState;
        int oldState;
        if (this.isShutdown()) {
            return;
        }
        boolean inEventLoop = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            boolean wakeup = true;
            oldState = this.state;
            if (inEventLoop) {
                newState = 4;
                continue;
            }
            switch (oldState) {
                case 1: 
                case 2: 
                case 3: {
                    newState = 4;
                    break;
                }
                default: {
                    newState = oldState;
                    wakeup = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState));
        if (this.ensureThreadStarted((int)var3_3)) {
            return;
        }
        if (var2_2 != false) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                void var1_1;
                this.wakeup((boolean)var1_1);
            }
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean confirmShutdown() {
        void var1_1;
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = this.getCurrentTimeNanos();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long nanoTime = this.getCurrentTimeNanos();
        if (this.isShutdown() || nanoTime - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (var1_1 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        void var3_2;
        void var1_1;
        ObjectUtil.checkNotNull(unit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await((long)var1_1, (TimeUnit)var3_2);
        return this.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable task) {
        void var1_1;
        this.execute0((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lazyExecute(Runnable task) {
        void var1_1;
        this.lazyExecute0((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void execute0(Runnable task) {
        void var1_1;
        ObjectUtil.checkNotNull(task, "task");
        this.execute(task, this.wakesUpForTask((Runnable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void lazyExecute0(Runnable task) {
        void var1_1;
        this.execute((Runnable)ObjectUtil.checkNotNull(var1_1, "task"), false);
    }

    /*
     * WARNING - void declaration
     */
    private void execute(Runnable task, boolean immediate) {
        void var2_2;
        boolean inEventLoop = this.inEventLoop();
        this.addTask(task);
        if (!inEventLoop) {
            this.startThread();
            if (this.isShutdown()) {
                boolean reject = false;
                try {
                    void var1_1;
                    if (this.removeTask((Runnable)var1_1)) {
                        reject = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                if (reject) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && var2_2 != false) {
            void var3_3;
            this.wakeup((boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        void var1_1;
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var2_2;
        void var1_1;
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        void var1_1;
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        void var2_2;
        void var1_1;
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    private void throwIfInEventLoop(String method) {
        if (this.inEventLoop()) {
            void var1_1;
            throw new RejectedExecutionException("Calling " + (String)var1_1 + " from within the EventLoop is not allowed");
        }
    }

    public final ThreadProperties threadProperties() {
        ThreadProperties threadProperties;
        ThreadProperties threadProperties2 = this.threadProperties;
        if (threadProperties2 == null) {
            Thread thread = this.thread;
            if (thread == null) {
                assert (!this.inEventLoop());
                this.submit(NOOP_TASK).syncUninterruptibly();
                thread = this.thread;
                assert (thread != null);
            }
            if (!PROPERTIES_UPDATER.compareAndSet(this, null, threadProperties = new DefaultThreadProperties((Thread)((Object)threadProperties)))) {
                threadProperties = this.threadProperties;
            }
        }
        return threadProperties;
    }

    protected boolean wakesUpForTask(Runnable task) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    /*
     * WARNING - void declaration
     */
    protected final void reject(Runnable task) {
        void var1_1;
        this.rejectedExecutionHandler.rejected((Runnable)var1_1, this);
    }

    private void startThread() {
        if (this.state == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            try {
                this.doStartThread();
                return;
            }
            catch (Throwable throwable) {
                STATE_UPDATER.compareAndSet(this, 2, 1);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean ensureThreadStarted(int oldState) {
        if (oldState == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable cause) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(cause);
                if (!(cause instanceof Exception)) {
                    void var1_2;
                    PlatformDependent.throwException((Throwable)var1_2);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        assert (this.thread == null);
        this.executor.execute(new Runnable(this){
            final /* synthetic */ SingleThreadEventExecutor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                int oldState;
                SingleThreadEventExecutor.access$102(this.this$0, Thread.currentThread());
                if (this.this$0.interrupted) {
                    this.this$0.thread.interrupt();
                }
                this.this$0.updateLastExecutionTime();
                this.this$0.run();
                while ((oldState = this.this$0.state) < 3 && !STATE_UPDATER.compareAndSet(this.this$0, oldState, 3)) {
                }
                if (this.this$0.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                    logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                }
                try {
                    while (!this.this$0.confirmShutdown()) {
                    }
                    while ((oldState = this.this$0.state) < 4 && !STATE_UPDATER.compareAndSet(this.this$0, oldState, 4)) {
                    }
                    this.this$0.confirmShutdown();
                }
                finally {
                    try {
                        this.this$0.cleanup();
                    }
                    finally {
                        FastThreadLocal.removeAll();
                        STATE_UPDATER.set(this.this$0, 5);
                        this.this$0.threadLock.countDown();
                        int numUserTasks = this.this$0.drainTasks();
                        if (numUserTasks > 0 && logger.isWarnEnabled()) {
                            logger.warn("An event executor terminated with non-empty task queue (" + numUserTasks + ')');
                        }
                        this.this$0.terminationFuture.setSuccess(null);
                    }
                }
                return;
                catch (Throwable t) {
                    try {
                        logger.warn("Unexpected exception from an event executor: ", t);
                    }
                    catch (Throwable throwable) {}
                    finally {
                        while ((oldState = this.this$0.state) < 3 && !STATE_UPDATER.compareAndSet(this.this$0, oldState, 3)) {
                        }
                        while (!this.this$0.confirmShutdown()) {
                        }
                        while ((oldState = this.this$0.state) < 4 && !STATE_UPDATER.compareAndSet(this.this$0, oldState, 4)) {
                        }
                        this.this$0.confirmShutdown();
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    final int drainTasks() {
        void var1_1;
        Runnable runnable;
        int numTasks = 0;
        while ((runnable = this.taskQueue.poll()) != null) {
            void var2_2;
            if (WAKEUP_TASK == var2_2) continue;
            ++numTasks;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Thread access$102(SingleThreadEventExecutor x0, Thread x1) {
        void var1_1;
        x0.thread = var1_1;
        return x0.thread;
    }

    private static final class DefaultThreadProperties
    implements ThreadProperties {
        private final Thread t;

        /*
         * WARNING - void declaration
         */
        DefaultThreadProperties(Thread t) {
            void var1_1;
            this.t = var1_1;
        }

        @Override
        public final Thread.State state() {
            return this.t.getState();
        }

        @Override
        public final int priority() {
            return this.t.getPriority();
        }

        @Override
        public final boolean isInterrupted() {
            return this.t.isInterrupted();
        }

        @Override
        public final boolean isDaemon() {
            return this.t.isDaemon();
        }

        @Override
        public final String name() {
            return this.t.getName();
        }

        @Override
        public final long id() {
            return this.t.getId();
        }

        @Override
        public final StackTraceElement[] stackTrace() {
            return this.t.getStackTrace();
        }

        @Override
        public final boolean isAlive() {
            return this.t.isAlive();
        }
    }

    @Deprecated
    protected static interface NonWakeupRunnable
    extends AbstractEventExecutor.LazyRunnable {
    }
}

