/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.PromiseTask;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V>,
PriorityQueueNode {
    private long id;
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;

    /*
     * WARNING - void declaration
     */
    ScheduledFutureTask(AbstractScheduledEventExecutor executor, Runnable runnable, long nanoTime) {
        super((EventExecutor)var1_1, (Runnable)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.deadlineNanos = var3_3;
        this.periodNanos = 0L;
    }

    /*
     * WARNING - void declaration
     */
    ScheduledFutureTask(AbstractScheduledEventExecutor executor, Runnable runnable, long nanoTime, long period) {
        super((EventExecutor)var1_1, (Runnable)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.deadlineNanos = var3_3;
        this.periodNanos = ScheduledFutureTask.validatePeriod(period);
    }

    /*
     * WARNING - void declaration
     */
    ScheduledFutureTask(AbstractScheduledEventExecutor executor, Callable<V> callable, long nanoTime, long period) {
        super((EventExecutor)var1_1, var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.deadlineNanos = var3_3;
        this.periodNanos = ScheduledFutureTask.validatePeriod(period);
    }

    /*
     * WARNING - void declaration
     */
    ScheduledFutureTask(AbstractScheduledEventExecutor executor, Callable<V> callable, long nanoTime) {
        super((EventExecutor)var1_1, var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.deadlineNanos = var3_3;
        this.periodNanos = 0L;
    }

    private static long validatePeriod(long period) {
        long l;
        if (period == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    final ScheduledFutureTask<V> setId(long id) {
        if (this.id == 0L) {
            void var1_1;
            this.id = var1_1;
        }
        return this;
    }

    @Override
    protected final EventExecutor executor() {
        return super.executor();
    }

    public final long deadlineNanos() {
        return this.deadlineNanos;
    }

    final void setConsumed() {
        if (this.periodNanos == 0L) {
            assert (this.scheduledExecutor().getCurrentTimeNanos() >= this.deadlineNanos);
            this.deadlineNanos = 0L;
        }
    }

    public final long delayNanos() {
        if (this.deadlineNanos == 0L) {
            return 0L;
        }
        ScheduledFutureTask scheduledFutureTask = this;
        return scheduledFutureTask.delayNanos(scheduledFutureTask.scheduledExecutor().getCurrentTimeNanos());
    }

    /*
     * WARNING - void declaration
     */
    static long deadlineToDelayNanos(long currentTimeNanos, long deadlineNanos) {
        long l;
        void var2_1;
        if (deadlineNanos == 0L) {
            return 0L;
        }
        return Math.max(0L, (long)(var2_1 - l));
    }

    public final long delayNanos(long currentTimeNanos) {
        return ScheduledFutureTask.deadlineToDelayNanos(currentTimeNanos, this.deadlineNanos);
    }

    @Override
    public final long getDelay(TimeUnit unit) {
        return unit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Delayed o) {
        void var1_1;
        void var3_2;
        if (this == o) {
            return 0;
        }
        ScheduledFutureTask that = (ScheduledFutureTask)o;
        long d = this.deadlineNanos() - that.deadlineNanos();
        if (d < 0L) {
            return -1;
        }
        if (var3_2 > 0L) {
            return 1;
        }
        if (this.id < that.id) {
            return -1;
        }
        assert (this.id != var1_1.id);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        assert (this.executor().inEventLoop());
        try {
            block10: {
                block9: {
                    block8: {
                        if (this.delayNanos() > 0L) {
                            if (this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().removeTyped(this);
                                return;
                            }
                            this.scheduledExecutor().scheduleFromEventLoop(this);
                            return;
                        }
                        if (this.periodNanos != 0L) break block8;
                        if (!this.setUncancellableInternal()) break block9;
                        break block10;
                    }
                    if (!this.isCancelled()) {
                        this.runTask();
                        if (!this.executor().isShutdown()) {
                            this.deadlineNanos = this.periodNanos > 0L ? (this.deadlineNanos += this.periodNanos) : this.scheduledExecutor().getCurrentTimeNanos() - this.periodNanos;
                            if (!this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().add(this);
                            }
                        }
                    }
                }
                return;
            }
            Object result = this.runTask();
            this.setSuccessInternal(result);
        }
        catch (Throwable cause) {
            void var1_2;
            this.setFailureInternal((Throwable)var1_2);
        }
    }

    private AbstractScheduledEventExecutor scheduledExecutor() {
        return (AbstractScheduledEventExecutor)this.executor();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        boolean canceled = super.cancel(mayInterruptIfRunning);
        if (canceled) {
            this.scheduledExecutor().removeScheduled(this);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final boolean cancelWithoutRemove(boolean mayInterruptIfRunning) {
        void var1_1;
        return super.cancel((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final StringBuilder toStringBuilder() {
        void var1_1;
        StringBuilder buf = super.toStringBuilder();
        buf.setCharAt(buf.length() - 1, ',');
        return var1_1.append(" deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }

    @Override
    public final int priorityQueueIndex(DefaultPriorityQueue<?> queue) {
        return this.queueIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void priorityQueueIndex(DefaultPriorityQueue<?> queue, int i) {
        void var2_2;
        this.queueIndex = var2_2;
    }
}

