/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class RejectedExecutionHandlers {
    private static final RejectedExecutionHandler REJECT = new RejectedExecutionHandler(){

        @Override
        public final void rejected(Runnable task, SingleThreadEventExecutor executor) {
            throw new RejectedExecutionException();
        }
    };

    private RejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler reject() {
        return REJECT;
    }

    /*
     * WARNING - void declaration
     */
    public static RejectedExecutionHandler backoff(int retries, long backoffAmount, TimeUnit unit) {
        int n;
        void var1_1;
        void var3_2;
        ObjectUtil.checkPositive(retries, "retries");
        final long backOffNanos = var3_2.toNanos((long)var1_1);
        return new RejectedExecutionHandler(){

            @Override
            public final void rejected(Runnable task, SingleThreadEventExecutor executor) {
                if (!executor.inEventLoop()) {
                    for (int i = 0; i < n; ++i) {
                        executor.wakeup(false);
                        LockSupport.parkNanos(backOffNanos);
                        if (!executor.offerTask(task)) continue;
                        return;
                    }
                }
                throw new RejectedExecutionException();
            }
        };
    }
}

