/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;

class PromiseTask<V>
extends DefaultPromise<V>
implements RunnableFuture<V> {
    private static final Runnable COMPLETED = new SentinelRunnable("COMPLETED");
    private static final Runnable CANCELLED = new SentinelRunnable("CANCELLED");
    private static final Runnable FAILED = new SentinelRunnable("FAILED");
    private Object task;

    /*
     * WARNING - void declaration
     */
    PromiseTask(EventExecutor executor, Runnable runnable, V result) {
        super((EventExecutor)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.task = result == null ? runnable : new RunnableAdapter<void>((Runnable)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    PromiseTask(EventExecutor executor, Runnable runnable) {
        super((EventExecutor)var1_1);
        void var2_2;
        void var1_1;
        this.task = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    PromiseTask(EventExecutor executor, Callable<V> callable) {
        super((EventExecutor)var1_1);
        void var2_2;
        void var1_1;
        this.task = var2_2;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        return this == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    V runTask() throws Throwable {
        void var1_1;
        Object task = this.task;
        if (task instanceof Callable) {
            return ((Callable)task).call();
        }
        ((Runnable)var1_1).run();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            if (this.setUncancellableInternal()) {
                V result = this.runTask();
                this.setSuccessInternal(result);
            }
            return;
        }
        catch (Throwable e) {
            void var1_2;
            this.setFailureInternal((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean clearTaskAfterCompletion(boolean done, Runnable result) {
        void var1_1;
        if (done) {
            void var2_2;
            this.task = var2_2;
        }
        return (boolean)var1_1;
    }

    @Override
    public final Promise<V> setFailure(Throwable cause) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    protected final Promise<V> setFailureInternal(Throwable cause) {
        void var1_1;
        super.setFailure((Throwable)var1_1);
        this.clearTaskAfterCompletion(true, FAILED);
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable cause) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean tryFailureInternal(Throwable cause) {
        void var1_1;
        PromiseTask promiseTask = this;
        return promiseTask.clearTaskAfterCompletion(super.tryFailure((Throwable)var1_1), FAILED);
    }

    @Override
    public final Promise<V> setSuccess(V result) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    protected final Promise<V> setSuccessInternal(V result) {
        void var1_1;
        super.setSuccess(var1_1);
        this.clearTaskAfterCompletion(true, COMPLETED);
        return this;
    }

    @Override
    public final boolean trySuccess(V result) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean trySuccessInternal(V result) {
        void var1_1;
        PromiseTask promiseTask = this;
        return promiseTask.clearTaskAfterCompletion(super.trySuccess(var1_1), COMPLETED);
    }

    @Override
    public final boolean setUncancellable() {
        throw new IllegalStateException();
    }

    protected final boolean setUncancellableInternal() {
        return super.setUncancellable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        PromiseTask promiseTask = this;
        return promiseTask.clearTaskAfterCompletion(super.cancel((boolean)var1_1), CANCELLED);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected StringBuilder toStringBuilder() {
        void var1_1;
        StringBuilder buf = super.toStringBuilder();
        buf.setCharAt(buf.length() - 1, ',');
        return var1_1.append(" task: ").append(this.task).append(')');
    }

    private static class SentinelRunnable
    implements Runnable {
        private final String name;

        /*
         * WARNING - void declaration
         */
        SentinelRunnable(String name) {
            void var1_1;
            this.name = var1_1;
        }

        @Override
        public void run() {
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class RunnableAdapter<T>
    implements Callable<T> {
        final Runnable task;
        final T result;

        /*
         * WARNING - void declaration
         */
        RunnableAdapter(Runnable task, T result) {
            void var2_2;
            void var1_1;
            this.task = var1_1;
            this.result = var2_2;
        }

        @Override
        public final T call() {
            this.task.run();
            return this.result;
        }

        public final String toString() {
            return "Callable(task: " + this.task + ", result: " + this.result + ')';
        }
    }
}

