/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promises) {
        this(true, (Promise<? super V>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public PromiseNotifier(boolean logNotifyFailure, Promise<? super V> ... promises) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull(promises, "promises");
        Promise<? super V>[] promiseArray = promises;
        int n = promises.length;
        for (int i = 0; i < n; ++i) {
            Promise<? super V> promise = promiseArray[i];
            ObjectUtil.checkNotNullWithIAE(promise, "promise");
        }
        this.promises = (Promise[])var2_2.clone();
        this.logNotifyFailure = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <V, F extends Future<V>> F cascade(F future, Promise<? super V> promise) {
        void var1_1;
        F f;
        return PromiseNotifier.cascade(true, f, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <V, F extends Future<V>> F cascade(boolean logNotifyFailure, final F future, Promise<? super V> promise) {
        void var1_1;
        void var2_2;
        boolean bl;
        promise.addListener(new FutureListener(){

            @Override
            public final void operationComplete(Future f) {
                if (f.isCancelled()) {
                    future.cancel(false);
                }
            }
        });
        future.addListener(new PromiseNotifier(bl, new Promise[]{promise}, (Promise)var2_2, future){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ Future val$future;
            {
                void var2_2;
                void var1_1;
                this.val$promise = promise;
                this.val$future = future;
                super((boolean)var1_1, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void operationComplete(Future f) throws Exception {
                void var1_1;
                if (this.val$promise.isCancelled() && var1_1.isCancelled()) {
                    return;
                }
                2 v0 = this;
                super.operationComplete(v0.val$future);
            }
        });
        return var1_1;
    }

    @Override
    public void operationComplete(F future) throws Exception {
        Object result;
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (future.isSuccess()) {
            result = future.get();
            Promise<? super V>[] promiseArray = this.promises;
            int n = this.promises.length;
            for (int i = 0; i < n; ++i) {
                Promise<? super V> promise = promiseArray[i];
                PromiseNotificationUtil.trySuccess(promise, result, internalLogger);
            }
            return;
        }
        if (result.isCancelled()) {
            result = this.promises;
            int n = this.promises.length;
            for (int i = 0; i < n; ++i) {
                Object v = result[i];
                PromiseNotificationUtil.tryCancel(v, internalLogger);
            }
            return;
        }
        Throwable cause = result.cause();
        Promise<? super V>[] promiseArray = this.promises;
        int n = this.promises.length;
        for (int i = 0; i < n; ++i) {
            Promise<? super V> promise = promiseArray[i];
            PromiseNotificationUtil.tryFailure(promise, cause, internalLogger);
        }
    }
}

