/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class NonStickyEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutorGroup group;
    private final int maxTaskExecutePerRun;

    /*
     * WARNING - void declaration
     */
    public NonStickyEventExecutorGroup(EventExecutorGroup group) {
        this((EventExecutorGroup)var1_1, 1024);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NonStickyEventExecutorGroup(EventExecutorGroup group, int maxTaskExecutePerRun) {
        void var2_2;
        void var1_1;
        this.group = NonStickyEventExecutorGroup.verify((EventExecutorGroup)var1_1);
        this.maxTaskExecutePerRun = ObjectUtil.checkPositive((int)var2_2, "maxTaskExecutePerRun");
    }

    /*
     * WARNING - void declaration
     */
    private static EventExecutorGroup verify(EventExecutorGroup group) {
        EventExecutorGroup eventExecutorGroup;
        for (EventExecutor executor : ObjectUtil.checkNotNull(group, "group")) {
            void var2_2;
            if (!(executor instanceof OrderedEventExecutor)) continue;
            throw new IllegalArgumentException("EventExecutorGroup " + group + " contains OrderedEventExecutors: " + var2_2);
        }
        return eventExecutorGroup;
    }

    /*
     * WARNING - void declaration
     */
    private NonStickyOrderedEventExecutor newExecutor(EventExecutor executor) {
        void var1_1;
        return new NonStickyOrderedEventExecutor((EventExecutor)var1_1, this.maxTaskExecutePerRun);
    }

    @Override
    public final boolean isShuttingDown() {
        return this.group.isShuttingDown();
    }

    @Override
    public final Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        void var3_2;
        void var1_1;
        return this.group.shutdownGracefully((long)var1_1, (long)var3_2, unit);
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.group.terminationFuture();
    }

    @Override
    public final void shutdown() {
        this.group.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.group.shutdownNow();
    }

    @Override
    public final EventExecutor next() {
        NonStickyEventExecutorGroup nonStickyEventExecutorGroup = this;
        return nonStickyEventExecutorGroup.newExecutor(nonStickyEventExecutorGroup.group.next());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<EventExecutor> iterator() {
        void var1_1;
        Iterator<EventExecutor> itr = this.group.iterator();
        return new Iterator<EventExecutor>(this, (Iterator)var1_1){
            final /* synthetic */ Iterator val$itr;
            final /* synthetic */ NonStickyEventExecutorGroup this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$itr = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$itr.hasNext();
            }

            @Override
            public EventExecutor next() {
                return NonStickyEventExecutorGroup.access$000(this.this$0, (EventExecutor)this.val$itr.next());
            }

            @Override
            public void remove() {
                this.val$itr.remove();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable task) {
        void var1_1;
        return this.group.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Runnable task, T result) {
        void var2_2;
        void var1_1;
        return this.group.submit((Runnable)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        void var1_1;
        return this.group.submit(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.group.schedule((Runnable)var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.group.schedule(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.group.scheduleAtFixedRate((Runnable)var1_1, (long)var2_2, period, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        return this.group.scheduleWithFixedDelay((Runnable)var1_1, (long)var2_2, delay, unit);
    }

    @Override
    public final boolean isShutdown() {
        return this.group.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.group.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        void var3_2;
        void var1_1;
        return this.group.awaitTermination((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        void var1_1;
        return this.group.invokeAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        void var2_2;
        void var1_1;
        return this.group.invokeAll(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        void var1_1;
        return this.group.invokeAny(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var2_2;
        void var1_1;
        return this.group.invokeAny(var1_1, (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command) {
        void var1_1;
        this.group.execute((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ NonStickyOrderedEventExecutor access$000(NonStickyEventExecutorGroup x0, EventExecutor x1) {
        void var1_1;
        return x0.newExecutor((EventExecutor)var1_1);
    }

    private static final class NonStickyOrderedEventExecutor
    extends AbstractEventExecutor
    implements OrderedEventExecutor,
    Runnable {
        private final EventExecutor executor;
        private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
        private static final int NONE = 0;
        private static final int SUBMITTED = 1;
        private static final int RUNNING = 2;
        private final AtomicInteger state = new AtomicInteger();
        private final int maxTaskExecutePerRun;
        private final AtomicReference<Thread> executingThread = new AtomicReference();

        /*
         * WARNING - void declaration
         */
        NonStickyOrderedEventExecutor(EventExecutor executor, int maxTaskExecutePerRun) {
            super(executor);
            void var2_2;
            void var1_1;
            this.executor = var1_1;
            this.maxTaskExecutePerRun = var2_2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final void run() {
            if (!this.state.compareAndSet(1, 2)) {
                return;
            }
            current = Thread.currentThread();
            this.executingThread.set(current);
            while (true) lbl-1000:
            // 3 sources

            {
                block12: {
                    for (i = 0; i < this.maxTaskExecutePerRun && (task = this.tasks.poll()) != null; ++i) {
                        NonStickyOrderedEventExecutor.safeExecute((Runnable)var3_3);
                    }
                    if (i != this.maxTaskExecutePerRun) break block12;
                    try {
                        this.state.set(1);
                        this.executingThread.compareAndSet(current, null);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable v0) {
                        this.state.set(2);
                    }
                    ** GOTO lbl-1000
                }
                this.state.set(0);
                if (this.tasks.isEmpty() || !this.state.compareAndSet(0, 2)) break;
            }
            this.executingThread.compareAndSet(current, null);
            return;
            catch (Throwable var3_4) {
                if (var2_2 == this.maxTaskExecutePerRun) {
                    try {
                        this.state.set(1);
                        this.executingThread.compareAndSet(current, null);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable v1) {
                        this.state.set(2);
                    }
                } else {
                    this.state.set(0);
                    if (this.tasks.isEmpty() || !this.state.compareAndSet(0, 2)) {
                        this.executingThread.compareAndSet(current, null);
                        return;
                    }
                }
                throw var3_4;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean inEventLoop(Thread thread) {
            void var1_1;
            return this.executingThread.get() == var1_1;
        }

        @Override
        public final boolean isShuttingDown() {
            return this.executor.isShutdown();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            void var3_2;
            void var1_1;
            return this.executor.shutdownGracefully((long)var1_1, (long)var3_2, unit);
        }

        @Override
        public final Future<?> terminationFuture() {
            return this.executor.terminationFuture();
        }

        @Override
        public final void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public final boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.executor.isTerminated();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            void var3_2;
            void var1_1;
            return this.executor.awaitTermination((long)var1_1, (TimeUnit)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable command) {
            void var1_1;
            if (!this.tasks.offer((Runnable)var1_1)) {
                throw new RejectedExecutionException();
            }
            if (this.state.compareAndSet(0, 1)) {
                this.executor.execute(this);
            }
        }
    }
}

