/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooserFactory.EventExecutorChooser chooser;

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventExecutorGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        this((int)var1_1, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor((ThreadFactory)var2_2)), (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventExecutorGroup(int nThreads, Executor executor, Object ... args) {
        this((int)var1_1, (Executor)var2_2, DefaultEventExecutorChooserFactory.INSTANCE, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventExecutorGroup(int nThreads2, Executor executor, EventExecutorChooserFactory chooserFactory, Object ... args) {
        void var1_3;
        void var3_8;
        ObjectUtil.checkPositive(nThreads2, "nThreads");
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(this.newDefaultThreadFactory());
        }
        this.children = new EventExecutor[nThreads2];
        for (int i = 0; i < nThreads2; ++i) {
            try {
                try {
                    this.children[i] = this.newChild(executor, args);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to create a child event loop", e);
                }
            }
            catch (Throwable nThreads2) {
                int j;
                for (j = 0; j < i; ++j) {
                    this.children[j].shutdownGracefully();
                }
                for (j = 0; j < i; ++j) {
                    EventExecutor e = this.children[j];
                    try {
                        while (!e.isTerminated()) {
                            e.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw nThreads2;
            }
        }
        this.chooser = var3_8.newChooser(this.children);
        FutureListener<Object> terminationListener = new FutureListener<Object>(this){
            final /* synthetic */ MultithreadEventExecutorGroup this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (this.this$0.terminatedChildren.incrementAndGet() == this.this$0.children.length) {
                    this.this$0.terminationFuture.setSuccess(null);
                }
            }
        };
        EventExecutor[] nThreads2 = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = nThreads2[i];
            eventExecutor.terminationFuture().addListener(terminationListener);
        }
        LinkedHashSet childrenSet = new LinkedHashSet(this.children.length);
        Collections.addAll(childrenSet, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(var1_3);
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    public final int executorCount() {
        return this.children.length;
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            eventExecutor.shutdownGracefully(quietPeriod, timeout, unit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            EventExecutor eventExecutor = eventExecutorArray[i];
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        void var1_1;
        void var3_3;
        long deadline = System.nanoTime() + var3_3.toNanos((long)var1_1);
        EventExecutor[] eventExecutorArray = this.children;
        int n = this.children.length;
        block0: for (int i = 0; i < n; ++i) {
            long timeLeft;
            EventExecutor l = eventExecutorArray[i];
            while ((timeLeft = deadline - System.nanoTime()) > 0L) {
                if (!l.awaitTermination(timeLeft, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }
}

