/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultProgressivePromise;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public final class ImmediateEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ImmediateEventExecutor.class);
    public static final ImmediateEventExecutor INSTANCE = new ImmediateEventExecutor();
    private static final FastThreadLocal<Queue<Runnable>> DELAYED_RUNNABLES = new FastThreadLocal<Queue<Runnable>>(){

        @Override
        protected final Queue<Runnable> initialValue() throws Exception {
            return new ArrayDeque<Runnable>();
        }
    };
    private static final FastThreadLocal<Boolean> RUNNING = new FastThreadLocal<Boolean>(){

        @Override
        protected final Boolean initialValue() throws Exception {
            return Boolean.FALSE;
        }
    };
    private final Future<?> terminationFuture = new FailedFuture(GlobalEventExecutor.INSTANCE, new UnsupportedOperationException());

    private ImmediateEventExecutor() {
    }

    @Override
    public final boolean inEventLoop() {
        return true;
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return true;
    }

    @Override
    public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public final void shutdown() {
    }

    @Override
    public final boolean isShuttingDown() {
        return false;
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return false;
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command) {
        block13: {
            void var1_1;
            block14: {
                Runnable runnable;
                Queue<Runnable> delayedRunnables;
                ObjectUtil.checkNotNull(command, "command");
                if (RUNNING.get().booleanValue()) break block14;
                RUNNING.set(Boolean.TRUE);
                try {
                    command.run();
                    delayedRunnables = DELAYED_RUNNABLES.get();
                }
                catch (Throwable cause) {
                    Queue<Runnable> delayedRunnables2;
                    try {
                        logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)cause);
                        delayedRunnables2 = DELAYED_RUNNABLES.get();
                    }
                    catch (Throwable throwable) {
                        Runnable runnable2;
                        Queue<Runnable> delayedRunnables3 = DELAYED_RUNNABLES.get();
                        while ((runnable2 = delayedRunnables3.poll()) != null) {
                            try {
                                runnable2.run();
                            }
                            catch (Throwable cause2) {
                                void var3_9;
                                logger.info("Throwable caught while executing Runnable {}", (Object)var3_9, (Object)cause2);
                            }
                        }
                        RUNNING.set(Boolean.FALSE);
                        throw throwable;
                    }
                    while ((runnable = delayedRunnables2.poll()) != null) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable cause3) {
                            logger.info("Throwable caught while executing Runnable {}", (Object)var1_1, (Object)cause3);
                        }
                    }
                    RUNNING.set(Boolean.FALSE);
                    break block13;
                }
                while ((runnable = delayedRunnables.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable cause) {
                        logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)cause);
                    }
                }
                RUNNING.set(Boolean.FALSE);
                break block13;
            }
            DELAYED_RUNNABLES.get().add((Runnable)var1_1);
        }
    }

    @Override
    public final <V> Promise<V> newPromise() {
        return new ImmediatePromise(this);
    }

    @Override
    public final <V> ProgressivePromise<V> newProgressivePromise() {
        return new ImmediateProgressivePromise(this);
    }

    static class ImmediateProgressivePromise<V>
    extends DefaultProgressivePromise<V> {
        /*
         * WARNING - void declaration
         */
        ImmediateProgressivePromise(EventExecutor executor) {
            super((EventExecutor)var1_1);
            void var1_1;
        }

        @Override
        protected void checkDeadLock() {
        }
    }

    static class ImmediatePromise<V>
    extends DefaultPromise<V> {
        /*
         * WARNING - void declaration
         */
        ImmediatePromise(EventExecutor executor) {
            super((EventExecutor)var1_1);
            void var1_1;
        }

        @Override
        protected void checkDeadLock() {
        }
    }
}

