/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FailedFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GlobalEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    private static final InternalLogger logger;
    private static final long SCHEDULE_QUIET_PERIOD_INTERVAL;
    public static final GlobalEventExecutor INSTANCE;
    final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    final ScheduledFutureTask<Void> quietPeriodTask = new ScheduledFutureTask<Object>((AbstractScheduledEventExecutor)this, Executors.callable(new Runnable(this){
        final /* synthetic */ GlobalEventExecutor this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
        }
    }, null), GlobalEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), SCHEDULE_QUIET_PERIOD_INTERVAL), -SCHEDULE_QUIET_PERIOD_INTERVAL);
    final ThreadFactory threadFactory;
    private final TaskRunner taskRunner = new TaskRunner(this);
    private final AtomicBoolean started = new AtomicBoolean();
    volatile Thread thread;
    private final Future<?> terminationFuture = new FailedFuture(this, new UnsupportedOperationException());

    private GlobalEventExecutor() {
        this.scheduledTaskQueue().add(this.quietPeriodTask);
        this.threadFactory = ThreadExecutorMap.apply(new DefaultThreadFactory(DefaultThreadFactory.toPoolName(this.getClass()), false, 5, null), (EventExecutor)this);
    }

    /*
     * WARNING - void declaration
     */
    final Runnable takeTask() {
        void var2_2;
        Runnable task;
        BlockingQueue<Runnable> taskQueue = this.taskQueue;
        do {
            ScheduledFutureTask<?> scheduledTask;
            if ((scheduledTask = this.peekScheduledTask()) == null) {
                Runnable task2 = null;
                try {
                    task2 = taskQueue.take();
                }
                catch (InterruptedException interruptedException) {}
                return task2;
            }
            long delayNanos = scheduledTask.delayNanos();
            task = null;
            if (delayNanos > 0L) {
                try {
                    void var3_3;
                    task = taskQueue.poll((long)var3_3, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (task != null) continue;
            this.fetchFromScheduledTaskQueue();
            task = (Runnable)taskQueue.poll();
        } while (task == null);
        return var2_2;
    }

    private void fetchFromScheduledTaskQueue() {
        long nanoTime = this.getCurrentTimeNanos();
        Runnable scheduledTask = this.pollScheduledTask(nanoTime);
        while (scheduledTask != null) {
            this.taskQueue.add(scheduledTask);
            scheduledTask = this.pollScheduledTask(nanoTime);
        }
    }

    public final int pendingTasks() {
        return this.taskQueue.size();
    }

    /*
     * WARNING - void declaration
     */
    private void addTask(Runnable task) {
        void var1_1;
        this.taskQueue.add((Runnable)ObjectUtil.checkNotNull(var1_1, "task"));
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    @Override
    public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public final void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isShuttingDown() {
        return false;
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return false;
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean awaitInactivity(long timeout, TimeUnit unit) throws InterruptedException {
        void var1_1;
        void var3_2;
        ObjectUtil.checkNotNull(unit, "unit");
        Thread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("thread was not started");
        }
        thread.join(var3_2.toMillis((long)var1_1));
        return !thread.isAlive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable task) {
        void var1_1;
        this.execute0((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void execute0(Runnable task) {
        void var1_1;
        this.addTask((Runnable)ObjectUtil.checkNotNull(var1_1, "task"));
        if (!this.inEventLoop()) {
            this.startThread();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startThread() {
        if (this.started.compareAndSet(false, true)) {
            void var1_1;
            Thread t = this.threadFactory.newThread(this.taskRunner);
            AccessController.doPrivileged(new PrivilegedAction<Void>(this, t){
                final /* synthetic */ Thread val$t;
                final /* synthetic */ GlobalEventExecutor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$t = thread;
                }

                @Override
                public Void run() {
                    this.val$t.setContextClassLoader(null);
                    return null;
                }
            });
            this.thread = t;
            var1_1.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(GlobalEventExecutor.class);
        int quietPeriod = SystemPropertyUtil.getInt("io.netty.globalEventExecutor.quietPeriodSeconds", 1);
        if (quietPeriod <= 0) {
            quietPeriod = 1;
        }
        logger.debug("-Dio.netty.globalEventExecutor.quietPeriodSeconds: {}", (Object)quietPeriod);
        SCHEDULE_QUIET_PERIOD_INTERVAL = TimeUnit.SECONDS.toNanos((long)var0);
        INSTANCE = new GlobalEventExecutor();
    }

    final class TaskRunner
    implements Runnable {
        final /* synthetic */ GlobalEventExecutor this$0;

        /*
         * WARNING - void declaration
         */
        TaskRunner(GlobalEventExecutor this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (true) {
                void var1_2;
                void var2_3;
                Runnable task;
                if ((task = this.this$0.takeTask()) != null) {
                    try {
                        AbstractEventExecutor.runTask(task);
                    }
                    catch (Throwable t) {
                        logger.warn("Unexpected exception from the global event executor: ", t);
                    }
                    if (task != this.this$0.quietPeriodTask) continue;
                }
                PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.this$0.scheduledTaskQueue;
                if (!this.this$0.taskQueue.isEmpty() || scheduledTaskQueue != null && var2_3.size() != 1) continue;
                boolean stopped = this.this$0.started.compareAndSet(true, false);
                assert (var1_2 != false);
                if (this.this$0.taskQueue.isEmpty() || !this.this$0.started.compareAndSet(false, true)) break;
            }
        }
    }
}

