/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocalRunnable;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class FastThreadLocalThread
extends Thread {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FastThreadLocalThread.class);
    private final boolean cleanupFastThreadLocals;
    private InternalThreadLocalMap threadLocalMap;

    public FastThreadLocalThread() {
        this.cleanupFastThreadLocals = false;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(Runnable target) {
        super(FastThreadLocalRunnable.wrap((Runnable)var1_1));
        void var1_1;
        this.cleanupFastThreadLocals = true;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(ThreadGroup group, Runnable target) {
        super((ThreadGroup)var1_1, FastThreadLocalRunnable.wrap((Runnable)var2_2));
        void var2_2;
        void var1_1;
        this.cleanupFastThreadLocals = true;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(String name) {
        super((String)var1_1);
        void var1_1;
        this.cleanupFastThreadLocals = false;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(ThreadGroup group, String name) {
        super((ThreadGroup)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
        this.cleanupFastThreadLocals = false;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(Runnable target, String name) {
        super(FastThreadLocalRunnable.wrap((Runnable)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
        this.cleanupFastThreadLocals = true;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name) {
        super((ThreadGroup)var1_1, FastThreadLocalRunnable.wrap((Runnable)var2_2), (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.cleanupFastThreadLocals = true;
    }

    /*
     * WARNING - void declaration
     */
    public FastThreadLocalThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super((ThreadGroup)var1_1, FastThreadLocalRunnable.wrap((Runnable)var2_2), (String)var3_3, stackSize);
        void var3_3;
        void var2_2;
        void var1_1;
        this.cleanupFastThreadLocals = true;
    }

    public final InternalThreadLocalMap threadLocalMap() {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to get 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        return this.threadLocalMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void setThreadLocalMap(InternalThreadLocalMap threadLocalMap) {
        void var1_1;
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to set 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        this.threadLocalMap = var1_1;
    }

    public boolean willCleanupFastThreadLocals() {
        return this.cleanupFastThreadLocals;
    }

    public static boolean willCleanupFastThreadLocals(Thread thread) {
        Thread thread2;
        return thread instanceof FastThreadLocalThread && ((FastThreadLocalThread)thread2).willCleanupFastThreadLocals();
    }

    public boolean permitBlockingCalls() {
        return false;
    }
}

