/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class FastThreadLocal<V> {
    private final int index = InternalThreadLocalMap.nextVariableIndex();

    public static void removeAll() {
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.getIfSet();
        if (threadLocalMap == null) {
            return;
        }
        try {
            Object v = threadLocalMap.indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
            if (v != null && v != InternalThreadLocalMap.UNSET) {
                FastThreadLocal[] fastThreadLocalArray;
                fastThreadLocalArray = fastThreadLocalArray;
                FastThreadLocal[] fastThreadLocalArray2 = fastThreadLocalArray.toArray(new FastThreadLocal[0]);
                fastThreadLocalArray = fastThreadLocalArray2;
                fastThreadLocalArray = fastThreadLocalArray2;
                int n = fastThreadLocalArray2.length;
                for (int i = 0; i < n; ++i) {
                    FastThreadLocal fastThreadLocal = fastThreadLocalArray[i];
                    fastThreadLocal.remove(threadLocalMap);
                }
            }
            return;
        }
        finally {
            InternalThreadLocalMap.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int size() {
        void var0;
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.getIfSet();
        if (threadLocalMap == null) {
            return 0;
        }
        return var0.size();
    }

    public static void destroy() {
        InternalThreadLocalMap.destroy();
    }

    /*
     * WARNING - void declaration
     */
    private static void addToVariablesToRemove(InternalThreadLocalMap threadLocalMap, FastThreadLocal<?> variable) {
        void var1_1;
        void var2_2;
        Set variablesToRemove;
        Object v = threadLocalMap.indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
        if (v == InternalThreadLocalMap.UNSET || v == null) {
            InternalThreadLocalMap internalThreadLocalMap;
            variablesToRemove = Collections.newSetFromMap(new IdentityHashMap());
            internalThreadLocalMap.setIndexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX, variablesToRemove);
        } else {
            variablesToRemove = variablesToRemove;
        }
        var2_2.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void removeFromVariablesToRemove(InternalThreadLocalMap threadLocalMap, FastThreadLocal<?> variable) {
        void var1_1;
        Set set;
        Set v = threadLocalMap.indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
        if (v == InternalThreadLocalMap.UNSET || v == null) {
            return;
        }
        set = set;
        set.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final V get() {
        void var1_1;
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.get();
        Object v = threadLocalMap.indexedVariable(this.index);
        if (v != InternalThreadLocalMap.UNSET) {
            void var2_2;
            return var2_2;
        }
        return this.initialize((InternalThreadLocalMap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final V getIfExists() {
        Object v;
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.getIfSet();
        if (threadLocalMap != null && (v = threadLocalMap.indexedVariable(this.index)) != InternalThreadLocalMap.UNSET) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final V get(InternalThreadLocalMap threadLocalMap) {
        void var1_1;
        Object v = threadLocalMap.indexedVariable(this.index);
        if (v != InternalThreadLocalMap.UNSET) {
            void var2_2;
            return var2_2;
        }
        return this.initialize((InternalThreadLocalMap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private V initialize(InternalThreadLocalMap threadLocalMap) {
        void var2_2;
        void var1_1;
        Object v = null;
        try {
            V v2 = this.initialValue();
            v = v2;
            if (v2 == InternalThreadLocalMap.UNSET) {
                throw new IllegalArgumentException("InternalThreadLocalMap.UNSET can not be initial value.");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
        }
        threadLocalMap.setIndexedVariable(this.index, v);
        FastThreadLocal.addToVariablesToRemove((InternalThreadLocalMap)var1_1, this);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(V value) {
        if (value != InternalThreadLocalMap.UNSET) {
            void var1_1;
            void var2_2;
            InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.get();
            this.setKnownNotUnset((InternalThreadLocalMap)var2_2, var1_1);
            return;
        }
        this.remove();
    }

    /*
     * WARNING - void declaration
     */
    public final void set(InternalThreadLocalMap threadLocalMap, V value) {
        void var1_1;
        if (value != InternalThreadLocalMap.UNSET) {
            void var2_2;
            this.setKnownNotUnset(threadLocalMap, var2_2);
            return;
        }
        this.remove((InternalThreadLocalMap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setKnownNotUnset(InternalThreadLocalMap threadLocalMap, V value) {
        void var2_2;
        if (threadLocalMap.setIndexedVariable(this.index, var2_2)) {
            void var1_1;
            FastThreadLocal.addToVariablesToRemove((InternalThreadLocalMap)var1_1, this);
        }
    }

    public final boolean isSet() {
        return this.isSet(InternalThreadLocalMap.getIfSet());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSet(InternalThreadLocalMap threadLocalMap) {
        void var1_1;
        return threadLocalMap != null && var1_1.isIndexedVariableSet(this.index);
    }

    public final void remove() {
        this.remove(InternalThreadLocalMap.getIfSet());
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(InternalThreadLocalMap threadLocalMap) {
        if (threadLocalMap == null) {
            return;
        }
        Object v = threadLocalMap.removeIndexedVariable(this.index);
        if (v != InternalThreadLocalMap.UNSET) {
            Exception exception;
            FastThreadLocal.removeFromVariablesToRemove((InternalThreadLocalMap)((Object)exception), this);
            try {
                void var2_2;
                this.onRemoval(var2_2);
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
                PlatformDependent.throwException(exception2);
            }
        }
    }

    protected V initialValue() throws Exception {
        return null;
    }

    protected void onRemoval(V value) throws Exception {
    }
}

