/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocalRunnable;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(Class<?> poolType) {
        this((Class<?>)var1_1, false, 5);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(String poolName) {
        this((String)var1_1, false, 5);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(Class<?> poolType, boolean daemon) {
        this((Class<?>)var1_1, (boolean)var2_2, 5);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(String poolName, boolean daemon) {
        this((String)var1_1, (boolean)var2_2, 5);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(Class<?> poolType, int priority) {
        this((Class<?>)var1_1, false, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(String poolName, int priority) {
        this((String)var1_1, false, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(Class<?> poolType, boolean daemon, int priority) {
        this(DefaultThreadFactory.toPoolName(var1_1), (boolean)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public static String toPoolName(Class<?> poolType) {
        String string;
        ObjectUtil.checkNotNull(poolType, "poolType");
        String poolName = StringUtil.simpleClassName(poolType);
        switch (poolName.length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return poolName.toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(poolName.charAt(0)) && Character.isLowerCase(poolName.charAt(1))) {
            return Character.toLowerCase(poolName.charAt(0)) + poolName.substring(1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(String poolName, boolean daemon, int priority, ThreadGroup threadGroup) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(poolName, "poolName");
        if (priority <= 0 || priority > 10) {
            throw new IllegalArgumentException("priority: " + priority + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = (String)var1_1 + '-' + poolId.incrementAndGet() + '-';
        this.daemon = var2_2;
        this.priority = var3_3;
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultThreadFactory(String poolName, boolean daemon, int priority) {
        this((String)var1_1, (boolean)var2_2, (int)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Thread newThread(Runnable r) {
        void var1_1;
        Thread t = this.newThread(FastThreadLocalRunnable.wrap(r), this.prefix + this.nextId.incrementAndGet());
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
        }
        catch (Exception exception) {}
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Thread newThread(Runnable r, String name) {
        void var2_2;
        void var1_1;
        return new FastThreadLocalThread(this.threadGroup, (Runnable)var1_1, (String)var2_2);
    }
}

