/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultFutureListeners;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GenericProgressiveFutureListener;
import io.netty.util.concurrent.ProgressiveFuture;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final InternalLogger rejectedExecutionLogger = InternalLoggerFactory.getInstance(DefaultPromise.class.getName() + ".rejectedExecution");
    private static final int MAX_LISTENER_STACK_DEPTH = Math.min(8, SystemPropertyUtil.getInt("io.netty.defaultPromise.maxListenerStackDepth", 8));
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final CauseHolder CANCELLATION_CAUSE_HOLDER = new CauseHolder(StacklessCancellationException.newInstance(DefaultPromise.class, "cancel(...)"));
    private static final StackTraceElement[] CANCELLATION_STACK = DefaultPromise.CANCELLATION_CAUSE_HOLDER.cause.getStackTrace();
    private volatile Object result;
    private final EventExecutor executor;
    private GenericFutureListener<? extends Future<?>> listener;
    private DefaultFutureListeners listeners;
    private short waiters;
    private boolean notifyingListeners;

    /*
     * WARNING - void declaration
     */
    public DefaultPromise(EventExecutor executor) {
        void var1_1;
        this.executor = (EventExecutor)ObjectUtil.checkNotNull(var1_1, "executor");
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> setSuccess(V result) {
        void var1_1;
        if (this.setSuccess0(var1_1)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean trySuccess(V result) {
        void var1_1;
        return this.setSuccess0(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> setFailure(Throwable cause) {
        void var1_1;
        if (this.setFailure0(cause)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryFailure(Throwable cause) {
        void var1_1;
        return this.setFailure0((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setUncancellable() {
        void var1_1;
        if (RESULT_UPDATER.compareAndSet(this, null, UNCANCELLABLE)) {
            return true;
        }
        Object result = this.result;
        return !DefaultPromise.isDone0(result) || !DefaultPromise.isCancelled0(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSuccess() {
        void var1_1;
        Object result = this.result;
        return result != null && result != UNCANCELLABLE && !(var1_1 instanceof CauseHolder);
    }

    @Override
    public boolean isCancellable() {
        return this.result == null;
    }

    @Override
    public Throwable cause() {
        DefaultPromise defaultPromise = this;
        return defaultPromise.cause0(defaultPromise.result);
    }

    private Throwable cause0(Object result) {
        Object object;
        if (!(result instanceof CauseHolder)) {
            return null;
        }
        if (result == CANCELLATION_CAUSE_HOLDER) {
            LeanCancellationException ce = new LeanCancellationException();
            if (RESULT_UPDATER.compareAndSet(this, CANCELLATION_CAUSE_HOLDER, new CauseHolder(ce))) {
                return object;
            }
            object = this.result;
        }
        return ((CauseHolder)object).cause;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        ObjectUtil.checkNotNull(listener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            void var1_1;
            this.addListener0((GenericFutureListener<? extends Future<? super V>>)var1_1);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        ObjectUtil.checkNotNull(listeners, "listeners");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            void var1_1;
            for (void listener : var1_1) {
                if (listener == null) break;
                this.addListener0((GenericFutureListener<? extends Future<? super V>>)listener);
            }
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        ObjectUtil.checkNotNull(listener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            void var1_1;
            this.removeListener0((GenericFutureListener<? extends Future<? super V>>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        ObjectUtil.checkNotNull(listeners, "listeners");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            void var1_1;
            for (void listener : var1_1) {
                if (listener == null) break;
                this.removeListener0((GenericFutureListener<? extends Future<? super V>>)listener);
            }
        }
        return this;
    }

    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Promise<V> awaitUninterruptibly() {
        void var1_1;
        if (this.isDone()) {
            return this;
        }
        this.checkDeadLock();
        boolean interrupted = false;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (var1_1 != false) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        void var1_1;
        void var3_2;
        return this.await0(var3_2.toNanos((long)var1_1), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        void var1_1;
        return this.await0(TimeUnit.MILLISECONDS.toNanos((long)var1_1), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            void var1_1;
            void var3_2;
            return this.await0(var3_2.toNanos((long)var1_1), false);
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            void var1_1;
            return this.await0(TimeUnit.MILLISECONDS.toNanos((long)var1_1), false);
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getNow() {
        void var1_1;
        Object result = this.result;
        if (result instanceof CauseHolder || result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        void var2_2;
        Object result = this.result;
        if (!DefaultPromise.isDone0(result)) {
            this.await();
            result = this.result;
        }
        if (result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        Throwable cause = this.cause0(result);
        if (cause == null) {
            void var1_1;
            return var1_1;
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var1_2;
        Object result = this.result;
        if (!DefaultPromise.isDone0(result)) {
            void var3_3;
            if (!this.await(timeout, (TimeUnit)var3_3)) {
                throw new TimeoutException();
            }
            result = this.result;
        }
        if (result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        Throwable cause = this.cause0(result);
        if (cause == null) {
            return (V)result;
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException((Throwable)var1_2);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    /*
     * WARNING - void declaration
     */
    protected StringBuilder toStringBuilder() {
        void var1_1;
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        Object result = this.result;
        if (result == SUCCESS) {
            buf.append("(success)");
        } else if (result == UNCANCELLABLE) {
            buf.append("(uncancellable)");
        } else if (result instanceof CauseHolder) {
            buf.append("(failure: ").append(((CauseHolder)result).cause).append(')');
        } else if (result != null) {
            void var2_2;
            buf.append("(success: ").append(var2_2).append(')');
        } else {
            buf.append("(incomplete)");
        }
        return var1_1;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkDeadLock() {
        void var1_1;
        EventExecutor e = this.executor();
        if (e != null && var1_1.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void notifyListener(EventExecutor eventExecutor, Future<?> future, GenericFutureListener<?> listener) {
        void var2_2;
        void var1_1;
        DefaultPromise.notifyListenerWithStackOverFlowProtection(ObjectUtil.checkNotNull(eventExecutor, "eventExecutor"), (Future)ObjectUtil.checkNotNull(var1_1, "future"), (GenericFutureListener)ObjectUtil.checkNotNull(var2_2, "listener"));
    }

    /*
     * WARNING - void declaration
     */
    private void notifyListeners() {
        void var1_1;
        InternalThreadLocalMap threadLocals;
        int stackDepth;
        EventExecutor executor2 = this.executor();
        if (executor2.inEventLoop() && (stackDepth = (threadLocals = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            threadLocals.setFutureListenerStackDepth(stackDepth + 1);
            try {
                this.notifyListenersNow();
                threadLocals.setFutureListenerStackDepth(stackDepth);
                return;
            }
            catch (Throwable executor2) {
                void var3_4;
                void var2_3;
                var2_3.setFutureListenerStackDepth((int)var3_4);
                throw executor2;
            }
        }
        DefaultPromise.safeExecute((EventExecutor)var1_1, new Runnable(this){
            final /* synthetic */ DefaultPromise this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.notifyListenersNow();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void notifyListenerWithStackOverFlowProtection(EventExecutor executor2, Future<?> future, GenericFutureListener<?> listener) {
        void var2_3;
        void var1_2;
        EventExecutor eventExecutor;
        InternalThreadLocalMap threadLocals;
        int stackDepth;
        if (executor2.inEventLoop() && (stackDepth = (threadLocals = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            threadLocals.setFutureListenerStackDepth(stackDepth + 1);
            try {
                DefaultPromise.notifyListener0(future, listener);
                threadLocals.setFutureListenerStackDepth(stackDepth);
                return;
            }
            catch (Throwable executor2) {
                void var3_4;
                var3_4.setFutureListenerStackDepth(stackDepth);
                throw executor2;
            }
        }
        DefaultPromise.safeExecute(eventExecutor, new Runnable((Future)var1_2, (GenericFutureListener)var2_3){
            final /* synthetic */ Future val$future;
            final /* synthetic */ GenericFutureListener val$listener;
            {
                this.val$future = future;
                this.val$listener = genericFutureListener;
            }

            @Override
            public final void run() {
                DefaultPromise.access$300(this.val$future, this.val$listener);
            }
        });
    }

    private void notifyListenersNow() {
        DefaultFutureListeners listeners;
        GenericFutureListener<? extends Future<?>> listener;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            listener = this.listener;
            listeners = this.listeners;
            if (this.notifyingListeners || listener == null && listeners == null) {
                return;
            }
            this.notifyingListeners = true;
            if (listener != null) {
                this.listener = null;
            } else {
                this.listeners = null;
            }
        }
        while (true) {
            if (listener != null) {
                DefaultPromise.notifyListener0(this, listener);
            } else {
                this.notifyListeners0(listeners);
            }
            defaultPromise = this;
            synchronized (defaultPromise) {
                if (this.listener == null && this.listeners == null) {
                    this.notifyingListeners = false;
                    return;
                }
                listener = this.listener;
                listeners = this.listeners;
                if (listener != null) {
                    this.listener = null;
                } else {
                    this.listeners = null;
                }
            }
        }
    }

    private void notifyListeners0(DefaultFutureListeners listeners) {
        GenericFutureListener<? extends Future<?>>[] a = listeners.listeners();
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            DefaultPromise.notifyListener0(this, a[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void notifyListener0(Future future, GenericFutureListener l) {
        try {
            l.operationComplete(future);
            return;
        }
        catch (Throwable t) {
            if (logger.isWarnEnabled()) {
                void var0_1;
                void var1_2;
                logger.warn("An exception was thrown by " + var1_2.getClass().getName() + ".operationComplete()", (Throwable)var0_1);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addListener0(GenericFutureListener<? extends Future<? super V>> listener) {
        void var1_1;
        if (this.listener == null) {
            if (this.listeners == null) {
                this.listener = listener;
                return;
            }
            this.listeners.add(listener);
            return;
        }
        assert (this.listeners == null);
        this.listeners = new DefaultFutureListeners(this.listener, (GenericFutureListener<? extends Future<?>>)var1_1);
        this.listener = null;
    }

    /*
     * WARNING - void declaration
     */
    private void removeListener0(GenericFutureListener<? extends Future<? super V>> toRemove) {
        if (this.listener == toRemove) {
            this.listener = null;
            return;
        }
        if (this.listeners != null) {
            void var1_1;
            this.listeners.remove((GenericFutureListener<? extends Future<?>>)var1_1);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean setSuccess0(V result) {
        void var1_1;
        return this.setValue0(result == null ? SUCCESS : var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean setFailure0(Throwable cause) {
        void var1_1;
        return this.setValue0(new CauseHolder((Throwable)ObjectUtil.checkNotNull(var1_1, "cause")));
    }

    /*
     * WARNING - void declaration
     */
    private boolean setValue0(Object objResult) {
        void var1_1;
        if (RESULT_UPDATER.compareAndSet(this, null, objResult) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, var1_1)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listener != null || this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    /*
     * WARNING - void declaration
     */
    private void rethrowIfFailed() {
        void var1_1;
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        PlatformDependent.throwException((Throwable)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (timeoutNanos <= 0L) {
            return this.isDone();
        }
        if (interruptable != false && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        long startTime = System.nanoTime();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            boolean interrupted = false;
            try {
                long waitTime = timeoutNanos;
                while (!this.isDone() && waitTime > 0L) {
                    this.incWaiters();
                    try {
                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                    }
                    catch (InterruptedException e) {
                        if (interruptable != false) {
                            throw e;
                        }
                        interrupted = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                    if (this.isDone()) {
                        return true;
                    }
                    long l = timeoutNanos - (System.nanoTime() - startTime);
                }
                boolean bl = this.isDone();
                return bl;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void notifyProgressiveListeners(long progress, long total) {
        void var3_2;
        void var1_1;
        GenericProgressiveFutureListener[] array;
        Object listeners = this.progressiveListeners();
        if (listeners == null) {
            return;
        }
        ProgressiveFuture self = (ProgressiveFuture)((Object)this);
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            if (listeners instanceof GenericProgressiveFutureListener[]) {
                DefaultPromise.notifyProgressiveListeners0(self, (GenericProgressiveFutureListener[])listeners, progress, total);
                return;
            }
            DefaultPromise.notifyProgressiveListener0(self, (GenericProgressiveFutureListener)listeners, progress, total);
            return;
        }
        if (listeners instanceof GenericProgressiveFutureListener[]) {
            array = (GenericProgressiveFutureListener[])listeners;
            DefaultPromise.safeExecute(executor, new Runnable(this, self, array, progress, total){
                final /* synthetic */ ProgressiveFuture val$self;
                final /* synthetic */ GenericProgressiveFutureListener[] val$array;
                final /* synthetic */ long val$progress;
                final /* synthetic */ long val$total;
                final /* synthetic */ DefaultPromise this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$self = progressiveFuture;
                    this.val$array = genericProgressiveFutureListenerArray;
                    this.val$progress = l;
                    this.val$total = l2;
                }

                @Override
                public void run() {
                    DefaultPromise.access$400(this.val$self, this.val$array, this.val$progress, this.val$total);
                }
            });
            return;
        }
        GenericProgressiveFutureListener l = (GenericProgressiveFutureListener)array;
        DefaultPromise.safeExecute(executor, new Runnable(this, self, l, (long)var1_1, (long)var3_2){
            final /* synthetic */ ProgressiveFuture val$self;
            final /* synthetic */ GenericProgressiveFutureListener val$l;
            final /* synthetic */ long val$progress;
            final /* synthetic */ long val$total;
            final /* synthetic */ DefaultPromise this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$self = progressiveFuture;
                this.val$l = genericProgressiveFutureListener;
                this.val$progress = l;
                this.val$total = l2;
            }

            @Override
            public void run() {
                DefaultPromise.access$500(this.val$self, this.val$l, this.val$progress, this.val$total);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object progressiveListeners() {
        void var1_1;
        GenericFutureListener<? extends Future<?>> listener = this.listener;
        GenericFutureListener<? extends Future<?>>[] listeners = this.listeners;
        if (listener == null && listeners == null) {
            return null;
        }
        if (listeners != null) {
            void var3_5;
            void var5_10;
            GenericFutureListener<? extends Future<?>>[] dfl = listeners;
            int progressiveSize = listeners.progressiveSize();
            switch (progressiveSize) {
                case 0: {
                    return null;
                }
                case 1: {
                    for (GenericFutureListener<Future<?>> genericFutureListener : dfl.listeners()) {
                        if (!(genericFutureListener instanceof GenericProgressiveFutureListener)) continue;
                        return genericFutureListener;
                    }
                    return null;
                }
            }
            GenericFutureListener<? extends Future<?>>[] array = dfl.listeners();
            GenericProgressiveFutureListener[] copy = new GenericProgressiveFutureListener[progressiveSize];
            int i = 0;
            boolean bl = false;
            while (var5_10 < progressiveSize) {
                GenericFutureListener<Future<?>> l = array[i];
                if (l instanceof GenericProgressiveFutureListener) {
                    copy[++var5_10] = (GenericProgressiveFutureListener)l;
                }
                ++i;
            }
            return var3_5;
        }
        if (var1_1 instanceof GenericProgressiveFutureListener) {
            return var1_1;
        }
        return null;
    }

    private static void notifyProgressiveListeners0(ProgressiveFuture<?> future, GenericProgressiveFutureListener<?>[] listeners, long progress, long total) {
        GenericProgressiveFutureListener<?> l;
        GenericProgressiveFutureListener<?>[] genericProgressiveFutureListenerArray = listeners;
        int n = listeners.length;
        for (int i = 0; i < n && (l = genericProgressiveFutureListenerArray[i]) != null; ++i) {
            DefaultPromise.notifyProgressiveListener0(future, l, progress, total);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void notifyProgressiveListener0(ProgressiveFuture future, GenericProgressiveFutureListener l, long progress, long total) {
        try {
            void var2_3;
            l.operationProgressed(future, (long)var2_3, total);
            return;
        }
        catch (Throwable t) {
            if (logger.isWarnEnabled()) {
                void var0_1;
                void var1_2;
                logger.warn("An exception was thrown by " + var1_2.getClass().getName() + ".operationProgressed()", (Throwable)var0_1);
            }
            return;
        }
    }

    private static boolean isCancelled0(Object result) {
        Object object;
        return result instanceof CauseHolder && ((CauseHolder)object).cause instanceof CancellationException;
    }

    private static boolean isDone0(Object result) {
        Object object;
        return result != null && object != UNCANCELLABLE;
    }

    /*
     * WARNING - void declaration
     */
    private static void safeExecute(EventExecutor executor, Runnable task) {
        try {
            void var1_2;
            executor.execute((Runnable)var1_2);
            return;
        }
        catch (Throwable t) {
            void var0_1;
            rejectedExecutionLogger.error("Failed to submit a listener notification task. Event loop shut down?", (Throwable)var0_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(Future x0, GenericFutureListener x1) {
        void var1_1;
        DefaultPromise.notifyListener0(x0, (GenericFutureListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(ProgressiveFuture x0, GenericProgressiveFutureListener[] x1, long x2, long x3) {
        void var2_2;
        void var1_1;
        DefaultPromise.notifyProgressiveListeners0(x0, var1_1, (long)var2_2, x3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(ProgressiveFuture x0, GenericProgressiveFutureListener x1, long x2, long x3) {
        void var2_2;
        void var1_1;
        DefaultPromise.notifyProgressiveListener0(x0, (GenericProgressiveFutureListener)var1_1, (long)var2_2, x3);
    }

    private static final class StacklessCancellationException
    extends CancellationException {
        private static final long serialVersionUID = -2974906711413716191L;

        private StacklessCancellationException() {
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        static StacklessCancellationException newInstance(Class<?> clazz, String method) {
            void var1_1;
            Class<?> clazz2;
            return ThrowableUtil.unknownStackTrace(new StacklessCancellationException(), clazz2, (String)var1_1);
        }
    }

    private static final class CauseHolder {
        final Throwable cause;

        /*
         * WARNING - void declaration
         */
        CauseHolder(Throwable cause) {
            void var1_1;
            this.cause = var1_1;
        }
    }

    private static final class LeanCancellationException
    extends CancellationException {
        private static final long serialVersionUID = 2794674970981187807L;

        private LeanCancellationException() {
        }

        @Override
        public final Throwable fillInStackTrace() {
            this.setStackTrace(CANCELLATION_STACK);
            return this;
        }

        @Override
        public final String toString() {
            return CancellationException.class.getName();
        }
    }
}

