/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.internal.ObjectUtil;

public class DefaultProgressivePromise<V>
extends DefaultPromise<V>
implements ProgressivePromise<V> {
    /*
     * WARNING - void declaration
     */
    public DefaultProgressivePromise(EventExecutor executor) {
        super((EventExecutor)var1_1);
        void var1_1;
    }

    protected DefaultProgressivePromise() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> setProgress(long progress, long total) {
        void var3_2;
        void var1_1;
        if (total < 0L) {
            total = -1L;
            ObjectUtil.checkPositiveOrZero(progress, "progress");
        } else if (progress < 0L || progress > total) {
            throw new IllegalArgumentException("progress: " + progress + " (expected: 0 <= progress <= total (" + total + "))");
        }
        if (this.isDone()) {
            throw new IllegalStateException("complete already");
        }
        this.notifyProgressiveListeners((long)var1_1, (long)var3_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryProgress(long progress, long total) {
        void var3_2;
        void var1_1;
        if (total < 0L) {
            total = -1L;
            if (progress < 0L || this.isDone()) {
                return false;
            }
        } else if (progress < 0L || progress > total || this.isDone()) {
            return false;
        }
        this.notifyProgressiveListeners((long)var1_1, (long)var3_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        void var1_1;
        super.addListener((GenericFutureListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        void var1_1;
        super.addListeners((GenericFutureListener[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        void var1_1;
        super.removeListener((GenericFutureListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        void var1_1;
        super.removeListeners((GenericFutureListener[])var1_1);
        return this;
    }

    @Override
    public ProgressivePromise<V> sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public ProgressivePromise<V> syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public ProgressivePromise<V> await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public ProgressivePromise<V> awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> setSuccess(V result) {
        void var1_1;
        super.setSuccess(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProgressivePromise<V> setFailure(Throwable cause) {
        void var1_1;
        super.setFailure((Throwable)var1_1);
        return this;
    }
}

