/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GenericProgressiveFutureListener;
import java.util.Arrays;

final class DefaultFutureListeners {
    private GenericFutureListener<? extends Future<?>>[] listeners = new GenericFutureListener[2];
    private int size;
    private int progressiveSize;

    /*
     * WARNING - void declaration
     */
    DefaultFutureListeners(GenericFutureListener<? extends Future<?>> first, GenericFutureListener<? extends Future<?>> second) {
        void var2_2;
        void var1_1;
        this.listeners[0] = first;
        this.listeners[1] = second;
        this.size = 2;
        if (var1_1 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
        if (var2_2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(GenericFutureListener<? extends Future<?>> l) {
        void var1_1;
        void var3_3;
        int size = this.size;
        GenericFutureListener<? extends Future<?>>[] listeners = this.listeners;
        if (size == listeners.length) {
            this.listeners = listeners = Arrays.copyOf(listeners, size << 1);
        }
        var2_2[size] = l;
        this.size = var3_3 + true;
        if (var1_1 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public final void remove(GenericFutureListener<? extends Future<?>> l) {
        GenericFutureListener<? extends Future<?>>[] listeners = this.listeners;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (listeners[i] != l) continue;
            int listenersToMove = size - i - 1;
            if (listenersToMove > 0) {
                System.arraycopy(listeners, i + 1, listeners, i, listenersToMove);
            }
            listeners[--size] = null;
            this.size = size;
            if (l instanceof GenericProgressiveFutureListener) {
                --this.progressiveSize;
            }
            return;
        }
    }

    public final GenericFutureListener<? extends Future<?>>[] listeners() {
        return this.listeners;
    }

    public final int size() {
        return this.size;
    }

    public final int progressiveSize() {
        return this.progressiveSize;
    }
}

