/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultEventExecutorChooserFactory
implements EventExecutorChooserFactory {
    public static final DefaultEventExecutorChooserFactory INSTANCE = new DefaultEventExecutorChooserFactory();

    private DefaultEventExecutorChooserFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] executors) {
        void var1_1;
        if (DefaultEventExecutorChooserFactory.isPowerOfTwo(executors.length)) {
            return new PowerOfTwoEventExecutorChooser(executors);
        }
        return new GenericEventExecutorChooser((EventExecutor[])var1_1);
    }

    private static boolean isPowerOfTwo(int val) {
        int n;
        int n2 = val;
        return (n2 & -n2) == n;
    }

    private static final class GenericEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicLong idx = new AtomicLong();
        private final EventExecutor[] executors;

        /*
         * WARNING - void declaration
         */
        GenericEventExecutorChooser(EventExecutor[] executors) {
            void var1_1;
            this.executors = var1_1;
        }

        @Override
        public final EventExecutor next() {
            return this.executors[(int)Math.abs(this.idx.getAndIncrement() % (long)this.executors.length)];
        }
    }

    private static final class PowerOfTwoEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventExecutor[] executors;

        /*
         * WARNING - void declaration
         */
        PowerOfTwoEventExecutorChooser(EventExecutor[] executors) {
            void var1_1;
            this.executors = var1_1;
        }

        @Override
        public final EventExecutor next() {
            return this.executors[this.idx.getAndIncrement() & this.executors.length - 1];
        }
    }
}

