/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new Comparator<ScheduledFutureTask<?>>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(ScheduledFutureTask<?> o1, ScheduledFutureTask<?> o2) {
            void var2_2;
            return o1.compareTo((Delayed)var2_2);
        }
    };
    private static final long START_TIME = System.nanoTime();
    static final Runnable WAKEUP_TASK = new Runnable(){

        @Override
        public final void run() {
        }
    };
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;
    long nextTaskId;

    protected AbstractScheduledEventExecutor() {
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractScheduledEventExecutor(EventExecutorGroup parent) {
        super((EventExecutorGroup)var1_1);
        void var1_1;
    }

    protected long getCurrentTimeNanos() {
        return AbstractScheduledEventExecutor.defaultCurrentTimeNanos();
    }

    @Deprecated
    protected static long nanoTime() {
        return AbstractScheduledEventExecutor.defaultCurrentTimeNanos();
    }

    static long defaultCurrentTimeNanos() {
        return System.nanoTime() - START_TIME;
    }

    /*
     * WARNING - void declaration
     */
    static long deadlineNanos(long nanoTime, long delay) {
        void var2_1;
        long deadlineNanos = nanoTime + var2_1;
        if (deadlineNanos < 0L) {
            return Long.MAX_VALUE;
        }
        return deadlineNanos;
    }

    protected static long deadlineToDelayNanos(long deadlineNanos) {
        long l;
        return ScheduledFutureTask.deadlineToDelayNanos(AbstractScheduledEventExecutor.defaultCurrentTimeNanos(), l);
    }

    protected static long initialNanoTime() {
        return START_TIME;
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        Queue<ScheduledFutureTask<?>> queue2;
        return queue == null || queue2.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    protected void cancelScheduledTasks() {
        void var1_1;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(scheduledTaskQueue)) {
            return;
        }
        ScheduledFutureTask[] scheduledFutureTaskArray = scheduledTaskQueue.toArray(new ScheduledFutureTask[0]);
        ScheduledFutureTask[] scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        int n = scheduledFutureTaskArray.length;
        for (int i = 0; i < n; ++i) {
            ScheduledFutureTask scheduledFutureTask = scheduledFutureTaskArray2[i];
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        var1_1.clearIgnoringIndexes();
    }

    protected final Runnable pollScheduledTask() {
        AbstractScheduledEventExecutor abstractScheduledEventExecutor = this;
        return abstractScheduledEventExecutor.pollScheduledTask(abstractScheduledEventExecutor.getCurrentTimeNanos());
    }

    /*
     * WARNING - void declaration
     */
    protected final Runnable pollScheduledTask(long nanoTime) {
        void var3_2;
        void var1_1;
        assert (this.inEventLoop());
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask == null || scheduledTask.deadlineNanos() - var1_1 > 0L) {
            return null;
        }
        this.scheduledTaskQueue.remove();
        scheduledTask.setConsumed();
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask != null) {
            void var1_1;
            return var1_1.delayNanos();
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    protected final long nextScheduledTaskDeadlineNanos() {
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        if (scheduledTask != null) {
            void var1_1;
            return var1_1.deadlineNanos();
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (scheduledTaskQueue != null) {
            void var1_1;
            return (ScheduledFutureTask)var1_1.peek();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean hasScheduledTasks() {
        void var1_1;
        ScheduledFutureTask<?> scheduledTask = this.peekScheduledTask();
        return scheduledTask != null && var1_1.deadlineNanos() <= this.getCurrentTimeNanos();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit, "unit");
        if (delay < 0L) {
            delay = 0L;
        }
        this.validateScheduled0(delay, unit);
        return this.schedule(new ScheduledFutureTask(this, (Runnable)var1_1, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), unit.toNanos((long)var2_2))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(unit, "unit");
        if (delay < 0L) {
            delay = 0L;
        }
        this.validateScheduled0(delay, unit);
        return this.schedule(new ScheduledFutureTask(this, var1_1, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), unit.toNanos((long)var2_2))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        this.validateScheduled0(initialDelay, unit);
        this.validateScheduled0(period, unit);
        return this.schedule(new ScheduledFutureTask(this, (Runnable)var1_1, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), unit.toNanos((long)var2_2)), unit.toNanos(period)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(command, "command");
        ObjectUtil.checkNotNull(unit, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay));
        }
        this.validateScheduled0(initialDelay, unit);
        this.validateScheduled0(delay, unit);
        return this.schedule(new ScheduledFutureTask(this, (Runnable)var1_1, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), unit.toNanos((long)var2_2)), -unit.toNanos(delay)));
    }

    /*
     * WARNING - void declaration
     */
    private void validateScheduled0(long amount, TimeUnit unit) {
        void var3_2;
        void var1_1;
        this.validateScheduled((long)var1_1, (TimeUnit)var3_2);
    }

    @Deprecated
    protected void validateScheduled(long amount, TimeUnit unit) {
    }

    /*
     * WARNING - void declaration
     */
    final void scheduleFromEventLoop(ScheduledFutureTask<?> task) {
        void var1_1;
        this.scheduledTaskQueue().add(var1_1.setId(++this.nextTaskId));
    }

    /*
     * WARNING - void declaration
     */
    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> task) {
        void var1_1;
        if (this.inEventLoop()) {
            this.scheduleFromEventLoop(task);
        } else {
            long deadlineNanos = task.deadlineNanos();
            if (this.beforeScheduledTaskSubmitted(deadlineNanos)) {
                this.execute(task);
            } else {
                void var2_2;
                this.lazyExecute(task);
                if (this.afterScheduledTaskSubmitted((long)var2_2)) {
                    this.execute(WAKEUP_TASK);
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void removeScheduled(ScheduledFutureTask<?> task) {
        void var1_1;
        assert (task.isCancelled());
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(task);
            return;
        }
        this.lazyExecute((Runnable)var1_1);
    }

    protected boolean beforeScheduledTaskSubmitted(long deadlineNanos) {
        return true;
    }

    protected boolean afterScheduledTaskSubmitted(long deadlineNanos) {
        return true;
    }
}

