/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ShortObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ShortCollections {
    private static final ShortObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private ShortCollections() {
    }

    public static <V> ShortObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> ShortObjectMap<V> unmodifiableMap(ShortObjectMap<V> map) {
        ShortObjectMap<V> shortObjectMap;
        return new UnmodifiableMap<V>(shortObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements ShortObjectMap<V> {
        private final ShortObjectMap<V> map;
        private Set<Short> keySet;
        private Set<Map.Entry<Short, V>> entrySet;
        private Collection<V> values;
        private Iterable<ShortObjectMap.PrimitiveEntry<V>> entries;

        /*
         * WARNING - void declaration
         */
        UnmodifiableMap(ShortObjectMap<V> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(short key) {
            void var1_1;
            return this.map.get((short)var1_1);
        }

        @Override
        public final V put(short key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(short key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(short key) {
            void var1_1;
            return this.map.containsKey((short)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsValue(Object value) {
            void var1_1;
            return this.map.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            void var1_1;
            return this.map.get(var1_1);
        }

        @Override
        public final V put(Short key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Short, ? extends V> m) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<ShortObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<ShortObjectMap.PrimitiveEntry<V>>(this){
                    final /* synthetic */ UnmodifiableMap this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public Iterator<ShortObjectMap.PrimitiveEntry<V>> iterator() {
                        return this.this$0.new IteratorImpl(this.this$0.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Short> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Short, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements ShortObjectMap.PrimitiveEntry<V> {
            private final ShortObjectMap.PrimitiveEntry<V> entry;

            /*
             * WARNING - void declaration
             */
            EntryImpl(ShortObjectMap.PrimitiveEntry<V> entry) {
                void var2_2;
                this.entry = var2_2;
            }

            @Override
            public short key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V value) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<ShortObjectMap.PrimitiveEntry<V>> {
            final Iterator<ShortObjectMap.PrimitiveEntry<V>> iter;

            /*
             * WARNING - void declaration
             */
            IteratorImpl(Iterator<ShortObjectMap.PrimitiveEntry<V>> iter) {
                void var2_2;
                this.iter = var2_2;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public ShortObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements ShortObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(short key) {
            return null;
        }

        @Override
        public final Object put(short key, Object value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(short key) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object key) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Short> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(short key) {
            return false;
        }

        @Override
        public final boolean containsValue(Object value) {
            return false;
        }

        @Override
        public final Iterable<ShortObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object key) {
            return null;
        }

        @Override
        public final Object put(Short key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object key) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Short, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Short, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

