/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.LongObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongObjectHashMap<V>
implements LongObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private long[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Long> keySet = new KeySet();
    private final Set<Map.Entry<Long, V>> entrySet = new EntrySet();
    private final Iterable<LongObjectMap.PrimitiveEntry<V>> entries = new Iterable<LongObjectMap.PrimitiveEntry<V>>(this){
        final /* synthetic */ LongObjectHashMap this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Iterator<LongObjectMap.PrimitiveEntry<V>> iterator() {
            return this.this$0.new PrimitiveIterator();
        }
    };

    public LongObjectHashMap() {
        this(8, 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    public LongObjectHashMap(int initialCapacity) {
        this((int)var1_1, 0.5f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LongObjectHashMap(int initialCapacity, float loadFactor) {
        void var1_1;
        void var2_3;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = MathUtil.safeFindNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new long[capacity];
        Object[] temp = new Object[capacity];
        this.values = var2_3;
        this.maxSize = this.calcMaxSize((int)var1_1);
    }

    private static <T> T toExternal(T value) {
        T t;
        assert (value != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (value == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T value) {
        T t;
        if (value == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(long key) {
        void var1_2;
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        return LongObjectHashMap.toExternal(this.values[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(long key, V value) {
        int startIndex;
        int index = startIndex = this.hashIndex(key);
        do {
            void var1_2;
            if (this.values[index] == null) {
                this.keys[index] = key;
                this.values[index] = LongObjectHashMap.toInternal(value);
                this.growSize();
                return null;
            }
            if (this.keys[index] != key) continue;
            V previousValue = this.values[index];
            this.values[index] = LongObjectHashMap.toInternal(value);
            return LongObjectHashMap.toExternal(var1_2);
        } while ((index = this.probeNext(index)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Long, ? extends V> sourceMap) {
        Iterator iterator;
        if (sourceMap instanceof LongObjectHashMap) {
            LongObjectHashMap source = (LongObjectHashMap)sourceMap;
            for (int i = 0; i < source.values.length; ++i) {
                void var3_4;
                V sourceValue = source.values[i];
                if (sourceValue == null) continue;
                this.put(source.keys[i], (V)var3_4);
            }
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_3;
            this.put((Long)entry.getKey(), (V)var2_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(long key) {
        void var2_3;
        void var1_2;
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        V prev = this.values[index];
        this.removeAt((int)var1_2);
        return LongObjectHashMap.toExternal(var2_3);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(long key) {
        void var1_1;
        return this.indexOf((long)var1_1) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Object v1 = LongObjectHashMap.toInternal(value);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v2 = VArray[i];
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(this){
            final /* synthetic */ LongObjectHashMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(this){
                    final PrimitiveIterator iter;
                    final /* synthetic */ 2 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.iter = this.this$1.this$0.new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.size;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hash = this.size;
        long[] lArray = this.keys;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            long key = lArray[i];
            hash ^= LongObjectHashMap.hashCode(key);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap other = (LongObjectMap)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            void var3_3;
            V value = this.values[i];
            if (value == null) continue;
            long key = this.keys[i];
            Object otherValue = other.get(key);
            if (!(value == NULL_VALUE ? otherValue != null : !var3_3.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.containsKey(longObjectHashMap.objectToKey(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_1;
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.get(longObjectHashMap.objectToKey(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(Long key, V value) {
        void var2_2;
        void var1_1;
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.put(longObjectHashMap.objectToKey(var1_1), (V)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        LongObjectHashMap longObjectHashMap = this;
        return longObjectHashMap.remove(longObjectHashMap.objectToKey(var1_1));
    }

    @Override
    public Set<Long> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    private long objectToKey(Object key) {
        return (Long)key;
    }

    private int indexOf(long key) {
        int startIndex;
        int index = startIndex = this.hashIndex(key);
        do {
            if (this.values[index] == null) {
                return -1;
            }
            if (key != this.keys[index]) continue;
            return index;
        } while ((index = this.probeNext(index)) != startIndex);
        return -1;
    }

    private int hashIndex(long key) {
        return LongObjectHashMap.hashCode(key) & this.mask;
    }

    private static int hashCode(long key) {
        long l = key;
        return (int)(l ^ l >>> 32);
    }

    private int probeNext(int index) {
        return index + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            LongObjectHashMap longObjectHashMap = this;
            longObjectHashMap.rehash(longObjectHashMap.keys.length << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeAt(int index) {
        void var1_1;
        void var2_2;
        --this.size;
        this.keys[index] = 0L;
        this.values[index] = null;
        int nextFree = index;
        int i = this.probeNext(index);
        V value = this.values[i];
        while (value != null) {
            long key = this.keys[i];
            int bucket = this.hashIndex(key);
            if (i < bucket && (bucket <= nextFree || nextFree <= i) || bucket <= nextFree && nextFree <= i) {
                this.keys[nextFree] = key;
                this.values[nextFree] = value;
                this.keys[i] = 0L;
                this.values[i] = null;
                nextFree = i;
            }
            i = this.probeNext(i);
            value = this.values[i];
        }
        return var2_2 != var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int calcMaxSize(int capacity) {
        void var1_1;
        int n = capacity - 1;
        return Math.min(n, (int)((float)var1_1 * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        long[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new long[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i = 0; i < oldVals.length; ++i) {
            V oldVal = oldVals[i];
            if (oldVal == null) continue;
            long oldKey = oldKeys[i];
            int index = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index] == null) {
                    this.keys[index] = oldKey;
                    this.values[index] = oldVal;
                    continue block0;
                }
                index = this.probeNext(index);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first = true;
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            LongObjectHashMap longObjectHashMap = this;
            sb.append(longObjectHashMap.keyToString(longObjectHashMap.keys[i])).append('=').append((Object)(value == this ? "(this Map)" : LongObjectHashMap.toExternal(value)));
            first = false;
        }
        return var1_1.append('}').toString();
    }

    protected String keyToString(long key) {
        return Long.toString(key);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(LongObjectHashMap x0, int x1) {
        void var1_1;
        return x0.removeAt((int)var1_1);
    }

    final class MapEntry
    implements Map.Entry<Long, V> {
        private final int entryIndex;
        final /* synthetic */ LongObjectHashMap this$0;

        /*
         * WARNING - void declaration
         */
        MapEntry(LongObjectHashMap this$0, int entryIndex) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.entryIndex = var2_2;
        }

        @Override
        public final Long getKey() {
            this.verifyExists();
            return this.this$0.keys[this.entryIndex];
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return LongObjectHashMap.toExternal(this.this$0.values[this.entryIndex]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V value) {
            void var2_2;
            void var1_1;
            this.verifyExists();
            Object prevValue = LongObjectHashMap.toExternal(this.this$0.values[this.entryIndex]);
            ((LongObjectHashMap)this.this$0).values[this.entryIndex] = LongObjectHashMap.toInternal(var1_1);
            return var2_2;
        }

        private void verifyExists() {
            if (this.this$0.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Long, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Long, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(LongObjectHashMap.this, this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements LongObjectMap.PrimitiveEntry<V>,
    Iterator<LongObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != LongObjectHashMap.this.values.length && LongObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != LongObjectHashMap.this.values.length;
        }

        @Override
        public final LongObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (LongObjectHashMap.access$700(LongObjectHashMap.this, this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final long key() {
            return LongObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return LongObjectHashMap.toExternal(LongObjectHashMap.this.values[this.entryIndex]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValue(V value) {
            void var1_1;
            ((LongObjectHashMap)LongObjectHashMap.this).values[this.entryIndex] = LongObjectHashMap.toInternal(var1_1);
        }
    }

    private final class KeySet
    extends AbstractSet<Long> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return LongObjectHashMap.this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return LongObjectHashMap.this.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return LongObjectHashMap.this.remove(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> retainedKeys) {
            void var2_2;
            boolean changed = false;
            Iterator iter = LongObjectHashMap.this.entries().iterator();
            while (iter.hasNext()) {
                LongObjectMap.PrimitiveEntry entry = iter.next();
                if (retainedKeys.contains(entry.key())) continue;
                changed = true;
                iter.remove();
            }
            return (boolean)var2_2;
        }

        @Override
        public final void clear() {
            LongObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Long> iterator() {
            return new Iterator<Long>(this){
                private final Iterator<Map.Entry<Long, V>> iter;
                final /* synthetic */ KeySet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.iter = this.this$1.LongObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Long next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Long, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return LongObjectHashMap.this.size();
        }
    }
}

