/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.LongObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LongCollections {
    private static final LongObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private LongCollections() {
    }

    public static <V> LongObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> LongObjectMap<V> unmodifiableMap(LongObjectMap<V> map) {
        LongObjectMap<V> longObjectMap;
        return new UnmodifiableMap<V>(longObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements LongObjectMap<V> {
        private final LongObjectMap<V> map;
        private Set<Long> keySet;
        private Set<Map.Entry<Long, V>> entrySet;
        private Collection<V> values;
        private Iterable<LongObjectMap.PrimitiveEntry<V>> entries;

        /*
         * WARNING - void declaration
         */
        UnmodifiableMap(LongObjectMap<V> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(long key) {
            void var1_1;
            return this.map.get((long)var1_1);
        }

        @Override
        public final V put(long key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(long key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(long key) {
            void var1_1;
            return this.map.containsKey((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsValue(Object value) {
            void var1_1;
            return this.map.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            void var1_1;
            return this.map.get(var1_1);
        }

        @Override
        public final V put(Long key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Long, ? extends V> m) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<LongObjectMap.PrimitiveEntry<V>>(this){
                    final /* synthetic */ UnmodifiableMap this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public Iterator<LongObjectMap.PrimitiveEntry<V>> iterator() {
                        return this.this$0.new IteratorImpl(this.this$0.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Long> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Long, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements LongObjectMap.PrimitiveEntry<V> {
            private final LongObjectMap.PrimitiveEntry<V> entry;

            /*
             * WARNING - void declaration
             */
            EntryImpl(LongObjectMap.PrimitiveEntry<V> entry) {
                void var2_2;
                this.entry = var2_2;
            }

            @Override
            public long key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V value) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<LongObjectMap.PrimitiveEntry<V>> {
            final Iterator<LongObjectMap.PrimitiveEntry<V>> iter;

            /*
             * WARNING - void declaration
             */
            IteratorImpl(Iterator<LongObjectMap.PrimitiveEntry<V>> iter) {
                void var2_2;
                this.iter = var2_2;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public LongObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements LongObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(long key) {
            return null;
        }

        @Override
        public final Object put(long key, Object value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(long key) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object key) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Long> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(long key) {
            return false;
        }

        @Override
        public final boolean containsValue(Object value) {
            return false;
        }

        @Override
        public final Iterable<LongObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object key) {
            return null;
        }

        @Override
        public final Object put(Long key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object key) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Long, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Long, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

