/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class IntCollections {
    private static final IntObjectMap<Object> EMPTY_MAP = new EmptyMap();

    private IntCollections() {
    }

    public static <V> IntObjectMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> IntObjectMap<V> unmodifiableMap(IntObjectMap<V> map) {
        IntObjectMap<V> intObjectMap;
        return new UnmodifiableMap<V>(intObjectMap);
    }

    private static final class UnmodifiableMap<V>
    implements IntObjectMap<V> {
        private final IntObjectMap<V> map;
        private Set<Integer> keySet;
        private Set<Map.Entry<Integer, V>> entrySet;
        private Collection<V> values;
        private Iterable<IntObjectMap.PrimitiveEntry<V>> entries;

        /*
         * WARNING - void declaration
         */
        UnmodifiableMap(IntObjectMap<V> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(int key) {
            void var1_1;
            return this.map.get((int)var1_1);
        }

        @Override
        public final V put(int key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(int key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("clear");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(int key) {
            void var1_1;
            return this.map.containsKey((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsValue(Object value) {
            void var1_1;
            return this.map.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            void var1_1;
            return this.map.get(var1_1);
        }

        @Override
        public final V put(Integer key, V value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public final void putAll(Map<? extends Integer, ? extends V> m) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public final Iterable<IntObjectMap.PrimitiveEntry<V>> entries() {
            if (this.entries == null) {
                this.entries = new Iterable<IntObjectMap.PrimitiveEntry<V>>(this){
                    final /* synthetic */ UnmodifiableMap this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public Iterator<IntObjectMap.PrimitiveEntry<V>> iterator() {
                        return this.this$0.new IteratorImpl(this.this$0.map.entries().iterator());
                    }
                };
            }
            return this.entries;
        }

        @Override
        public final Set<Integer> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.map.keySet());
            }
            return this.keySet;
        }

        @Override
        public final Set<Map.Entry<Integer, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(this.map.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public final Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.map.values());
            }
            return this.values;
        }

        private class EntryImpl
        implements IntObjectMap.PrimitiveEntry<V> {
            private final IntObjectMap.PrimitiveEntry<V> entry;

            /*
             * WARNING - void declaration
             */
            EntryImpl(IntObjectMap.PrimitiveEntry<V> entry) {
                void var2_2;
                this.entry = var2_2;
            }

            @Override
            public int key() {
                return this.entry.key();
            }

            @Override
            public V value() {
                return this.entry.value();
            }

            @Override
            public void setValue(V value) {
                throw new UnsupportedOperationException("setValue");
            }
        }

        private class IteratorImpl
        implements Iterator<IntObjectMap.PrimitiveEntry<V>> {
            final Iterator<IntObjectMap.PrimitiveEntry<V>> iter;

            /*
             * WARNING - void declaration
             */
            IteratorImpl(Iterator<IntObjectMap.PrimitiveEntry<V>> iter) {
                void var2_2;
                this.iter = var2_2;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public IntObjectMap.PrimitiveEntry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new EntryImpl(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    private static final class EmptyMap
    implements IntObjectMap<Object> {
        private EmptyMap() {
        }

        @Override
        public final Object get(int key) {
            return null;
        }

        @Override
        public final Object put(int key, Object value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public final Object remove(int key) {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean containsKey(Object key) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final Set<Integer> keySet() {
            return Collections.emptySet();
        }

        @Override
        public final boolean containsKey(int key) {
            return false;
        }

        @Override
        public final boolean containsValue(Object value) {
            return false;
        }

        @Override
        public final Iterable<IntObjectMap.PrimitiveEntry<Object>> entries() {
            return Collections.emptySet();
        }

        @Override
        public final Object get(Object key) {
            return null;
        }

        @Override
        public final Object put(Integer key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object remove(Object key) {
            return null;
        }

        @Override
        public final void putAll(Map<? extends Integer, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public final Set<Map.Entry<Integer, Object>> entrySet() {
            return Collections.emptySet();
        }
    }
}

