/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.CharObjectMap;
import io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CharObjectHashMap<V>
implements CharObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private char[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Character> keySet = new KeySet();
    private final Set<Map.Entry<Character, V>> entrySet = new EntrySet();
    private final Iterable<CharObjectMap.PrimitiveEntry<V>> entries = new Iterable<CharObjectMap.PrimitiveEntry<V>>(this){
        final /* synthetic */ CharObjectHashMap this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Iterator<CharObjectMap.PrimitiveEntry<V>> iterator() {
            return this.this$0.new PrimitiveIterator();
        }
    };

    public CharObjectHashMap() {
        this(8, 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    public CharObjectHashMap(int initialCapacity) {
        this((int)var1_1, 0.5f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CharObjectHashMap(int initialCapacity, float loadFactor) {
        void var1_1;
        void var2_3;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = MathUtil.safeFindNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new char[capacity];
        Object[] temp = new Object[capacity];
        this.values = var2_3;
        this.maxSize = this.calcMaxSize((int)var1_1);
    }

    private static <T> T toExternal(T value) {
        T t;
        assert (value != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (value == NULL_VALUE) {
            return null;
        }
        return t;
    }

    private static <T> T toInternal(T value) {
        T t;
        if (value == null) {
            return (T)NULL_VALUE;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(char key) {
        void var1_1;
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        return CharObjectHashMap.toExternal(this.values[var1_1]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(char key, V value) {
        int startIndex;
        int index = startIndex = this.hashIndex(key);
        do {
            void var1_2;
            if (this.values[index] == null) {
                this.keys[index] = key;
                this.values[index] = CharObjectHashMap.toInternal(value);
                this.growSize();
                return null;
            }
            if (this.keys[index] != key) continue;
            V previousValue = this.values[index];
            this.values[index] = CharObjectHashMap.toInternal(value);
            return CharObjectHashMap.toExternal(var1_2);
        } while ((index = this.probeNext(index)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Character, ? extends V> sourceMap) {
        Iterator iterator;
        if (sourceMap instanceof CharObjectHashMap) {
            CharObjectHashMap source = (CharObjectHashMap)sourceMap;
            for (int i = 0; i < source.values.length; ++i) {
                void var3_4;
                V sourceValue = source.values[i];
                if (sourceValue == null) continue;
                this.put(source.keys[i], (V)var3_4);
            }
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_3;
            this.put((Character)entry.getKey(), (V)var2_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(char key) {
        void var2_2;
        void var1_1;
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        V prev = this.values[index];
        this.removeAt((int)var1_1);
        return CharObjectHashMap.toExternal(var2_2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(char key) {
        void var1_1;
        return this.indexOf((char)var1_1) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Object v1 = CharObjectHashMap.toInternal(value);
        V[] VArray = this.values;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            V v2 = VArray[i];
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<CharObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(this){
            final /* synthetic */ CharObjectHashMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(this){
                    final PrimitiveIterator iter;
                    final /* synthetic */ 2 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.iter = this.this$1.this$0.new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.size;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hash = this.size;
        char[] cArray = this.keys;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            char key = cArray[i];
            hash ^= CharObjectHashMap.hashCode(key);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap other = (CharObjectMap)obj;
        if (this.size != other.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            void var3_3;
            V value = this.values[i];
            if (value == null) continue;
            char key = this.keys[i];
            Object otherValue = other.get(key);
            if (!(value == NULL_VALUE ? otherValue != null : !var3_3.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.containsKey(charObjectHashMap.objectToKey(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_1;
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.get(charObjectHashMap.objectToKey(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(Character key, V value) {
        void var2_2;
        void var1_1;
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.put(charObjectHashMap.objectToKey(var1_1), (V)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.remove(charObjectHashMap.objectToKey(var1_1));
    }

    @Override
    public Set<Character> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return this.entrySet;
    }

    private char objectToKey(Object key) {
        return ((Character)key).charValue();
    }

    private int indexOf(char key) {
        int startIndex;
        int index = startIndex = this.hashIndex(key);
        do {
            if (this.values[index] == null) {
                return -1;
            }
            if (key != this.keys[index]) continue;
            return index;
        } while ((index = this.probeNext(index)) != startIndex);
        return -1;
    }

    private int hashIndex(char key) {
        return CharObjectHashMap.hashCode(key) & this.mask;
    }

    private static int hashCode(char key) {
        return key;
    }

    private int probeNext(int index) {
        return index + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            CharObjectHashMap charObjectHashMap = this;
            charObjectHashMap.rehash(charObjectHashMap.keys.length << 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeAt(int index) {
        void var1_1;
        void var2_2;
        --this.size;
        this.keys[index] = '\u0000';
        this.values[index] = null;
        int nextFree = index;
        int i = this.probeNext(index);
        V value = this.values[i];
        while (value != null) {
            char key = this.keys[i];
            int bucket = this.hashIndex(key);
            if (i < bucket && (bucket <= nextFree || nextFree <= i) || bucket <= nextFree && nextFree <= i) {
                this.keys[nextFree] = key;
                this.values[nextFree] = value;
                this.keys[i] = '\u0000';
                this.values[i] = null;
                nextFree = i;
            }
            i = this.probeNext(i);
            value = this.values[i];
        }
        return var2_2 != var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int calcMaxSize(int capacity) {
        void var1_1;
        int n = capacity - 1;
        return Math.min(n, (int)((float)var1_1 * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        char[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new char[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i = 0; i < oldVals.length; ++i) {
            V oldVal = oldVals[i];
            if (oldVal == null) continue;
            char oldKey = oldKeys[i];
            int index = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index] == null) {
                    this.keys[index] = oldKey;
                    this.values[index] = oldVal;
                    continue block0;
                }
                index = this.probeNext(index);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first = true;
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            CharObjectHashMap charObjectHashMap = this;
            sb.append(charObjectHashMap.keyToString(charObjectHashMap.keys[i])).append('=').append((Object)(value == this ? "(this Map)" : CharObjectHashMap.toExternal(value)));
            first = false;
        }
        return var1_1.append('}').toString();
    }

    protected String keyToString(char key) {
        return Character.toString(key);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(CharObjectHashMap x0, int x1) {
        void var1_1;
        return x0.removeAt((int)var1_1);
    }

    final class MapEntry
    implements Map.Entry<Character, V> {
        private final int entryIndex;
        final /* synthetic */ CharObjectHashMap this$0;

        /*
         * WARNING - void declaration
         */
        MapEntry(CharObjectHashMap this$0, int entryIndex) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.entryIndex = var2_2;
        }

        @Override
        public final Character getKey() {
            this.verifyExists();
            return Character.valueOf(this.this$0.keys[this.entryIndex]);
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return CharObjectHashMap.toExternal(this.this$0.values[this.entryIndex]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V value) {
            void var2_2;
            void var1_1;
            this.verifyExists();
            Object prevValue = CharObjectHashMap.toExternal(this.this$0.values[this.entryIndex]);
            ((CharObjectHashMap)this.this$0).values[this.entryIndex] = CharObjectHashMap.toInternal(var1_1);
            return var2_2;
        }

        private void verifyExists() {
            if (this.this$0.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Character, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Character, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(CharObjectHashMap.this, this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements CharObjectMap.PrimitiveEntry<V>,
    Iterator<CharObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != CharObjectHashMap.this.values.length && CharObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != CharObjectHashMap.this.values.length;
        }

        @Override
        public final CharObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (CharObjectHashMap.access$700(CharObjectHashMap.this, this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final char key() {
            return CharObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValue(V value) {
            void var1_1;
            ((CharObjectHashMap)CharObjectHashMap.this).values[this.entryIndex] = CharObjectHashMap.toInternal(var1_1);
        }
    }

    private final class KeySet
    extends AbstractSet<Character> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return CharObjectHashMap.this.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return CharObjectHashMap.this.remove(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> retainedKeys) {
            void var2_2;
            boolean changed = false;
            Iterator iter = CharObjectHashMap.this.entries().iterator();
            while (iter.hasNext()) {
                CharObjectMap.PrimitiveEntry entry = iter.next();
                if (retainedKeys.contains(Character.valueOf(entry.key()))) continue;
                changed = true;
                iter.remove();
            }
            return (boolean)var2_2;
        }

        @Override
        public final void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Character> iterator() {
            return new Iterator<Character>(this){
                private final Iterator<Map.Entry<Character, V>> iter;
                final /* synthetic */ KeySet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.iter = this.this$1.CharObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Character next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Character, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Character, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }
    }
}

