/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class Version {
    private static final String PROP_VERSION = ".version";
    private static final String PROP_BUILD_DATE = ".buildDate";
    private static final String PROP_COMMIT_DATE = ".commitDate";
    private static final String PROP_SHORT_COMMIT_HASH = ".shortCommitHash";
    private static final String PROP_LONG_COMMIT_HASH = ".longCommitHash";
    private static final String PROP_REPO_STATUS = ".repoStatus";
    private final String artifactId;
    private final String artifactVersion;
    private final long buildTimeMillis;
    private final long commitTimeMillis;
    private final String shortCommitHash;
    private final String longCommitHash;
    private final String repositoryStatus;

    public static Map<String, Version> identify() {
        return Version.identify(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Version> identify(ClassLoader classLoader) {
        HashSet hashSet;
        Iterator iterator;
        InputStream in;
        Object object;
        if (classLoader == null) {
            classLoader = PlatformDependent.getContextClassLoader();
        }
        Properties props = new Properties();
        try {
            HashSet resources = classLoader.getResources("META-INF/io.netty.versions.properties");
            while (resources.hasMoreElements()) {
                object = (URL)resources.nextElement();
                in = ((URL)object).openStream();
                try {
                    props.load(in);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        HashSet artifactIds = new HashSet();
        object = props.keySet().iterator();
        while (object.hasNext()) {
            String artifactId;
            in = object.next();
            String string = (String)((Object)in);
            int dotIndex = string.indexOf(46);
            if (dotIndex <= 0 || !props.containsKey((artifactId = string.substring(0, dotIndex)) + PROP_VERSION) || !props.containsKey(artifactId + PROP_BUILD_DATE) || !props.containsKey(artifactId + PROP_COMMIT_DATE) || !props.containsKey(artifactId + PROP_SHORT_COMMIT_HASH) || !props.containsKey(artifactId + PROP_LONG_COMMIT_HASH) || !props.containsKey(artifactId + PROP_REPO_STATUS)) continue;
            artifactIds.add(iterator);
        }
        TreeMap<String, Version> versions = new TreeMap<String, Version>();
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            versions.put(string, new Version(string, props.getProperty(string + PROP_VERSION), Version.parseIso8601(props.getProperty(string + PROP_BUILD_DATE)), Version.parseIso8601(props.getProperty(string + PROP_COMMIT_DATE)), props.getProperty(string + PROP_SHORT_COMMIT_HASH), props.getProperty(string + PROP_LONG_COMMIT_HASH), props.getProperty(string + PROP_REPO_STATUS)));
        }
        return object;
    }

    private static long parseIso8601(String value) {
        try {
            String string;
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(string).getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        for (Version v : Version.identify().values()) {
            void var1_1;
            System.err.println(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Version(String artifactId, String artifactVersion, long buildTimeMillis, long commitTimeMillis, String shortCommitHash, String longCommitHash, String repositoryStatus) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.artifactId = var1_1;
        this.artifactVersion = var2_2;
        this.buildTimeMillis = var3_3;
        this.commitTimeMillis = commitTimeMillis;
        this.shortCommitHash = shortCommitHash;
        this.longCommitHash = longCommitHash;
        this.repositoryStatus = repositoryStatus;
    }

    public final String artifactId() {
        return this.artifactId;
    }

    public final String artifactVersion() {
        return this.artifactVersion;
    }

    public final long buildTimeMillis() {
        return this.buildTimeMillis;
    }

    public final long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    public final String shortCommitHash() {
        return this.shortCommitHash;
    }

    public final String longCommitHash() {
        return this.longCommitHash;
    }

    public final String repositoryStatus() {
        return this.repositoryStatus;
    }

    public final String toString() {
        return this.artifactId + '-' + this.artifactVersion + '.' + this.shortCommitHash + ("clean".equals(this.repositoryStatus) ? "" : " (repository: " + this.repositoryStatus + ')');
    }
}

