/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public final class ThreadDeathWatcher {
    private static final InternalLogger logger;
    static final ThreadFactory threadFactory;
    private static final Queue<Entry> pendingEntries;
    private static final Watcher watcher;
    private static final AtomicBoolean started;
    private static volatile Thread watcherThread;

    /*
     * WARNING - void declaration
     */
    public static void watch(Thread thread, Runnable task) {
        void var1_1;
        Thread thread2;
        ObjectUtil.checkNotNull(thread, "thread");
        ObjectUtil.checkNotNull(task, "task");
        if (!thread.isAlive()) {
            throw new IllegalArgumentException("thread must be alive.");
        }
        ThreadDeathWatcher.schedule(thread2, (Runnable)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void unwatch(Thread thread, Runnable task) {
        void var1_1;
        ThreadDeathWatcher.schedule(ObjectUtil.checkNotNull(thread, "thread"), (Runnable)ObjectUtil.checkNotNull(var1_1, "task"), false);
    }

    /*
     * WARNING - void declaration
     */
    private static void schedule(Thread thread, Runnable task, boolean isWatch) {
        void var2_2;
        void var1_1;
        pendingEntries.add(new Entry(thread, (Runnable)var1_1, (boolean)var2_2));
        if (started.compareAndSet(false, true)) {
            Thread thread2;
            final Thread watcherThread = threadFactory.newThread(watcher);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public final Void run() {
                    watcherThread.setContextClassLoader(null);
                    return null;
                }
            });
            watcherThread.start();
            ThreadDeathWatcher.watcherThread = thread2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean awaitInactivity(long timeout, TimeUnit unit) throws InterruptedException {
        ObjectUtil.checkNotNull(unit, "unit");
        Thread watcherThread = ThreadDeathWatcher.watcherThread;
        if (watcherThread != null) {
            void var3_2;
            long l;
            void var2_1;
            watcherThread.join(var2_1.toMillis(l));
            return !var3_2.isAlive();
        }
        return true;
    }

    private ThreadDeathWatcher() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(ThreadDeathWatcher.class);
        pendingEntries = new ConcurrentLinkedQueue<Entry>();
        watcher = new Watcher();
        started = new AtomicBoolean();
        String poolName = "threadDeathWatcher";
        String serviceThreadPrefix = SystemPropertyUtil.get("io.netty.serviceThreadPrefix");
        if (!StringUtil.isNullOrEmpty(serviceThreadPrefix)) {
            void var1_1;
            poolName = (String)var1_1 + poolName;
        }
        threadFactory = new DefaultThreadFactory((String)var0, true, 1, null);
    }

    private static final class Entry {
        final Thread thread;
        final Runnable task;
        final boolean isWatch;

        /*
         * WARNING - void declaration
         */
        Entry(Thread thread, Runnable task, boolean isWatch) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.thread = var1_1;
            this.task = var2_2;
            this.isWatch = var3_3;
        }

        public final int hashCode() {
            return this.thread.hashCode() ^ this.task.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry that = (Entry)obj;
            return this.thread == that.thread && this.task == var1_1.task;
        }
    }

    private static final class Watcher
    implements Runnable {
        private final List<Entry> watchees = new ArrayList<Entry>();

        private Watcher() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (true) {
                void var1_1;
                this.fetchWatchees();
                this.notifyWatchees();
                this.fetchWatchees();
                this.notifyWatchees();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.watchees.isEmpty() || !pendingEntries.isEmpty()) continue;
                boolean stopped = started.compareAndSet(true, false);
                assert (var1_1 != false);
                if (pendingEntries.isEmpty() || !started.compareAndSet(false, true)) break;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fetchWatchees() {
            Entry e;
            while ((e = (Entry)pendingEntries.poll()) != null) {
                void var1_1;
                if (e.isWatch) {
                    this.watchees.add(e);
                    continue;
                }
                this.watchees.remove(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void notifyWatchees() {
            List<Entry> watchees = this.watchees;
            int i = 0;
            while (i < watchees.size()) {
                Entry e = watchees.get(i);
                if (!e.thread.isAlive()) {
                    watchees.remove(i);
                    try {
                        e.task.run();
                    }
                    catch (Throwable t) {
                        void var3_4;
                        logger.warn("Thread death watcher task raised an exception:", (Throwable)var3_4);
                    }
                    continue;
                }
                ++i;
            }
        }
    }
}

