/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;

public abstract class ResourceLeakDetectorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ResourceLeakDetectorFactory.class);
    private static volatile ResourceLeakDetectorFactory factoryInstance = new DefaultResourceLeakDetectorFactory();

    public static ResourceLeakDetectorFactory instance() {
        return factoryInstance;
    }

    public static void setResourceLeakDetectorFactory(ResourceLeakDetectorFactory factory) {
        factoryInstance = ObjectUtil.checkNotNull(factory, "factory");
    }

    /*
     * WARNING - void declaration
     */
    public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource) {
        void var1_1;
        return this.newResourceLeakDetector((Class<T>)var1_1, ResourceLeakDetector.SAMPLING_INTERVAL);
    }

    @Deprecated
    public abstract <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> var1, int var2, long var3);

    /*
     * WARNING - void declaration
     */
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkPositive(samplingInterval, "samplingInterval");
        return this.newResourceLeakDetector((Class<T>)var1_1, (int)var2_2, Long.MAX_VALUE);
    }

    private static final class DefaultResourceLeakDetectorFactory
    extends ResourceLeakDetectorFactory {
        private final Constructor<?> obsoleteCustomClassConstructor;
        private final Constructor<?> customClassConstructor;

        /*
         * WARNING - void declaration
         */
        DefaultResourceLeakDetectorFactory() {
            void var1_1;
            String customLeakDetector;
            try {
                customLeakDetector = SystemPropertyUtil.get("io.netty.customResourceLeakDetector");
            }
            catch (Throwable cause) {
                logger.error("Could not access System property: io.netty.customResourceLeakDetector", cause);
                customLeakDetector = null;
            }
            if (customLeakDetector == null) {
                DefaultResourceLeakDetectorFactory defaultResourceLeakDetectorFactory = this;
                defaultResourceLeakDetectorFactory.customClassConstructor = null;
                defaultResourceLeakDetectorFactory.obsoleteCustomClassConstructor = null;
                return;
            }
            this.obsoleteCustomClassConstructor = DefaultResourceLeakDetectorFactory.obsoleteCustomClassConstructor(customLeakDetector);
            this.customClassConstructor = DefaultResourceLeakDetectorFactory.customClassConstructor((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static Constructor<?> obsoleteCustomClassConstructor(String customLeakDetector) {
            try {
                Class<?> detectorClass = Class.forName(customLeakDetector, true, PlatformDependent.getSystemClassLoader());
                if (ResourceLeakDetector.class.isAssignableFrom(detectorClass)) {
                    return detectorClass.getConstructor(Class.class, Integer.TYPE, Long.TYPE);
                }
                logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)customLeakDetector);
            }
            catch (Throwable t) {
                void var1_2;
                String string;
                logger.error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)var1_2);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private static Constructor<?> customClassConstructor(String customLeakDetector) {
            try {
                Class<?> detectorClass = Class.forName(customLeakDetector, true, PlatformDependent.getSystemClassLoader());
                if (ResourceLeakDetector.class.isAssignableFrom(detectorClass)) {
                    return detectorClass.getConstructor(Class.class, Integer.TYPE);
                }
                logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)customLeakDetector);
            }
            catch (Throwable t) {
                void var1_2;
                String string;
                logger.error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)var1_2);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.obsoleteCustomClassConstructor != null) {
                try {
                    ResourceLeakDetector leakDetector = (ResourceLeakDetector)this.obsoleteCustomClassConstructor.newInstance(resource, samplingInterval, maxActive);
                    logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.obsoleteCustomClassConstructor.getDeclaringClass().getName());
                    return leakDetector;
                }
                catch (Throwable t) {
                    logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.obsoleteCustomClassConstructor.getDeclaringClass().getName(), resource, t);
                }
            }
            ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector((Class<?>)var1_1, (int)var2_2, (long)var3_3);
            logger.debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
            return resourceLeakDetector;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
            void var3_5;
            void var2_2;
            void var1_1;
            if (this.customClassConstructor != null) {
                try {
                    ResourceLeakDetector leakDetector = (ResourceLeakDetector)this.customClassConstructor.newInstance(resource, samplingInterval);
                    logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.customClassConstructor.getDeclaringClass().getName());
                    return leakDetector;
                }
                catch (Throwable t) {
                    logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.customClassConstructor.getDeclaringClass().getName(), resource, t);
                }
            }
            ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector((Class<?>)var1_1, (int)var2_2);
            logger.debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
            return var3_5;
        }
    }
}

