/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakHint;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "io.netty.leakDetection.level";
    private static final Level DEFAULT_LEVEL;
    private static final String PROP_TARGET_RECORDS = "io.netty.leakDetection.targetRecords";
    private static final int DEFAULT_TARGET_RECORDS = 4;
    private static final String PROP_SAMPLING_INTERVAL = "io.netty.leakDetection.samplingInterval";
    private static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static Level level;
    private static final InternalLogger logger;
    private final Set<DefaultResourceLeak<?>> allLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Set<String> reportedLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String resourceType;
    private final int samplingInterval;
    private volatile LeakListener leakListener;
    private static final AtomicReference<String[]> excludedMethods;

    @Deprecated
    public static void setEnabled(boolean enabled) {
        ResourceLeakDetector.setLevel(enabled ? Level.SIMPLE : Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static void setLevel(Level level) {
        ResourceLeakDetector.level = ObjectUtil.checkNotNull(level, "level");
    }

    public static Level getLevel() {
        return level;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ResourceLeakDetector(Class<?> resourceType) {
        this(StringUtil.simpleClassName(var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ResourceLeakDetector(String resourceType) {
        this((String)var1_1, 128, Long.MAX_VALUE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        this((Class<?>)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        this(StringUtil.simpleClassName(var1_1), (int)var2_2, Long.MAX_VALUE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ResourceLeakDetector(String resourceType, int samplingInterval, long maxActive) {
        void var2_2;
        void var1_1;
        this.resourceType = (String)ObjectUtil.checkNotNull(var1_1, "resourceType");
        this.samplingInterval = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final ResourceLeak open(T obj) {
        void var1_1;
        return this.track0(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final ResourceLeakTracker<T> track(T obj) {
        void var1_1;
        return this.track0(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public ResourceLeakTracker<T> trackForcibly(T obj) {
        void var1_1;
        return this.track0(var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private DefaultResourceLeak track0(T obj, boolean force) {
        void var3_3;
        void var2_2;
        Level level = ResourceLeakDetector.level;
        if (var2_2 != false || level == Level.PARANOID || var3_3 != Level.DISABLED && PlatformDependent.threadLocalRandom().nextInt(this.samplingInterval) == 0) {
            void var1_1;
            this.reportLeak();
            ResourceLeakDetector resourceLeakDetector = this;
            return new DefaultResourceLeak(var1_1, this.refQueue, this.allLeaks, resourceLeakDetector.getInitialHint(resourceLeakDetector.resourceType));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void clearRefQueue() {
        DefaultResourceLeak ref;
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            void var1_1;
            var1_1.dispose();
        }
    }

    protected boolean needReport() {
        return logger.isErrorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private void reportLeak() {
        DefaultResourceLeak ref;
        if (!this.needReport()) {
            this.clearRefQueue();
            return;
        }
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            void var1_1;
            void var2_2;
            LeakListener listener;
            String records;
            if (!ref.dispose() || !this.reportedLeaks.add(records = ref.getReportAndClearRecords())) continue;
            if (records.isEmpty()) {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportUntracedLeak(resourceLeakDetector.resourceType);
            } else {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportTracedLeak(resourceLeakDetector.resourceType, records);
            }
            if ((listener = this.leakListener) == null) continue;
            var2_2.onLeak(this.resourceType, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void reportTracedLeak(String resourceType, String records) {
        void var2_2;
        void var1_1;
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void reportUntracedLeak(String resourceType) {
        void var1_1;
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", var1_1, PROP_LEVEL, Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    @Deprecated
    protected void reportInstancesLeak(String resourceType) {
    }

    protected Object getInitialHint(String resourceType) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setLeakListener(LeakListener leakListener) {
        void var1_1;
        this.leakListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void addExclusions(Class clz, String ... methodNames) {
        String[] newMethods;
        Method method;
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(methodNames));
        Method[] methodArray = clz.getDeclaredMethods();
        int n = methodArray.length;
        for (int i = 0; !(i >= n || nameSet.remove((method = methodArray[i]).getName()) && nameSet.isEmpty()); ++i) {
        }
        if (!nameSet.isEmpty()) {
            void var2_2;
            throw new IllegalArgumentException("Can't find '" + var2_2 + "' in " + clz.getName());
        }
        do {
            String[] oldMethods = excludedMethods.get();
            newMethods = Arrays.copyOf(oldMethods, oldMethods.length + 2 * methodNames.length);
            for (int i = 0; i < methodNames.length; ++i) {
                newMethods[oldMethods.length + (i << 1)] = clz.getName();
                newMethods[oldMethods.length + (i << 1) + 1] = methodNames[i];
            }
        } while (!excludedMethods.compareAndSet((String[])methodArray, newMethods));
    }

    /*
     * WARNING - void declaration
     */
    static {
        boolean disabled;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("io.netty.noResourceLeakDetection") != null) {
            disabled = SystemPropertyUtil.getBoolean("io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)disabled);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)Level.DISABLED.name().toLowerCase());
        } else {
            disabled = false;
        }
        Level defaultLevel = disabled ? Level.DISABLED : DEFAULT_LEVEL;
        String levelStr = SystemPropertyUtil.get(PROP_LEVEL_OLD, defaultLevel.name());
        levelStr = SystemPropertyUtil.get(PROP_LEVEL, levelStr);
        Level level = Level.parseLevel(levelStr);
        TARGET_RECORDS = SystemPropertyUtil.getInt(PROP_TARGET_RECORDS, 4);
        SAMPLING_INTERVAL = SystemPropertyUtil.getInt(PROP_SAMPLING_INTERVAL, 128);
        ResourceLeakDetector.level = level;
        if (logger.isDebugEnabled()) {
            void var0_1;
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)var0_1.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_TARGET_RECORDS, (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }

    private static class TraceRecord
    extends Throwable {
        private static final long serialVersionUID = 6065153674892850720L;
        private static final TraceRecord BOTTOM = new TraceRecord(){
            private static final long serialVersionUID = 7396077602074694571L;

            @Override
            public final Throwable fillInStackTrace() {
                return this;
            }
        };
        private final String hintString;
        private final TraceRecord next;
        private final int pos;

        /*
         * WARNING - void declaration
         */
        TraceRecord(TraceRecord next, Object hint) {
            void var1_1;
            void var2_2;
            this.hintString = hint instanceof ResourceLeakHint ? ((ResourceLeakHint)hint).toHintString() : var2_2.toString();
            this.next = next;
            this.pos = var1_1.pos + 1;
        }

        /*
         * WARNING - void declaration
         */
        TraceRecord(TraceRecord next) {
            void var1_1;
            this.hintString = null;
            this.next = next;
            this.pos = var1_1.pos + 1;
        }

        private TraceRecord() {
            this.hintString = null;
            this.next = null;
            this.pos = -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder buf = new StringBuilder(2048);
            if (this.hintString != null) {
                buf.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] array = this.getStackTrace();
            block0: for (int i = 3; i < array.length; ++i) {
                StackTraceElement element = array[i];
                String[] exclusions = (String[])excludedMethods.get();
                for (int k = 0; k < exclusions.length; k += 2) {
                    if (exclusions[k].equals(element.getClassName()) && exclusions[k + 1].equals(element.getMethodName())) continue block0;
                }
                buf.append('\t');
                buf.append(element.toString());
                buf.append(StringUtil.NEWLINE);
            }
            return var1_1.toString();
        }
    }

    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeak,
    ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak<?>, TraceRecord> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, TraceRecord.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile TraceRecord head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak<?>> allLeaks;
        private final int trackedHash;

        /*
         * WARNING - void declaration
         */
        DefaultResourceLeak(Object referent, ReferenceQueue<Object> refQueue, Set<DefaultResourceLeak<?>> allLeaks, Object initialHint) {
            super(referent, var2_2);
            void var3_3;
            void var1_1;
            void var2_2;
            assert (referent != null);
            this.trackedHash = System.identityHashCode(var1_1);
            allLeaks.add(this);
            headUpdater.set(this, initialHint == null ? new TraceRecord(TraceRecord.BOTTOM) : new TraceRecord(TraceRecord.BOTTOM, initialHint));
            this.allLeaks = var3_3;
        }

        @Override
        public final void record() {
            this.record0(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void record(Object hint) {
            void var1_1;
            this.record0(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void record0(Object hint) {
            if (TARGET_RECORDS > 0) {
                boolean dropped;
                void var3_3;
                void var2_2;
                do {
                    TraceRecord newHead;
                    TraceRecord oldHead;
                    TraceRecord prevHead = oldHead = headUpdater.get(this);
                    if (oldHead == null) {
                        return;
                    }
                    int numElements = oldHead.pos + 1;
                    if (numElements >= TARGET_RECORDS) {
                        int backOffFactor = Math.min(numElements - TARGET_RECORDS, 30);
                        dropped = PlatformDependent.threadLocalRandom().nextInt(1 << backOffFactor) != 0;
                        if (dropped) {
                            prevHead = oldHead.next;
                        }
                    } else {
                        dropped = false;
                    }
                    TraceRecord traceRecord = newHead = hint != null ? new TraceRecord(prevHead, hint) : new TraceRecord(prevHead);
                } while (!headUpdater.compareAndSet(this, (TraceRecord)var2_2, (TraceRecord)var3_3));
                if (dropped) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        final boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        @Override
        public final boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, null);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean close(T trackedObject) {
            boolean bl;
            assert (this.trackedHash == System.identityHashCode(trackedObject));
            try {
                bl = this.close();
            }
            catch (Throwable throwable) {
                void var1_1;
                DefaultResourceLeak.reachabilityFence0(var1_1);
                throw throwable;
            }
            DefaultResourceLeak.reachabilityFence0(trackedObject);
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static void reachabilityFence0(Object ref) {
            if (ref == null) return;
            // MONITORENTER : var0
            // MONITOREXIT : var0
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            TraceRecord oldHead = headUpdater.get(this);
            return this.generateReport((TraceRecord)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final String getReportAndClearRecords() {
            void var1_1;
            TraceRecord oldHead = headUpdater.getAndSet(this, null);
            return this.generateReport((TraceRecord)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private String generateReport(TraceRecord oldHead) {
            if (oldHead == null) {
                return "";
            }
            int dropped = droppedRecordsUpdater.get(this);
            int duped = 0;
            int present = oldHead.pos + 1;
            StringBuilder buf = new StringBuilder(present << 11).append(StringUtil.NEWLINE);
            buf.append("Recent access records: ").append(StringUtil.NEWLINE);
            int i = 1;
            HashSet<String> seen = new HashSet<String>(present);
            while (oldHead != TraceRecord.BOTTOM) {
                String s = oldHead.toString();
                if (seen.add(s)) {
                    if (oldHead.next == TraceRecord.BOTTOM) {
                        buf.append("Created at:").append(StringUtil.NEWLINE).append(s);
                    } else {
                        buf.append('#').append(i++).append(':').append(StringUtil.NEWLINE).append(s);
                    }
                } else {
                    ++duped;
                }
                oldHead = oldHead.next;
            }
            if (duped > 0) {
                void var3_3;
                buf.append(": ").append((int)var3_3).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
            }
            if (dropped > 0) {
                void var2_2;
                buf.append(": ").append((int)var2_2).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            StringBuilder stringBuilder = buf;
            stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
            return buf.toString();
        }
    }

    public static interface LeakListener {
        public void onLeak(String var1, String var2);
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String levelStr) {
            String trimmedLevelStr = levelStr.trim();
            for (Level l : Level.values()) {
                if (!trimmedLevelStr.equalsIgnoreCase(l.name()) && !trimmedLevelStr.equals(String.valueOf(l.ordinal()))) continue;
                return l;
            }
            return DEFAULT_LEVEL;
        }
    }
}

