/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T msg) {
        T t;
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).retain();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T retain(T msg, int increment) {
        T t;
        ObjectUtil.checkPositive(increment, "increment");
        if (msg instanceof ReferenceCounted) {
            void var1_1;
            return (T)((ReferenceCounted)msg).retain((int)var1_1);
        }
        return t;
    }

    public static <T> T touch(T msg) {
        T t;
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).touch();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T touch(T msg, Object hint) {
        T t;
        if (msg instanceof ReferenceCounted) {
            void var1_1;
            return (T)((ReferenceCounted)msg).touch(var1_1);
        }
        return t;
    }

    public static boolean release(Object msg) {
        if (msg instanceof ReferenceCounted) {
            Object object;
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean release(Object msg, int decrement) {
        ObjectUtil.checkPositive(decrement, "decrement");
        if (msg instanceof ReferenceCounted) {
            void var1_1;
            Object object;
            return ((ReferenceCounted)object).release((int)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void safeRelease(Object msg) {
        try {
            ReferenceCountUtil.release(msg);
            return;
        }
        catch (Throwable t) {
            void var1_1;
            Object object;
            logger.warn("Failed to release a message: {}", object, (Object)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void safeRelease(Object msg, int decrement) {
        try {
            ObjectUtil.checkPositive(decrement, "decrement");
            ReferenceCountUtil.release(msg, decrement);
            return;
        }
        catch (Throwable t) {
            if (logger.isWarnEnabled()) {
                void var2_2;
                void var1_1;
                Object object;
                logger.warn("Failed to release a message: {} (decrement: {})", object, (int)var1_1, var2_2);
            }
            return;
        }
    }

    @Deprecated
    public static <T> T releaseLater(T msg) {
        return ReferenceCountUtil.releaseLater(msg, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T releaseLater(T msg, int decrement) {
        T t;
        ObjectUtil.checkPositive(decrement, "decrement");
        if (msg instanceof ReferenceCounted) {
            void var1_1;
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReleasingTask((ReferenceCounted)msg, (int)var1_1));
        }
        return t;
    }

    public static int refCnt(Object msg) {
        if (msg instanceof ReferenceCounted) {
            Object object;
            return ((ReferenceCounted)object).refCnt();
        }
        return -1;
    }

    private ReferenceCountUtil() {
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }

    private static final class ReleasingTask
    implements Runnable {
        private final ReferenceCounted obj;
        private final int decrement;

        /*
         * WARNING - void declaration
         */
        ReleasingTask(ReferenceCounted obj, int decrement) {
            void var2_2;
            void var1_1;
            this.obj = var1_1;
            this.decrement = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                if (this.obj.release(this.decrement)) {
                    logger.debug("Released: {}", (Object)this);
                    return;
                }
                logger.warn("Non-zero refCnt: {}", (Object)this);
            }
            catch (Exception ex) {
                void var1_1;
                logger.warn("Failed to release an object: {}", (Object)this.obj, (Object)var1_1);
            }
        }

        public final String toString() {
            return StringUtil.simpleClassName(this.obj) + ".release(" + this.decrement + ") refCnt: " + this.obj.refCnt();
        }
    }
}

