/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class Recycler<T> {
    private static final InternalLogger logger;
    private static final EnhancedHandle<?> NOOP_HANDLE;
    private static final int DEFAULT_INITIAL_MAX_CAPACITY_PER_THREAD = 4096;
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int RATIO;
    private static final int DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD;
    private static final boolean BLOCKING_POOL;
    private static final boolean BATCH_FAST_TL_ONLY;
    private final int maxCapacityPerThread;
    private final int interval;
    private final int chunkSize;
    private final FastThreadLocal<LocalPool<T>> threadLocal = new FastThreadLocal<LocalPool<T>>(this){
        final /* synthetic */ Recycler this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        protected LocalPool<T> initialValue() {
            return new LocalPool(this.this$0.maxCapacityPerThread, this.this$0.interval, this.this$0.chunkSize);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void onRemoval(LocalPool<T> value) throws Exception {
            void var2_2;
            void var1_1;
            super.onRemoval(value);
            MessagePassingQueue handles = value.pooledHandles;
            LocalPool.access$402(value, null);
            LocalPool.access$502((LocalPool)var1_1, null);
            var2_2.clear();
        }
    };

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    /*
     * WARNING - void declaration
     */
    protected Recycler(int maxCapacityPerThread) {
        this((int)var1_1, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected Recycler(int maxCapacityPerThread, int maxSharedCapacityFactor) {
        this((int)var1_1, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected Recycler(int maxCapacityPerThread, int maxSharedCapacityFactor, int ratio, int maxDelayedQueuesPerThread) {
        this((int)var1_1, (int)var3_3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected Recycler(int maxCapacityPerThread, int maxSharedCapacityFactor, int ratio, int maxDelayedQueuesPerThread, int delayedQueueRatio) {
        this((int)var1_1, (int)var3_3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Recycler(int maxCapacityPerThread, int ratio, int chunkSize) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.interval = Math.max(0, (int)var2_2);
        if (maxCapacityPerThread <= 0) {
            this.maxCapacityPerThread = 0;
            this.chunkSize = 0;
            return;
        }
        this.maxCapacityPerThread = Math.max(4, (int)var1_1);
        this.chunkSize = Math.max(2, Math.min((int)var3_3, this.maxCapacityPerThread >> 1));
    }

    /*
     * WARNING - void declaration
     */
    public final T get() {
        void var1_1;
        Object obj;
        if (this.maxCapacityPerThread == 0) {
            return (T)this.newObject(NOOP_HANDLE);
        }
        LocalPool<T> localPool = this.threadLocal.get();
        DefaultHandle handle = localPool.claim();
        if (handle == null) {
            handle = localPool.newHandle();
            if (handle != null) {
                obj = this.newObject(handle);
                handle.set(obj);
            } else {
                obj = this.newObject(NOOP_HANDLE);
            }
        } else {
            void var2_2;
            obj = var2_2.get();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final boolean recycle(T o, Handle<T> handle) {
        void var1_1;
        void var2_2;
        if (handle == NOOP_HANDLE) {
            return false;
        }
        var2_2.recycle(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final int threadLocalSize() {
        void var1_1;
        LocalPool<T> localPool = this.threadLocal.getIfExists();
        if (localPool == null) {
            return 0;
        }
        return ((LocalPool)localPool).pooledHandles.size() + ((LocalPool)var1_1).batch.size();
    }

    protected abstract T newObject(Handle<T> var1);

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(Recycler.class);
        NOOP_HANDLE = new EnhancedHandle<Object>(){

            @Override
            public final void recycle(Object object) {
            }

            @Override
            public final void unguardedRecycle(Object object) {
            }

            public final String toString() {
                return "NOOP_HANDLE";
            }
        };
        int maxCapacityPerThread = SystemPropertyUtil.getInt("io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("io.netty.recycler.maxCapacity", 4096));
        if (maxCapacityPerThread < 0) {
            maxCapacityPerThread = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = var0;
        DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD = SystemPropertyUtil.getInt("io.netty.recycler.chunkSize", 32);
        RATIO = Math.max(0, SystemPropertyUtil.getInt("io.netty.recycler.ratio", 8));
        BLOCKING_POOL = SystemPropertyUtil.getBoolean("io.netty.recycler.blocking", false);
        BATCH_FAST_TL_ONLY = SystemPropertyUtil.getBoolean("io.netty.recycler.batchFastThreadLocalOnly", true);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.chunkSize: disabled");
                logger.debug("-Dio.netty.recycler.blocking: disabled");
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.chunkSize: {}", (Object)DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
                logger.debug("-Dio.netty.recycler.blocking: {}", (Object)BLOCKING_POOL);
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: {}", (Object)BATCH_FAST_TL_ONLY);
            }
        }
    }

    private static final class BlockingMessageQueue<T>
    implements MessagePassingQueue<T> {
        private final Queue<T> deque;
        private final int maxCapacity;

        /*
         * WARNING - void declaration
         */
        BlockingMessageQueue(int maxCapacity) {
            void var1_1;
            this.maxCapacity = var1_1;
            this.deque = new ArrayDeque<T>();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized boolean offer(T e) {
            void var1_1;
            if (this.deque.size() == this.maxCapacity) {
                return false;
            }
            return this.deque.offer(var1_1);
        }

        @Override
        public final synchronized T poll() {
            return this.deque.poll();
        }

        @Override
        public final synchronized T peek() {
            return this.deque.peek();
        }

        @Override
        public final synchronized int size() {
            return this.deque.size();
        }

        @Override
        public final synchronized void clear() {
            this.deque.clear();
        }

        @Override
        public final synchronized boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public final int capacity() {
            return this.maxCapacity;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean relaxedOffer(T e) {
            void var1_1;
            return this.offer(var1_1);
        }

        @Override
        public final T relaxedPoll() {
            return this.poll();
        }

        @Override
        public final T relaxedPeek() {
            return this.peek();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int drain(MessagePassingQueue.Consumer<T> c, int limit) {
            T obj;
            int i;
            for (i = 0; i < limit && (obj = this.poll()) != null; ++i) {
                void var3_4;
                c.accept(var3_4);
            }
            return i;
        }

        @Override
        public final int fill(MessagePassingQueue.Supplier<T> s, int limit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int drain(MessagePassingQueue.Consumer<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int fill(MessagePassingQueue.Supplier<T> s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void drain(MessagePassingQueue.Consumer<T> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void fill(MessagePassingQueue.Supplier<T> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LocalPool<T>
    implements MessagePassingQueue.Consumer<DefaultHandle<T>> {
        private final int ratioInterval;
        private final int chunkSize;
        private final ArrayDeque<DefaultHandle<T>> batch;
        private volatile Thread owner;
        private volatile MessagePassingQueue<DefaultHandle<T>> pooledHandles;
        private int ratioCounter;

        /*
         * WARNING - void declaration
         */
        LocalPool(int maxCapacity, int ratioInterval, int chunkSize) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.ratioInterval = ratioInterval;
            this.chunkSize = chunkSize;
            this.batch = new ArrayDeque(chunkSize);
            Thread currentThread = Thread.currentThread();
            this.owner = !BATCH_FAST_TL_ONLY || currentThread instanceof FastThreadLocalThread ? currentThread : null;
            this.pooledHandles = BLOCKING_POOL ? new BlockingMessageQueue<DefaultHandle<T>>(maxCapacity) : (MessagePassingQueue)((Object)PlatformDependent.newMpscQueue((int)var3_3, (int)var1_1));
            this.ratioCounter = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final DefaultHandle<T> claim() {
            void var1_1;
            DefaultHandle<T> handle;
            MessagePassingQueue<DefaultHandle<T>> handles = this.pooledHandles;
            if (handles == null) {
                return null;
            }
            if (this.batch.isEmpty()) {
                LocalPool localPool = this;
                handles.drain(localPool, localPool.chunkSize);
            }
            if ((handle = this.batch.pollLast()) != null) {
                handle.toClaimed();
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void release(DefaultHandle<T> handle, boolean guarded) {
            if (guarded) {
                handle.toAvailable();
            } else {
                handle.unguardedToAvailable();
            }
            Thread owner = this.owner;
            if (owner != null && Thread.currentThread() == owner && this.batch.size() < this.chunkSize) {
                this.accept(handle);
                return;
            }
            if (owner != null && LocalPool.isTerminated(owner)) {
                this.owner = null;
                this.pooledHandles = null;
                return;
            }
            MessagePassingQueue<DefaultHandle<T>> handles = this.pooledHandles;
            if (handles != null) {
                void var1_1;
                void var2_3;
                var2_3.relaxedOffer(var1_1);
            }
        }

        private static boolean isTerminated(Thread owner) {
            Thread thread;
            if (PlatformDependent.isJ9Jvm()) {
                return !owner.isAlive();
            }
            return thread.getState() == Thread.State.TERMINATED;
        }

        final DefaultHandle<T> newHandle() {
            if (++this.ratioCounter >= this.ratioInterval) {
                this.ratioCounter = 0;
                return new DefaultHandle(this);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void accept(DefaultHandle<T> e) {
            void var1_1;
            this.batch.addLast((DefaultHandle<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ MessagePassingQueue access$402(LocalPool x0, MessagePassingQueue x1) {
            void var1_1;
            x0.pooledHandles = var1_1;
            return x0.pooledHandles;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Thread access$502(LocalPool x0, Thread x1) {
            void var1_1;
            x0.owner = var1_1;
            return x0.owner;
        }
    }

    private static final class DefaultHandle<T>
    extends EnhancedHandle<T> {
        private static final int STATE_CLAIMED = 0;
        private static final int STATE_AVAILABLE = 1;
        private static final AtomicIntegerFieldUpdater<DefaultHandle<?>> STATE_UPDATER;
        private volatile int state;
        private final LocalPool<T> localPool;
        private T value;

        /*
         * WARNING - void declaration
         */
        DefaultHandle(LocalPool<T> localPool) {
            void var1_1;
            this.localPool = var1_1;
        }

        @Override
        public final void recycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, true);
        }

        @Override
        public final void unguardedRecycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, false);
        }

        final T get() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        final void set(T value) {
            void var1_1;
            this.value = var1_1;
        }

        final void toClaimed() {
            assert (this.state == 1);
            STATE_UPDATER.lazySet(this, 0);
        }

        final void toAvailable() {
            int n = STATE_UPDATER.getAndSet(this, 1);
            if (n == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
        }

        final void unguardedToAvailable() {
            int n = this.state;
            if (n == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
            STATE_UPDATER.lazySet(this, 1);
        }

        static {
            AtomicIntegerFieldUpdater<DefaultHandle> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultHandle.class, "state");
            STATE_UPDATER = atomicIntegerFieldUpdater;
        }
    }

    public static abstract class EnhancedHandle<T>
    implements Handle<T> {
        public abstract void unguardedRecycle(Object var1);

        private EnhancedHandle() {
        }
    }

    public static interface Handle<T>
    extends ObjectPool.Handle<T> {
    }
}

