/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.SuppressForbidden;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;

public final class NettyRuntime {
    private static final AvailableProcessorsHolder holder = new AvailableProcessorsHolder();

    public static void setAvailableProcessors(int availableProcessors) {
        int n;
        holder.setAvailableProcessors(n);
    }

    public static int availableProcessors() {
        return holder.availableProcessors();
    }

    private NettyRuntime() {
    }

    static class AvailableProcessorsHolder {
        private int availableProcessors;

        AvailableProcessorsHolder() {
        }

        /*
         * WARNING - void declaration
         */
        synchronized void setAvailableProcessors(int availableProcessors) {
            void var1_1;
            ObjectUtil.checkPositive(availableProcessors, "availableProcessors");
            if (this.availableProcessors != 0) {
                void var1_2;
                String message = String.format(Locale.ROOT, "availableProcessors is already set to [%d], rejecting [%d]", this.availableProcessors, availableProcessors);
                throw new IllegalStateException((String)var1_2);
            }
            this.availableProcessors = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressForbidden(reason="to obtain default number of available processors")
        synchronized int availableProcessors() {
            if (this.availableProcessors == 0) {
                void var1_1;
                int availableProcessors = SystemPropertyUtil.getInt("io.netty.availableProcessors", Runtime.getRuntime().availableProcessors());
                this.setAvailableProcessors((int)var1_1);
            }
            return this.availableProcessors;
        }
    }
}

