/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

final class NetUtilInitializations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NetUtilInitializations.class);

    private NetUtilInitializations() {
    }

    /*
     * WARNING - void declaration
     */
    static Inet4Address createLocalhost4() {
        void var1_1;
        Exception exception;
        byte[] LOCALHOST4_BYTES = new byte[]{127, 0, 0, 1};
        Inet4Address localhost4 = null;
        try {
            localhost4 = (Inet4Address)InetAddress.getByAddress("localhost", (byte[])exception);
        }
        catch (Exception exception2) {
            exception = exception2;
            PlatformDependent.throwException(exception2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static Inet6Address createLocalhost6() {
        void var1_1;
        Exception exception;
        byte[] LOCALHOST6_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet6Address localhost6 = null;
        try {
            localhost6 = (Inet6Address)InetAddress.getByAddress("localhost", (byte[])exception);
        }
        catch (Exception exception2) {
            exception = exception2;
            PlatformDependent.throwException(exception2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static Collection<NetworkInterface> networkInterfaces() {
        void var0;
        block5: {
            ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    while (interfaces.hasMoreElements()) {
                        networkInterfaces.add(interfaces.nextElement());
                    }
                }
            }
            catch (SocketException e) {
                logger.warn("Failed to retrieve the list of available network interfaces", e);
            }
            catch (NullPointerException e) {
                void var1_3;
                if (PlatformDependent.isAndroid()) break block5;
                throw var1_3;
            }
        }
        return Collections.unmodifiableList(var0);
    }

    /*
     * WARNING - void declaration
     */
    static NetworkIfaceAndInetAddress determineLoopback(Collection<NetworkInterface> networkInterfaces, Inet4Address localhost4, Inet6Address localhost6) {
        Object object;
        Enumeration<InetAddress> i;
        ArrayList<NetworkInterface> ifaces = new ArrayList<NetworkInterface>();
        networkInterfaces = networkInterfaces.iterator();
        while (networkInterfaces.hasNext()) {
            NetworkInterface iface = (NetworkInterface)networkInterfaces.next();
            if (!SocketUtils.addressesFromNetworkInterface(iface).hasMoreElements()) continue;
            ifaces.add(iface);
        }
        Object loopbackIface2 = null;
        InetAddress loopbackAddr = null;
        block6: for (NetworkInterface iface : ifaces) {
            i = SocketUtils.addressesFromNetworkInterface(iface);
            while (i.hasMoreElements()) {
                InetAddress addr = i.nextElement();
                if (!addr.isLoopbackAddress()) continue;
                loopbackIface2 = iface;
                loopbackAddr = addr;
                break block6;
            }
        }
        if (loopbackIface2 == null) {
            try {
                void var3_4;
                for (NetworkInterface iface : var3_4) {
                    if (!iface.isLoopback() || !(i = SocketUtils.addressesFromNetworkInterface(iface)).hasMoreElements()) continue;
                    loopbackIface2 = iface;
                    loopbackAddr = i.nextElement();
                    break;
                }
                if (loopbackIface2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException e) {
                logger.warn("Failed to find the loopback interface", e);
            }
        }
        if (loopbackIface2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)loopbackIface2).getName(), ((NetworkInterface)loopbackIface2).getDisplayName(), loopbackAddr.getHostAddress());
        } else if (loopbackAddr == null) {
            try {
                if (NetworkInterface.getByInetAddress(localhost6) != null) {
                    void var2_3;
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)localhost6);
                    loopbackAddr = var2_3;
                }
                if (loopbackAddr == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)localhost4);
                    loopbackAddr = localhost4;
                }
            }
            catch (Exception exception) {
                if (loopbackAddr == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)localhost4);
                    loopbackAddr = localhost4;
                }
            }
            catch (Throwable loopbackIface2) {
                if (loopbackAddr == null) {
                    void var1_2;
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)var1_2);
                }
                throw loopbackIface2;
            }
        }
        return new NetworkIfaceAndInetAddress((NetworkInterface)object, loopbackAddr);
    }

    static final class NetworkIfaceAndInetAddress {
        private final NetworkInterface iface;
        private final InetAddress address;

        /*
         * WARNING - void declaration
         */
        NetworkIfaceAndInetAddress(NetworkInterface iface, InetAddress address) {
            void var2_2;
            void var1_1;
            this.iface = var1_1;
            this.address = var2_2;
        }

        public final NetworkInterface iface() {
            return this.iface;
        }

        public final InetAddress address() {
            return this.address;
        }
    }
}

