/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;

public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final AtomicBoolean WARNED_TOO_MANY_INSTANCES = new AtomicBoolean();
    private static final int INSTANCE_COUNT_LIMIT = 64;
    private static final long MILLISECOND_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
    private final ResourceLeakTracker<HashedWheelTimer> leak;
    private final Worker worker = new Worker();
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState;
    private final long tickDuration;
    private final HashedWheelBucket[] wheel;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    private final Queue<HashedWheelTimeout> timeouts = PlatformDependent.newMpscQueue();
    private final Queue<HashedWheelTimeout> cancelledTimeouts = PlatformDependent.newMpscQueue();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private final long maxPendingTimeouts;
    private final Executor taskExecutor;
    private volatile long startTime;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(long tickDuration, TimeUnit unit) {
        this(Executors.defaultThreadFactory(), (long)var1_1, (TimeUnit)var3_2);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(Executors.defaultThreadFactory(), (long)var1_1, (TimeUnit)var3_2, ticksPerWheel);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory) {
        this((ThreadFactory)var1_1, 100L, TimeUnit.MILLISECONDS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit) {
        this((ThreadFactory)var1_1, (long)var2_2, unit, 512);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this((ThreadFactory)var1_1, (long)var2_2, unit, ticksPerWheel, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection) {
        this((ThreadFactory)var1_1, (long)var2_2, unit, ticksPerWheel, leakDetection, -1L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts) {
        this((ThreadFactory)var1_1, (long)var2_2, unit, ticksPerWheel, leakDetection, maxPendingTimeouts, ImmediateExecutor.INSTANCE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts, Executor taskExecutor) {
        void var1_1;
        ObjectUtil.checkNotNull(threadFactory, "threadFactory");
        ObjectUtil.checkNotNull(unit, "unit");
        ObjectUtil.checkPositive(tickDuration, "tickDuration");
        ObjectUtil.checkPositive(ticksPerWheel, "ticksPerWheel");
        this.taskExecutor = ObjectUtil.checkNotNull(taskExecutor, "taskExecutor");
        this.wheel = HashedWheelTimer.createWheel(ticksPerWheel);
        this.mask = this.wheel.length - 1;
        long duration = unit.toNanos(tickDuration);
        if (duration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", tickDuration, Long.MAX_VALUE / (long)this.wheel.length));
        }
        if (duration < MILLISECOND_NANOS) {
            void var2_2;
            logger.warn("Configured tickDuration {} smaller than {}, using 1ms.", (Object)((long)var2_2), (Object)MILLISECOND_NANOS);
            this.tickDuration = MILLISECOND_NANOS;
        } else {
            this.tickDuration = duration;
        }
        this.workerThread = var1_1.newThread(this.worker);
        this.leak = leakDetection || !this.workerThread.isDaemon() ? leakDetector.track(this) : null;
        this.maxPendingTimeouts = maxPendingTimeouts;
        if (INSTANCE_COUNTER.incrementAndGet() > 64 && WARNED_TOO_MANY_INSTANCES.compareAndSet(false, true)) {
            HashedWheelTimer.reportTooManyInstances();
        }
    }

    protected void finalize() throws Throwable {
        block3: {
            try {
                super.finalize();
                if (WORKER_STATE_UPDATER.getAndSet(this, 2) == 2) break block3;
                INSTANCE_COUNTER.decrementAndGet();
            }
            catch (Throwable throwable) {
                if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                    INSTANCE_COUNTER.decrementAndGet();
                }
                throw throwable;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static HashedWheelBucket[] createWheel(int ticksPerWheel) {
        void var0_1;
        ticksPerWheel = MathUtil.findNextPositivePowerOfTwo(ticksPerWheel);
        HashedWheelBucket[] wheel = new HashedWheelBucket[ticksPerWheel];
        for (int i = 0; i < wheel.length; ++i) {
            wheel[i] = new HashedWheelBucket();
        }
        return var0_1;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (!WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Timeout> stop() {
        void var2_7;
        Iterator iterator;
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            if (WORKER_STATE_UPDATER.getAndSet(this, 2) != 2) {
                INSTANCE_COUNTER.decrementAndGet();
                if (this.leak != null) {
                    boolean closed = this.leak.close(this);
                    assert (closed);
                }
            }
            return Collections.emptySet();
        }
        try {
            boolean interrupted = false;
            while (this.workerThread.isAlive()) {
                this.workerThread.interrupt();
                try {
                    this.workerThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            INSTANCE_COUNTER.decrementAndGet();
            if (this.leak != null) {
                boolean closed = this.leak.close(this);
                assert (closed);
            }
        }
        Set<Timeout> unprocessed = this.worker.unprocessedTimeouts();
        HashSet<void> cancelled = new HashSet<void>(unprocessed.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_6;
            Timeout timeout = (Timeout)iterator.next();
            if (!timeout.cancel()) continue;
            cancelled.add(var3_6);
        }
        return var2_7;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull(task, "task");
        ObjectUtil.checkNotNull(unit, "unit");
        long pendingTimeoutsCount = this.pendingTimeouts.incrementAndGet();
        if (this.maxPendingTimeouts > 0L && pendingTimeoutsCount > this.maxPendingTimeouts) {
            this.pendingTimeouts.decrementAndGet();
            throw new RejectedExecutionException("Number of pending timeouts (" + pendingTimeoutsCount + ") is greater than or equal to maximum allowed pending timeouts (" + this.maxPendingTimeouts + ")");
        }
        this.start();
        long deadline = System.nanoTime() + unit.toNanos(delay) - this.startTime;
        if (var2_2 > 0L && deadline < 0L) {
            deadline = Long.MAX_VALUE;
        }
        HashedWheelTimeout timeout = new HashedWheelTimeout(this, task, deadline);
        this.timeouts.add(timeout);
        return var1_1;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    /*
     * WARNING - void declaration
     */
    private static void reportTooManyInstances() {
        if (logger.isErrorEnabled()) {
            void var0;
            String resourceType = StringUtil.simpleClassName(HashedWheelTimer.class);
            logger.error("You are creating too many " + resourceType + " instances. " + (String)var0 + " is a shared resource that must be reused across the JVM, so that only a few instances are created.");
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$202(HashedWheelTimer x0, long x1) {
        void var1_1;
        x0.startTime = var1_1;
        return x0.startTime;
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimeout head;
        private HashedWheelTimeout tail;

        private HashedWheelBucket() {
        }

        /*
         * WARNING - void declaration
         */
        public final void addTimeout(HashedWheelTimeout timeout) {
            void var1_1;
            assert (timeout.bucket == null);
            timeout.bucket = this;
            if (this.head == null) {
                HashedWheelBucket hashedWheelBucket = this;
                hashedWheelBucket.head = hashedWheelBucket.tail = timeout;
                return;
            }
            this.tail.next = timeout;
            timeout.prev = this.tail;
            this.tail = var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void expireTimeouts(long deadline) {
            HashedWheelTimeout timeout = this.head;
            while (timeout != null) {
                HashedWheelTimeout next = timeout.next;
                if (timeout.remainingRounds <= 0L) {
                    next = this.remove(timeout);
                    if (timeout.deadline > deadline) throw new IllegalStateException(String.format("timeout.deadline (%d) > deadline (%d)", timeout.deadline, deadline));
                    timeout.expire();
                } else if (timeout.isCancelled()) {
                    next = this.remove(timeout);
                } else {
                    --timeout.remainingRounds;
                }
                timeout = next;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final HashedWheelTimeout remove(HashedWheelTimeout timeout) {
            void var2_2;
            void var1_1;
            HashedWheelTimeout next = timeout.next;
            if (timeout.prev != null) {
                timeout.prev.next = next;
            }
            if (timeout.next != null) {
                timeout.next.prev = timeout.prev;
            }
            if (timeout == this.head) {
                if (timeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next;
                }
            } else if (timeout == this.tail) {
                this.tail = timeout.prev;
            }
            timeout.prev = null;
            timeout.next = null;
            timeout.bucket = null;
            ((HashedWheelTimeout)var1_1).timer.pendingTimeouts.decrementAndGet();
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void clearTimeouts(Set<Timeout> set) {
            HashedWheelTimeout timeout;
            while ((timeout = this.pollTimeout()) != null) {
                void var2_2;
                if (timeout.isExpired() || timeout.isCancelled()) continue;
                set.add((Timeout)var2_2);
            }
            return;
        }

        /*
         * WARNING - void declaration
         */
        private HashedWheelTimeout pollTimeout() {
            void var1_1;
            HashedWheelTimeout head = this.head;
            if (head == null) {
                return null;
            }
            HashedWheelTimeout next = head.next;
            if (next == null) {
                HashedWheelBucket hashedWheelBucket = this;
                hashedWheelBucket.head = null;
                hashedWheelBucket.tail = null;
            } else {
                this.head = next;
                var2_2.prev = null;
            }
            head.next = null;
            head.prev = null;
            head.bucket = null;
            return var1_1;
        }
    }

    private static final class HashedWheelTimeout
    implements Timeout,
    Runnable {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private static final AtomicIntegerFieldUpdater<HashedWheelTimeout> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimeout.class, "state");
        private final HashedWheelTimer timer;
        private final TimerTask task;
        private final long deadline;
        private volatile int state = 0;
        long remainingRounds;
        HashedWheelTimeout next;
        HashedWheelTimeout prev;
        HashedWheelBucket bucket;

        /*
         * WARNING - void declaration
         */
        HashedWheelTimeout(HashedWheelTimer timer, TimerTask task, long deadline) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.timer = var1_1;
            this.task = var2_2;
            this.deadline = var3_3;
        }

        @Override
        public final Timer timer() {
            return this.timer;
        }

        @Override
        public final TimerTask task() {
            return this.task;
        }

        @Override
        public final boolean cancel() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            this.timer.cancelledTimeouts.add(this);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final void remove() {
            HashedWheelBucket bucket = this.bucket;
            if (bucket != null) {
                void var1_1;
                var1_1.remove(this);
                return;
            }
            this.timer.pendingTimeouts.decrementAndGet();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean compareAndSetState(int expected, int state) {
            void var2_2;
            void var1_1;
            return STATE_UPDATER.compareAndSet(this, (int)var1_1, (int)var2_2);
        }

        public final int state() {
            return this.state;
        }

        @Override
        public final boolean isCancelled() {
            return this.state() == 1;
        }

        @Override
        public final boolean isExpired() {
            return this.state() == 2;
        }

        /*
         * WARNING - void declaration
         */
        public final void expire() {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.timer.taskExecutor.execute(this);
                return;
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    void var1_1;
                    logger.warn("An exception was thrown while submit " + TimerTask.class.getSimpleName() + " for execution.", (Throwable)var1_1);
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                this.task.run(this);
                return;
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    void var1_1;
                    logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', (Throwable)var1_1);
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_2;
            long currentTime = System.nanoTime();
            long remaining = this.deadline - currentTime + this.timer.startTime;
            StringBuilder buf = new StringBuilder(192).append(StringUtil.simpleClassName(this)).append('(').append("deadline: ");
            if (remaining > 0L) {
                buf.append(remaining).append(" ns later");
            } else if (remaining < 0L) {
                void var3_3;
                buf.append((long)(-var3_3)).append(" ns ago");
            } else {
                buf.append("now");
            }
            if (this.isCancelled()) {
                buf.append(", cancelled");
            }
            return var1_2.append(", task: ").append(this.task()).append(')').toString();
        }
    }

    private final class Worker
    implements Runnable {
        private final Set<Timeout> unprocessedTimeouts = new HashSet<Timeout>();
        private long tick;

        private Worker() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            HashedWheelTimeout timeout;
            HashedWheelTimer.access$202(HashedWheelTimer.this, System.nanoTime());
            if (HashedWheelTimer.this.startTime == 0L) {
                HashedWheelTimer.access$202(HashedWheelTimer.this, 1L);
            }
            HashedWheelTimer.this.startTimeInitialized.countDown();
            do {
                int n;
                long deadline;
                if ((deadline = this.waitForNextTick()) <= 0L) continue;
                int idx = (int)(this.tick & (long)HashedWheelTimer.this.mask);
                this.processCancelledTasks();
                HashedWheelBucket bucket = HashedWheelTimer.this.wheel[n];
                this.transferTimeoutsToBuckets();
                bucket.expireTimeouts(deadline);
                ++this.tick;
            } while (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 1);
            for (HashedWheelBucket hashedWheelBucket : HashedWheelTimer.this.wheel) {
                hashedWheelBucket.clearTimeouts(this.unprocessedTimeouts);
            }
            while ((timeout = (HashedWheelTimeout)HashedWheelTimer.this.timeouts.poll()) != null) {
                void var1_2;
                if (timeout.isCancelled()) continue;
                this.unprocessedTimeouts.add((Timeout)var1_2);
            }
            this.processCancelledTasks();
        }

        /*
         * WARNING - void declaration
         */
        private void transferTimeoutsToBuckets() {
            HashedWheelTimeout timeout;
            for (int i = 0; i < 100000 && (timeout = (HashedWheelTimeout)HashedWheelTimer.this.timeouts.poll()) != null; ++i) {
                void var2_2;
                void var3_5;
                if (timeout.state() == 1) continue;
                long calculated = timeout.deadline / HashedWheelTimer.this.tickDuration;
                timeout.remainingRounds = (calculated - this.tick) / (long)HashedWheelTimer.this.wheel.length;
                long l = Math.max(calculated, this.tick);
                int stopIndex = (int)(l & (long)HashedWheelTimer.this.mask);
                HashedWheelBucket hashedWheelBucket = HashedWheelTimer.this.wheel[var3_5];
                hashedWheelBucket.addTimeout((HashedWheelTimeout)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processCancelledTasks() {
            HashedWheelTimeout timeout;
            while ((timeout = (HashedWheelTimeout)HashedWheelTimer.this.cancelledTimeouts.poll()) != null) {
                try {
                    timeout.remove();
                }
                catch (Throwable t) {
                    void var1_2;
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("An exception was thrown while process a cancellation task", (Throwable)var1_2);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long deadline = HashedWheelTimer.this.tickDuration * (this.tick + 1L);
            while (true) {
                long currentTime;
                long sleepTimeMs;
                if ((sleepTimeMs = (deadline - (currentTime = System.nanoTime() - HashedWheelTimer.this.startTime) + 999999L) / 1000000L) <= 0L) {
                    if (currentTime != Long.MIN_VALUE) void var3_2;
                    return (long)var3_2;
                    return -9223372036854775807L;
                }
                if (PlatformDependent.isWindows() && (sleepTimeMs = sleepTimeMs / 10L * 10L) == 0L) {
                    sleepTimeMs = 1L;
                }
                try {
                    Thread.sleep(sleepTimeMs);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (WORKER_STATE_UPDATER.get(HashedWheelTimer.this) == 2) return Long.MIN_VALUE;
                    continue;
                }
                break;
            }
        }

        public final Set<Timeout> unprocessedTimeouts() {
            return Collections.unmodifiableSet(this.unprocessedTimeouts);
        }
    }
}

