/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.internal.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DomainWildcardMappingBuilder<V> {
    private final V defaultValue;
    private final Map<String, V> map;

    /*
     * WARNING - void declaration
     */
    public DomainWildcardMappingBuilder(V defaultValue) {
        this(4, var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DomainWildcardMappingBuilder(int initialCapacity, V defaultValue) {
        void var1_1;
        void var2_2;
        this.defaultValue = ObjectUtil.checkNotNull(var2_2, "defaultValue");
        this.map = new LinkedHashMap<String, V>((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DomainWildcardMappingBuilder<V> add(String hostname, V output) {
        void var2_2;
        void var1_1;
        this.map.put(this.normalizeHostName((String)var1_1), ObjectUtil.checkNotNull(var2_2, "output"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String normalizeHostName(String hostname) {
        void var1_1;
        ObjectUtil.checkNotNull(hostname, "hostname");
        if (hostname.isEmpty() || hostname.charAt(0) == '.') {
            throw new IllegalArgumentException("Hostname '" + hostname + "' not valid");
        }
        if ((hostname = ImmutableDomainWildcardMapping.normalize(ObjectUtil.checkNotNull(hostname, "hostname"))).charAt(0) == '*') {
            if (hostname.length() < 3 || hostname.charAt(1) != '.') {
                throw new IllegalArgumentException("Wildcard Hostname '" + hostname + "'not valid");
            }
            return hostname.substring(1);
        }
        return var1_1;
    }

    public Mapping<String, V> build() {
        return new ImmutableDomainWildcardMapping<V>(this.defaultValue, this.map);
    }

    private static final class ImmutableDomainWildcardMapping<V>
    implements Mapping<String, V> {
        private static final String REPR_HEADER = "ImmutableDomainWildcardMapping(default: ";
        private static final String REPR_MAP_OPENING = ", map: ";
        private static final String REPR_MAP_CLOSING = ")";
        private final V defaultValue;
        private final Map<String, V> map;

        /*
         * WARNING - void declaration
         */
        ImmutableDomainWildcardMapping(V defaultValue, Map<String, V> map) {
            void var2_2;
            void var1_1;
            this.defaultValue = var1_1;
            this.map = new LinkedHashMap<String, V>(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V map(String hostname) {
            if (hostname != null) {
                void var2_3;
                void var1_1;
                V v;
                V value = this.map.get(hostname = ImmutableDomainWildcardMapping.normalize(hostname));
                if (value != null) {
                    return value;
                }
                int idx = hostname.indexOf(46);
                if (idx != -1 && (v = this.map.get(var1_1.substring((int)var2_3))) != null) {
                    return v;
                }
            }
            return this.defaultValue;
        }

        static String normalize(String hostname) {
            return DomainNameMapping.normalizeHostname(hostname);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append(REPR_HEADER).append(this.defaultValue).append(", map: {");
            for (Map.Entry<String, V> entry : this.map.entrySet()) {
                void var3_3;
                String hostname = entry.getKey();
                if (hostname.charAt(0) == '.') {
                    hostname = "*" + hostname;
                }
                sb.append(hostname).append('=').append(var3_3.getValue()).append(", ");
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setLength(stringBuilder.length() - 2);
            return var1_1.append('}').append(REPR_MAP_CLOSING).toString();
        }
    }
}

