/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    /*
     * WARNING - void declaration
     */
    private static int searchAttributeByKey(DefaultAttribute[] sortedAttributes, AttributeKey<?> key) {
        void var2_2;
        int low = 0;
        int high = sortedAttributes.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DefaultAttribute defaultAttribute = sortedAttributes[mid];
            AttributeKey midValKey = defaultAttribute.key;
            if (midValKey == key) {
                return mid;
            }
            int midValKeyId = midValKey.id();
            int keyId = key.id();
            assert (midValKeyId != keyId);
            boolean bl = midValKeyId < keyId;
            if (bl) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return (int)(-(var2_2 + true));
    }

    /*
     * WARNING - void declaration
     */
    private static void orderedCopyOnInsert(DefaultAttribute[] sortedSrc, int srcLength, DefaultAttribute[] copy, DefaultAttribute toInsert) {
        void var1_1;
        void var3_3;
        int id = toInsert.key.id();
        for (int i = srcLength - 1; i >= 0; --i) {
            DefaultAttribute attribute = sortedSrc[i];
            assert (attribute.key.id() != id);
            if (attribute.key.id() < id) break;
            copy[i + 1] = sortedSrc[i];
        }
        copy[i + 1] = var3_3;
        void toCopy = var1_1 + true;
        if (toCopy > 0) {
            void var2_2;
            DefaultAttribute[] defaultAttributeArray;
            System.arraycopy(defaultAttributeArray, 0, var2_2, 0, (int)toCopy);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        DefaultAttribute[] newAttributes;
        void var3_3;
        ObjectUtil.checkNotNull(key, "key");
        DefaultAttribute<T> newAttribute = null;
        do {
            DefaultAttribute[] attributes = this.attributes;
            int index = DefaultAttributeMap.searchAttributeByKey(this.attributes, key);
            if (index >= 0) {
                DefaultAttribute attribute = attributes[index];
                assert (attribute.key() == key);
                if (!attribute.isRemoved()) {
                    return attribute;
                }
                if (newAttribute == null) {
                    newAttribute = new DefaultAttribute<T>(this, key);
                }
                int count = attributes.length;
                DefaultAttribute[] defaultAttributeArray = Arrays.copyOf(attributes, count);
                newAttributes = defaultAttributeArray;
                defaultAttributeArray[index] = newAttribute;
                continue;
            }
            if (newAttribute == null) {
                newAttribute = new DefaultAttribute<T>(this, key);
            }
            int count = attributes.length;
            newAttributes = new DefaultAttribute[count + 1];
            DefaultAttributeMap.orderedCopyOnInsert(attributes, count, newAttributes, newAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, (DefaultAttribute[])var3_3, newAttributes));
        return newAttribute;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        void var1_1;
        ObjectUtil.checkNotNull(key, "key");
        return DefaultAttributeMap.searchAttributeByKey(this.attributes, var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private <T> void removeAttributeIfMatch(AttributeKey<T> key, DefaultAttribute<T> value) {
        DefaultAttribute[] newAttributes;
        void var3_3;
        do {
            DefaultAttribute[] attributes = this.attributes;
            int index = DefaultAttributeMap.searchAttributeByKey(this.attributes, key);
            if (index < 0) {
                return;
            }
            DefaultAttribute attribute = attributes[index];
            assert (attribute.key() == key);
            if (attribute != value) {
                return;
            }
            int count = attributes.length;
            int newCount = count - 1;
            newAttributes = newCount == 0 ? EMPTY_ATTRIBUTES : new DefaultAttribute[newCount];
            System.arraycopy(attributes, 0, newAttributes, 0, index);
            int remaining = count - index - 1;
            if (remaining <= 0) continue;
            System.arraycopy(attributes, index + 1, newAttributes, index, remaining);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, (DefaultAttribute[])var3_3, newAttributes));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(DefaultAttributeMap x0, AttributeKey x1, DefaultAttribute x2) {
        void var2_2;
        void var1_1;
        x0.removeAttributeIfMatch((AttributeKey)var1_1, (DefaultAttribute)var2_2);
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final AtomicReferenceFieldUpdater<DefaultAttribute, DefaultAttributeMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttribute.class, DefaultAttributeMap.class, "attributeMap");
        private static final long serialVersionUID = -2661411462200283011L;
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        /*
         * WARNING - void declaration
         */
        DefaultAttribute(DefaultAttributeMap attributeMap, AttributeKey<T> key) {
            void var2_2;
            void var1_1;
            this.attributeMap = var1_1;
            this.key = var2_2;
        }

        @Override
        public final AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T setIfAbsent(T value) {
            while (!this.compareAndSet(null, value)) {
                void var2_2;
                Object old = this.get();
                if (old == null) continue;
                return var2_2;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T getAndRemove() {
            void var3_3;
            void var2_2;
            DefaultAttributeMap attributeMap = this.attributeMap;
            boolean removed = attributeMap != null && MAP_UPDATER.compareAndSet(this, attributeMap, null);
            Object oldValue = this.getAndSet(null);
            if (var2_2 != false) {
                void var1_1;
                DefaultAttributeMap.access$200((DefaultAttributeMap)var1_1, this.key, this);
            }
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void remove() {
            void var2_2;
            DefaultAttributeMap attributeMap = this.attributeMap;
            boolean removed = attributeMap != null && MAP_UPDATER.compareAndSet(this, attributeMap, null);
            this.set(null);
            if (var2_2 != false) {
                void var1_1;
                DefaultAttributeMap.access$200((DefaultAttributeMap)var1_1, this.key, this);
            }
        }
    }
}

