/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    /*
     * WARNING - void declaration
     */
    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        void var2_2;
        void var1_1;
        return this.valueOf(((Class)ObjectUtil.checkNotNull(var1_1, "firstNameComponent")).getName() + '#' + (String)ObjectUtil.checkNotNull(var2_2, "secondNameComponent"));
    }

    /*
     * WARNING - void declaration
     */
    public T valueOf(String name) {
        void var1_1;
        return this.getOrCreate(ObjectUtil.checkNonEmpty((String)var1_1, "name"));
    }

    /*
     * WARNING - void declaration
     */
    private T getOrCreate(String name) {
        void var2_2;
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null) {
            void var1_1;
            ConstantPool constantPool = this;
            T tempConstant = constantPool.newConstant(constantPool.nextId(), name);
            constant = (Constant)this.constants.putIfAbsent((String)var1_1, tempConstant);
            if (constant == null) {
                void var3_3;
                return var3_3;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists(String name) {
        void var1_1;
        return this.constants.containsKey(ObjectUtil.checkNonEmpty((String)var1_1, "name"));
    }

    /*
     * WARNING - void declaration
     */
    public T newInstance(String name) {
        void var1_1;
        return this.createOrThrow(ObjectUtil.checkNonEmpty((String)var1_1, "name"));
    }

    /*
     * WARNING - void declaration
     */
    private T createOrThrow(String name) {
        void var1_1;
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null) {
            ConstantPool constantPool = this;
            T tempConstant = constantPool.newConstant(constantPool.nextId(), name);
            constant = (Constant)this.constants.putIfAbsent(name, tempConstant);
            if (constant == null) {
                void var3_3;
                return var3_3;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", var1_1));
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

