/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Map;

public final class CharsetUtil {
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Charset[] CHARSETS = new Charset[]{UTF_16, UTF_16BE, UTF_16LE, UTF_8, ISO_8859_1, US_ASCII};

    public static Charset[] values() {
        return CHARSETS;
    }

    @Deprecated
    public static CharsetEncoder getEncoder(Charset charset) {
        return CharsetUtil.encoder(charset);
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetEncoder encoder(Charset charset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        CharsetEncoder charsetEncoder;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(charset, "charset");
        CharsetEncoder e = charset.newEncoder();
        e.onMalformedInput((CodingErrorAction)var1_1).onUnmappableCharacter((CodingErrorAction)var2_2);
        return charsetEncoder;
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetEncoder encoder(Charset charset, CodingErrorAction codingErrorAction) {
        void var1_1;
        void v0 = var1_1;
        return CharsetUtil.encoder(charset, (CodingErrorAction)v0, (CodingErrorAction)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetEncoder encoder(Charset charset) {
        void var2_2;
        Charset charset2;
        void var1_1;
        ObjectUtil.checkNotNull(charset, "charset");
        Map<Charset, CharsetEncoder> map = InternalThreadLocalMap.get().charsetEncoderCache();
        CharsetEncoder e = map.get(charset);
        if (e != null) {
            e.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return e;
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPLACE;
        e = CharsetUtil.encoder(charset, codingErrorAction, codingErrorAction);
        var1_1.put(charset2, e);
        return var2_2;
    }

    @Deprecated
    public static CharsetDecoder getDecoder(Charset charset) {
        return CharsetUtil.decoder(charset);
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetDecoder decoder(Charset charset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        CharsetDecoder charsetDecoder;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull(charset, "charset");
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput((CodingErrorAction)var1_1).onUnmappableCharacter((CodingErrorAction)var2_2);
        return charsetDecoder;
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetDecoder decoder(Charset charset, CodingErrorAction codingErrorAction) {
        void var1_1;
        void v0 = var1_1;
        return CharsetUtil.decoder(charset, (CodingErrorAction)v0, (CodingErrorAction)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static CharsetDecoder decoder(Charset charset) {
        void var2_2;
        Charset charset2;
        void var1_1;
        ObjectUtil.checkNotNull(charset, "charset");
        Map<Charset, CharsetDecoder> map = InternalThreadLocalMap.get().charsetDecoderCache();
        CharsetDecoder d = map.get(charset);
        if (d != null) {
            d.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return d;
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPLACE;
        d = CharsetUtil.decoder(charset, codingErrorAction, codingErrorAction);
        var1_1.put(charset2, d);
        return var2_2;
    }

    private CharsetUtil() {
    }
}

