/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SWARUtil;

final class AsciiStringUtil {
    /*
     * WARNING - void declaration
     */
    static AsciiString toLowerCase(AsciiString string) {
        Object object;
        void var2_2;
        void var1_1;
        void var3_3;
        int length;
        int offset;
        byte[] byteArray = string.array();
        if (!AsciiStringUtil.containsUpperCase(byteArray, offset = string.arrayOffset(), length = string.length())) {
            return string;
        }
        Object newByteArray = PlatformDependent.allocateUninitializedArray((int)var3_3);
        AsciiStringUtil.toLowerCase((byte[])var1_1, (int)var2_2, (byte[])newByteArray);
        return new AsciiString((byte[])object, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsUpperCase(byte[] byteArray, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsUpperCase(byteArray, offset, length);
        }
        int longCount = length >>> 3;
        for (int i = 0; i < longCount; ++i) {
            long l = PlatformDependent.getLong(byteArray, offset);
            if (SWARUtil.containsUpperCase(l)) {
                return true;
            }
            offset += 8;
        }
        return AsciiStringUtil.unrolledContainsUpperCase(byArray, (int)var1_1, var2_2 & 7);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean linearContainsUpperCase(byte[] byteArray, int offset, int length) {
        void idx;
        int end = offset + length;
        while (idx < end) {
            if (AsciiStringUtil.isUpperCase(byteArray[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean unrolledContainsUpperCase(byte[] byteArray, int offset, int byteCount) {
        void var2_2;
        assert (byteCount >= 0 && byteCount < 8);
        if ((byteCount & 4) != 0) {
            int n = PlatformDependent.getInt(byteArray, offset);
            if (SWARUtil.containsUpperCase(n)) {
                return true;
            }
            offset += 4;
        }
        if ((byteCount & 2) != 0) {
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byteArray, offset))) {
                return true;
            }
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byteArray, offset + 1))) {
                return true;
            }
            offset += 2;
        }
        if ((var2_2 & 1) != 0) {
            void var1_1;
            byte[] byArray;
            return AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byArray, (int)var1_1));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void toLowerCase(byte[] src, int srcOffset, byte[] dst) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToLowerCase(src, srcOffset, dst);
            return;
        }
        int length = dst.length;
        int longCount = length >>> 3;
        int offset = 0;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(src, srcOffset + offset);
            PlatformDependent.putLong(dst, offset, SWARUtil.toLowerCase(word));
            offset += 8;
        }
        AsciiStringUtil.unrolledToLowerCase(byArray, (int)(var1_1 + offset), (byte[])var2_2, offset, var3_3 & 7);
    }

    private static void linearToLowerCase(byte[] src, int srcOffset, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = AsciiStringUtil.toLowerCase(src[srcOffset + i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void unrolledToLowerCase(byte[] src, int srcPos, byte[] dst, int dstOffset, int byteCount) {
        int word;
        assert (byteCount >= 0 && byteCount < 8);
        int offset = 0;
        if ((byteCount & 4) != 0) {
            word = PlatformDependent.getInt(src, srcPos);
            PlatformDependent.putInt(dst, dstOffset, SWARUtil.toLowerCase(word));
            offset += 4;
        }
        if ((byteCount & 2) != 0) {
            short s = PlatformDependent.getShort(src, srcPos + offset);
            word = s;
            short result = (short)(AsciiStringUtil.toLowerCase((byte)(s >>> 8)) << 8 | AsciiStringUtil.toLowerCase((byte)word));
            PlatformDependent.putShort(dst, dstOffset + offset, result);
            offset += 2;
        }
        if ((byteCount & 1) != 0) {
            void var1_1;
            byte[] byArray;
            void var3_3;
            void var2_2;
            PlatformDependent.putByte((byte[])var2_2, (int)(var3_3 + offset), AsciiStringUtil.toLowerCase(PlatformDependent.getByte(byArray, (int)(var1_1 + offset))));
        }
    }

    /*
     * WARNING - void declaration
     */
    static AsciiString toUpperCase(AsciiString string) {
        Object object;
        void var2_2;
        void var1_1;
        void var3_3;
        int length;
        int offset;
        byte[] byteArray = string.array();
        if (!AsciiStringUtil.containsLowerCase(byteArray, offset = string.arrayOffset(), length = string.length())) {
            return string;
        }
        Object newByteArray = PlatformDependent.allocateUninitializedArray((int)var3_3);
        AsciiStringUtil.toUpperCase((byte[])var1_1, (int)var2_2, (byte[])newByteArray);
        return new AsciiString((byte[])object, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsLowerCase(byte[] byteArray, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsLowerCase(byteArray, offset, length);
        }
        int longCount = length >>> 3;
        for (int i = 0; i < longCount; ++i) {
            long l = PlatformDependent.getLong(byteArray, offset);
            if (SWARUtil.containsLowerCase(l)) {
                return true;
            }
            offset += 8;
        }
        return AsciiStringUtil.unrolledContainsLowerCase(byArray, (int)var1_1, var2_2 & 7);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean linearContainsLowerCase(byte[] byteArray, int offset, int length) {
        void idx;
        int end = offset + length;
        while (idx < end) {
            if (AsciiStringUtil.isLowerCase(byteArray[idx])) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean unrolledContainsLowerCase(byte[] byteArray, int offset, int byteCount) {
        void var2_2;
        assert (byteCount >= 0 && byteCount < 8);
        if ((byteCount & 4) != 0) {
            int n = PlatformDependent.getInt(byteArray, offset);
            if (SWARUtil.containsLowerCase(n)) {
                return true;
            }
            offset += 4;
        }
        if ((byteCount & 2) != 0) {
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byteArray, offset))) {
                return true;
            }
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byteArray, offset + 1))) {
                return true;
            }
            offset += 2;
        }
        if ((var2_2 & 1) != 0) {
            void var1_1;
            byte[] byArray;
            return AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byArray, (int)var1_1));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void toUpperCase(byte[] src, int srcOffset, byte[] dst) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToUpperCase(src, srcOffset, dst);
            return;
        }
        int length = dst.length;
        int longCount = length >>> 3;
        int offset = 0;
        for (int i = 0; i < longCount; ++i) {
            long word = PlatformDependent.getLong(src, srcOffset + offset);
            PlatformDependent.putLong(dst, offset, SWARUtil.toUpperCase(word));
            offset += 8;
        }
        AsciiStringUtil.unrolledToUpperCase(byArray, (int)(var1_1 + offset), (byte[])var2_2, offset, var3_3 & 7);
    }

    private static void linearToUpperCase(byte[] src, int srcOffset, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = AsciiStringUtil.toUpperCase(src[srcOffset + i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void unrolledToUpperCase(byte[] src, int srcOffset, byte[] dst, int dstOffset, int byteCount) {
        int word;
        assert (byteCount >= 0 && byteCount < 8);
        int offset = 0;
        if ((byteCount & 4) != 0) {
            word = PlatformDependent.getInt(src, srcOffset);
            PlatformDependent.putInt(dst, dstOffset, SWARUtil.toUpperCase(word));
            offset += 4;
        }
        if ((byteCount & 2) != 0) {
            short s = PlatformDependent.getShort(src, srcOffset + offset);
            word = s;
            short result = (short)(AsciiStringUtil.toUpperCase((byte)(s >>> 8)) << 8 | AsciiStringUtil.toUpperCase((byte)word));
            PlatformDependent.putShort(dst, dstOffset + offset, result);
            offset += 2;
        }
        if ((byteCount & 1) != 0) {
            void var1_1;
            byte[] byArray;
            void var3_3;
            void var2_2;
            PlatformDependent.putByte((byte[])var2_2, (int)(var3_3 + offset), AsciiStringUtil.toUpperCase(PlatformDependent.getByte(byArray, (int)(var1_1 + offset))));
        }
    }

    private static boolean isLowerCase(byte value) {
        byte by;
        return value >= 97 && by <= 122;
    }

    static boolean isUpperCase(byte value) {
        byte by;
        return value >= 65 && by <= 90;
    }

    static byte toLowerCase(byte value) {
        byte by;
        if (AsciiStringUtil.isUpperCase(value)) {
            return (byte)(value + 32);
        }
        return by;
    }

    static byte toUpperCase(byte value) {
        byte by;
        if (AsciiStringUtil.isLowerCase(value)) {
            return (byte)(value - 32);
        }
        return by;
    }

    private AsciiStringUtil() {
    }
}

