/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiStringUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public final int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(CharSequence a, CharSequence b) {
            void var2_2;
            return AsciiString.contentEqualsIgnoreCase(a, (CharSequence)var2_2);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public final int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(CharSequence a, CharSequence b) {
            void var2_2;
            return AsciiString.contentEquals(a, (CharSequence)var2_2);
        }
    };

    /*
     * WARNING - void declaration
     */
    public AsciiString(byte[] value) {
        this((byte[])var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(byte[] value, boolean copy) {
        this(value, 0, ((void)var1_1).length, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(byte[] value, int start, int length, boolean copy) {
        void var3_3;
        if (copy) {
            byte[] rangedCopy = new byte[length];
            System.arraycopy(value, start, rangedCopy, 0, rangedCopy.length);
            this.value = rangedCopy;
            this.offset = 0;
        } else {
            void var2_2;
            void var1_1;
            if (MathUtil.isOutOfBounds(start, length, value.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
            }
            this.value = var1_1;
            this.offset = var2_2;
        }
        this.length = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(ByteBuffer value) {
        this((ByteBuffer)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(ByteBuffer value, boolean copy) {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer = value;
        this(byteBuffer, byteBuffer.position(), var1_1.remaining(), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(ByteBuffer value, int start, int length, boolean copy) {
        void var3_3;
        if (MathUtil.isOutOfBounds(start, length, value.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.capacity(" + value.capacity() + ')');
        }
        if (value.hasArray()) {
            int bufferOffset;
            if (copy) {
                int n = bufferOffset = value.arrayOffset() + start;
                this.value = Arrays.copyOfRange(value.array(), n, n + length);
                this.offset = 0;
            } else {
                this.value = value.array();
                this.offset = bufferOffset;
            }
        } else {
            void var2_2;
            void var1_1;
            this.value = PlatformDependent.allocateUninitializedArray(length);
            int oldPos = value.position();
            value.get(this.value, 0, length);
            var1_1.position((int)var2_2);
            this.offset = 0;
        }
        this.length = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(char[] value) {
        this(value, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(char[] value, int start, int length) {
        void var3_3;
        if (MathUtil.isOutOfBounds(start, length, value.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i = 0;
        while (i < length) {
            void j;
            this.value[i] = AsciiString.c2b(value[j]);
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(char[] value, Charset charset) {
        this(value, (Charset)var2_2, 0, ((void)var1_1).length);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(char[] value, Charset charset, int start, int length) {
        void var3_5;
        void var1_2;
        void var2_3;
        CharBuffer cbuf = CharBuffer.wrap(value, start, length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        var2_3.encode(cbuf, nativeBuffer, true);
        int bufferOffset = nativeBuffer.arrayOffset();
        void v0 = var1_2;
        this.value = Arrays.copyOfRange(nativeBuffer.array(), (int)v0, (int)(v0 + var3_5.position()));
        this.offset = 0;
        this.length = this.value.length;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(CharSequence value) {
        this(value, 0, var1_1.length());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(CharSequence value, int start, int length) {
        void var3_3;
        if (MathUtil.isOutOfBounds(start, length, value.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i = 0;
        while (i < length) {
            void j;
            this.value[i] = AsciiString.c2b(value.charAt((int)j));
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(CharSequence value, Charset charset) {
        this(value, (Charset)var2_2, 0, var1_1.length());
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiString(CharSequence value, Charset charset, int start, int length) {
        void var3_5;
        void var1_2;
        void var2_3;
        int n = start;
        CharBuffer cbuf = CharBuffer.wrap(value, n, n + length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        var2_3.encode(cbuf, nativeBuffer, true);
        int offset = nativeBuffer.arrayOffset();
        void v1 = var1_2;
        this.value = Arrays.copyOfRange(nativeBuffer.array(), (int)v1, (int)(v1 + var3_5.position()));
        this.offset = 0;
        this.length = this.value.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByte(ByteProcessor visitor) throws Exception {
        void var1_1;
        return this.forEachByte0(0, this.length(), (ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByte(int index, int length, ByteProcessor visitor) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (MathUtil.isOutOfBounds(index, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    private int forEachByte0(int index, int length, ByteProcessor visitor) throws Exception {
        int len = this.offset + index + length;
        for (int i = this.offset + index; i < len; ++i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByteDesc(ByteProcessor visitor) throws Exception {
        void var1_1;
        return this.forEachByteDesc0(0, this.length(), (ByteProcessor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByteDesc(int index, int length, ByteProcessor visitor) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (MathUtil.isOutOfBounds(index, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    private int forEachByteDesc0(int index, int length, ByteProcessor visitor) throws Exception {
        int end = this.offset + index;
        for (int i = this.offset + index + var2_2 - 1; i >= end; --i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final byte byteAt(int index) {
        void var1_1;
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index + this.offset);
        }
        return this.value[var1_1 + this.offset];
    }

    @Override
    public final boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public final int length() {
        return this.length;
    }

    public final void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public final byte[] array() {
        return this.value;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray(int start, int end) {
        void var2_2;
        void var1_1;
        return Arrays.copyOfRange(this.value, (int)(var1_1 + this.offset), (int)(var2_2 + this.offset));
    }

    /*
     * WARNING - void declaration
     */
    public final void copy(int srcIdx, byte[] dst, int dstIdx, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, (int)(var1_1 + this.offset), ObjectUtil.checkNotNull(var2_2, "dst"), (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char charAt(int index) {
        void var1_1;
        return AsciiString.b2c(this.byteAt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(CharSequence cs) {
        void var1_1;
        return this.indexOf((CharSequence)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(CharSequence string) {
        void var3_2;
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        int i = 0;
        int j = this.arrayOffset();
        while (i < minLength) {
            int result = AsciiString.b2c(this.value[j]) - string.charAt(i);
            if (result != 0) {
                void var2_7;
                return (int)var2_7;
            }
            ++i;
            ++j;
        }
        return (int)(var3_2 - length2);
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString concat(CharSequence string) {
        void var3_3;
        int thisLen = this.length();
        int thatLen = string.length();
        if (thatLen == 0) {
            return this;
        }
        if (string instanceof AsciiString) {
            AsciiString that = (AsciiString)string;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + thatLen);
            System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
            System.arraycopy(that.value, that.arrayOffset(), newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string);
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + var3_3);
        System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
        int i = thisLen;
        int j = 0;
        while (i < newValue.length) {
            newValue[i] = AsciiString.c2b(string.charAt(j));
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean endsWith(CharSequence suffix) {
        void var2_2;
        void var1_1;
        int suffixLen = suffix.length();
        AsciiString asciiString = this;
        return asciiString.regionMatches(asciiString.length() - suffixLen, (CharSequence)var1_1, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contentEqualsIgnoreCase(CharSequence string) {
        void var1_1;
        if (this == string) {
            return true;
        }
        if (string == null || string.length() != this.length()) {
            return false;
        }
        if (string instanceof AsciiString) {
            AsciiString other = (AsciiString)string;
            byte[] value = this.value;
            if (this.offset == 0 && other.offset == 0 && this.length == value.length) {
                byte[] otherValue = other.value;
                for (int i = 0; i < value.length; ++i) {
                    if (AsciiString.equalsIgnoreCase(value[i], otherValue[i])) continue;
                    return false;
                }
                return true;
            }
            return this.misalignedEqualsIgnoreCase(other);
        }
        byte[] value = this.value;
        int i = this.offset;
        for (int j = 0; j < var1_1.length(); ++j) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(value[i]), var1_1.charAt(j))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean misalignedEqualsIgnoreCase(AsciiString other) {
        byte[] value = this.value;
        byte[] otherValue = other.value;
        int i = this.offset;
        int j = other.offset;
        int end = this.offset + this.length;
        while (i < end) {
            if (!AsciiString.equalsIgnoreCase(value[i], otherValue[j])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public final char[] toCharArray(int start, int end) {
        void var3_3;
        int length = end - start;
        if (length == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(start, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        char[] buffer = new char[length];
        int i = 0;
        int j = start + this.arrayOffset();
        while (i < length) {
            buffer[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void copy(int srcIdx, char[] dst, int dstIdx, int length) {
        void i;
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        int dstEnd = dstIdx + length;
        int j = srcIdx + this.arrayOffset();
        while (i < dstEnd) {
            dst[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString subSequence(int start) {
        void var1_1;
        return this.subSequence((int)var1_1, this.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AsciiString subSequence(int start, int end) {
        void var2_2;
        void var1_1;
        return this.subSequence((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString subSequence(int start, int end, boolean copy) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (MathUtil.isOutOfBounds(start, end - start, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (end == start) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start + this.offset, (int)(var2_2 - var1_1), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(CharSequence string) {
        void var1_1;
        return this.indexOf((CharSequence)var1_1, 0);
    }

    public final int indexOf(CharSequence subString, int start) {
        int subCount = subString.length();
        if (start < 0) {
            start = 0;
        }
        if (subCount <= 0) {
            if (start < this.length) {
                return start;
            }
            return this.length;
        }
        if (subCount > this.length - start) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        int len = this.offset + this.length - subCount;
        for (int i = start + this.offset; i <= len; ++i) {
            if (this.value[i] != firstCharAsByte) continue;
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i - this.offset;
        }
        return -1;
    }

    public final int indexOf(char ch, int start) {
        if (ch > '\u00ff') {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        byte chAsByte = AsciiString.c2b0(ch);
        int len = this.offset + this.length;
        for (int i = start + this.offset; i < len; ++i) {
            if (this.value[i] != chAsByte) continue;
            return i - this.offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int lastIndexOf(CharSequence string) {
        void var1_1;
        return this.lastIndexOf((CharSequence)var1_1, this.length);
    }

    public final int lastIndexOf(CharSequence subString, int start) {
        int subCount = subString.length();
        if ((start = Math.min(start, this.length - subCount)) < 0) {
            return -1;
        }
        if (subCount == 0) {
            return start;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        for (int i = this.offset + start; i >= this.offset; --i) {
            if (this.value[i] != firstCharAsByte) continue;
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i - this.offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean regionMatches(int thisStart, CharSequence string, int start, int length) {
        void i;
        ObjectUtil.checkNotNull(string, "string");
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thatEnd = start + length;
        int j = thisStart + this.arrayOffset();
        while (i < thatEnd) {
            if (AsciiString.b2c(this.value[j]) != string.charAt((int)i)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final boolean regionMatches(boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        ObjectUtil.checkNotNull(string, "string");
        int thisLen = this.length();
        if (thisStart < 0 || length > thisLen - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int thisEnd = (thisStart += this.arrayOffset()) + length;
        while (thisStart < thisEnd) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[thisStart++]), string.charAt(start++))) continue;
            return false;
        }
        return true;
    }

    public final AsciiString replace(char oldChar, char newChar) {
        if (oldChar > '\u00ff') {
            return this;
        }
        byte oldCharAsByte = AsciiString.c2b0(oldChar);
        byte newCharAsByte = AsciiString.c2b(newChar);
        int len = this.offset + this.length;
        for (int i = this.offset; i < len; ++i) {
            if (this.value[i] != oldCharAsByte) continue;
            byte[] buffer = PlatformDependent.allocateUninitializedArray(this.length());
            System.arraycopy(this.value, this.offset, buffer, 0, i - this.offset);
            buffer[i - this.offset] = newCharAsByte;
            ++i;
            while (i < len) {
                byte oldValue = this.value[i];
                buffer[i - this.offset] = oldValue != oldCharAsByte ? oldValue : newCharAsByte;
                ++i;
            }
            return new AsciiString(buffer, false);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(CharSequence prefix) {
        void var1_1;
        return this.startsWith((CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(CharSequence prefix, int start) {
        void var1_1;
        void var2_2;
        return this.regionMatches((int)var2_2, prefix, 0, var1_1.length());
    }

    public final AsciiString toLowerCase() {
        return AsciiStringUtil.toLowerCase(this);
    }

    public final AsciiString toUpperCase() {
        return AsciiStringUtil.toUpperCase(this);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence trim(CharSequence c) {
        void var3_3;
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        int start;
        int last;
        if (c instanceof AsciiString) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end = last = c.length() - 1;
        for (start = 0; start <= end && c.charAt(start) <= ' '; ++start) {
        }
        while (end >= start && c.charAt(end) <= ' ') {
            --end;
        }
        if (start == 0 && end == var2_2) {
            return c;
        }
        return charSequence.subSequence((int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString trim() {
        void var1_1;
        void var3_3;
        void var2_2;
        int start;
        int last;
        int end = last = this.arrayOffset() + this.length() - 1;
        for (start = this.arrayOffset(); start <= end && this.value[start] <= 32; ++start) {
        }
        while (end >= start && this.value[end] <= 32) {
            --end;
        }
        if (start == 0 && end == var2_2) {
            return this;
        }
        return new AsciiString(this.value, start, (int)(var3_3 - var1_1 + true), false);
    }

    public final boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        int i = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i]) != a.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString[] split(String expr, int max) {
        void var2_2;
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiString[] split(char delim) {
        void var2_2;
        int i;
        ArrayList<AsciiString> res = InternalThreadLocalMap.get().arrayList();
        int start = 0;
        int length = this.length();
        for (i = 0; i < length; ++i) {
            if (this.charAt(i) != delim) continue;
            if (start == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(this.value, start + this.arrayOffset(), i - start, false));
            }
            start = i + 1;
        }
        if (start == 0) {
            res.add(this);
        } else if (start != length) {
            void var3_3;
            res.add(new AsciiString(this.value, start + this.arrayOffset(), length - var3_3, false));
        } else {
            for (i = res.size() - 1; i >= 0 && ((AsciiString)res.get(i)).isEmpty(); --i) {
                res.remove(i);
            }
        }
        return var2_2.toArray(EmptyArrays.EMPTY_ASCII_STRINGS);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int h = this.hash;
        if (h == 0) {
            this.hash = h = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null || obj.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString other = (AsciiString)obj;
        return this.length() == other.length() && this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other.array(), var1_1.arrayOffset(), this.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        String cache = this.string;
        if (cache == null) {
            this.string = cache = this.toString(0);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(int start) {
        void var1_1;
        return this.toString((int)var1_1, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(int start, int end) {
        void var2_3;
        void var1_1;
        int length = end - start;
        if (length == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        String string = new String(this.value, 0, (int)(var1_1 + this.offset), (int)var2_3);
        return string;
    }

    public final boolean parseBoolean() {
        return this.length > 0 && this.value[this.offset] != 0;
    }

    public final char parseChar() {
        return this.parseChar(0);
    }

    /*
     * WARNING - void declaration
     */
    public final char parseChar(int start) {
        void var1_1;
        if (start + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + start + " would go out of bounds.");
        }
        int startWithOffset = start + this.offset;
        return (char)(AsciiString.b2c(this.value[startWithOffset]) << 8 | AsciiString.b2c(this.value[var1_1 + true]));
    }

    public final short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    /*
     * WARNING - void declaration
     */
    public final short parseShort(int radix) {
        void var1_1;
        return this.parseShort(0, this.length(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final short parseShort(int start, int end) {
        void var2_2;
        void var1_1;
        return this.parseShort((int)var1_1, (int)var2_2, 10);
    }

    /*
     * WARNING - void declaration
     */
    public final short parseShort(int start, int end, int radix) {
        void var3_3;
        int intValue = this.parseInt(start, end, radix);
        short result = (short)intValue;
        if (result != var3_3) {
            void var2_2;
            void var1_1;
            throw new NumberFormatException(this.subSequence((int)var1_1, (int)var2_2, false).toString());
        }
        return result;
    }

    public final int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    /*
     * WARNING - void declaration
     */
    public final int parseInt(int radix) {
        void var1_1;
        return this.parseInt(0, this.length(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int parseInt(int start, int end) {
        void var2_2;
        void var1_1;
        return this.parseInt((int)var1_1, (int)var2_2, 10);
    }

    /*
     * WARNING - void declaration
     */
    public final int parseInt(int start, int end, int radix) {
        void var3_3;
        void var2_2;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            void var1_1;
            throw new NumberFormatException(this.subSequence((int)var1_1, end, false).toString());
        }
        return this.parseInt(i, (int)var2_2, (int)var3_3, negative);
    }

    /*
     * WARNING - void declaration
     */
    private int parseInt(int start, int end, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            void var2_2;
            void var1_1;
            throw new NumberFormatException(this.subSequence((int)var1_1, (int)var2_2, false).toString());
        }
        return result;
    }

    public final long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    /*
     * WARNING - void declaration
     */
    public final long parseLong(int radix) {
        void var1_1;
        return this.parseLong(0, this.length(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final long parseLong(int start, int end) {
        void var2_2;
        void var1_1;
        return this.parseLong((int)var1_1, (int)var2_2, 10);
    }

    /*
     * WARNING - void declaration
     */
    public final long parseLong(int start, int end, int radix) {
        void var3_3;
        void var2_2;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            void var1_1;
            throw new NumberFormatException(this.subSequence((int)var1_1, end, false).toString());
        }
        return this.parseLong(i, (int)var2_2, (int)var3_3, negative);
    }

    /*
     * WARNING - void declaration
     */
    private long parseLong(int start, int end, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            void var2_2;
            void var1_1;
            throw new NumberFormatException(this.subSequence((int)var1_1, (int)var2_2, false).toString());
        }
        return result;
    }

    public final float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public final float parseFloat(int start, int end) {
        void var2_2;
        void var1_1;
        return Float.parseFloat(this.toString((int)var1_1, (int)var2_2));
    }

    public final double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    /*
     * WARNING - void declaration
     */
    public final double parseDouble(int start, int end) {
        void var2_2;
        void var1_1;
        return Double.parseDouble(this.toString((int)var1_1, (int)var2_2));
    }

    public static AsciiString of(CharSequence string) {
        CharSequence charSequence;
        if (string instanceof AsciiString) {
            return (AsciiString)string;
        }
        return new AsciiString(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static AsciiString cached(String string) {
        void var1_1;
        String string2;
        AsciiString asciiString = new AsciiString(string);
        new AsciiString(string).string = string2;
        return var1_1;
    }

    public static int hashCode(CharSequence value) {
        CharSequence charSequence;
        if (value == null) {
            return 0;
        }
        if (value instanceof AsciiString) {
            return value.hashCode();
        }
        return PlatformDependent.hashCodeAscii(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence a, CharSequence b) {
        void var1_1;
        return AsciiString.contains(a, (CharSequence)var1_1, DefaultCharEqualityComparator.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsIgnoreCase(CharSequence a, CharSequence b) {
        void var1_1;
        return AsciiString.contains(a, (CharSequence)var1_1, AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (AsciiString.equalsIgnoreCase(a.charAt(i), b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence value) {
        for (CharSequence v : collection) {
            void var2_2;
            if (!AsciiString.contentEqualsIgnoreCase(value, (CharSequence)var2_2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            void var2_2;
            if (AsciiString.containsContentEqualsIgnoreCase(a, (CharSequence)var2_2)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        void var1_1;
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i = 0; i < jdkResult.length; ++i) {
            res[i] = new AsciiString(jdkResult[i]);
        }
        return var1_1;
    }

    private static boolean contains(CharSequence a, CharSequence b, CharEqualityComparator cmp) {
        if (a == null || b == null || a.length() < b.length()) {
            return false;
        }
        if (b.length() == 0) {
            return true;
        }
        int bStart = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (cmp.equals(b.charAt(bStart), a.charAt(i))) {
                if (++bStart != b.length()) continue;
                return true;
            }
            if (a.length() - i < b.length()) {
                return false;
            }
            bStart = 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string, int start, int length, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length > cs.length() - csStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length;
        while (csIndex < csEnd) {
            void stringIndex;
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string.charAt((int)stringIndex++))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        if (cs == null || string == null) {
            return false;
        }
        if (cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, csStart, (String)string, start, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string, start, length);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, (int)var2_2, (CharSequence)var3_3, start, length, var1_1 != false ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean regionMatchesAscii(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        if (cs == null || string == null) {
            return false;
        }
        if (!ignoreCase && cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(false, csStart, (String)string, start, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string, start, length);
        }
        return AsciiString.regionMatchesCharSequences(charSequence, (int)var2_2, (CharSequence)var3_3, start, length, var1_1 != false ? AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        void i;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        while (i < endLimit) {
            if (AsciiString.regionMatches(str, true, (int)i, searchStr, 0, searchStrLen)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCaseAscii(CharSequence str, CharSequence searchStr, int startPos) {
        void i;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        while (i < endLimit) {
            if (AsciiString.regionMatchesAscii(str, true, (int)i, searchStr, 0, searchStrLen)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start) {
        int i;
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i = start < 0 ? 0 : i;
        while (i < sz) {
            if (cs.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equalsIgnoreCase(byte a, byte b) {
        void var1_1;
        byte by;
        return a == b || AsciiStringUtil.toLowerCase(by) == AsciiStringUtil.toLowerCase((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equalsIgnoreCase(char a, char b) {
        void var1_1;
        char c;
        return a == b || AsciiString.toLowerCase(c) == AsciiString.toLowerCase((char)var1_1);
    }

    public static char toLowerCase(char c) {
        char c2;
        if (AsciiString.isUpperCase(c)) {
            return (char)(c + 32);
        }
        return c2;
    }

    private static byte toUpperCase(byte b) {
        return AsciiStringUtil.toUpperCase(b);
    }

    public static boolean isUpperCase(byte value) {
        return AsciiStringUtil.isUpperCase(value);
    }

    public static boolean isUpperCase(char value) {
        char c;
        return value >= 'A' && c <= 'Z';
    }

    public static byte c2b(char c) {
        char c2;
        return (byte)(c > '\u00ff' ? 63 : (int)c2);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(char x0, char x1) {
        void var1_1;
        return AsciiString.equalsIgnoreCase(x0, (char)var1_1);
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(char a, char b) {
            void var2_2;
            void var1_1;
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase((char)var1_1) == Character.toLowerCase((char)var2_2);
        }
    }

    private static final class AsciiCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final AsciiCaseInsensitiveCharEqualityComparator INSTANCE = new AsciiCaseInsensitiveCharEqualityComparator();

        private AsciiCaseInsensitiveCharEqualityComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(char a, char b) {
            void var2_2;
            return AsciiString.access$000(a, (char)var2_2);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(char a, char b) {
            void var2_2;
            return a == var2_2;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

