/*
 * Decompiled with CFR 0.152.
 */
package com.github.catvod.net;

import androidx.compose.runtime.internal.StabilityInferred;
import com.corner.catvodcore.util.Utils;
import com.github.catvod.crawler.SpiderDebug;
import com.github.catvod.net.OkResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001BO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nBE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\u000bB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/github/catvod/net/OkRequest;", "", "method", "", "url", "json", "params", "Ljava/util/Map;", "header", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "request", "Lokhttp3/Request;", "tag", "instance", "", "getInstance", "()Lkotlin/Unit;", "requestBody", "Lokhttp3/RequestBody;", "getRequestBody", "()Lokhttp3/RequestBody;", "setParams", "execute", "Lcom/github/catvod/net/OkResult;", "client", "Lokhttp3/OkHttpClient;", "composeApp"})
@StabilityInferred(parameters=0)
public final class OkRequest {
    private final String method;
    private String url;
    private final String json;
    private final Map<String, String> params;
    private final Map<String, String> header;
    private Request request;
    private Object tag;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private OkRequest(String method, String url, String json, Map<String, String> params, Map<String, String> header) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.method = var1_1;
        this.url = var2_2;
        this.json = var3_3;
        this.params = params;
        this.header = header;
        this.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    public OkRequest(String method, String url, Map<String, String> params, Map<String, String> header) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this((String)var1_1, (String)var2_2, null, (Map<String, String>)var3_3, header);
    }

    /*
     * WARNING - void declaration
     */
    public OkRequest(String method, String url, String json, Map<String, String> header) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this((String)var1_1, (String)var2_2, (String)var3_3, new HashMap(), header);
    }

    /*
     * WARNING - void declaration
     */
    public final OkRequest tag(Object tag) {
        void var1_1;
        this.tag = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final Unit getInstance() {
        void var1_1;
        Request.Builder builder = new Request.Builder();
        if (Intrinsics.areEqual((Object)this.method, (Object)"GET")) {
            this.setParams();
        }
        if (Intrinsics.areEqual((Object)this.method, (Object)"POST")) {
            builder.post(this.getRequestBody());
        }
        if (this.header != null) {
            for (String key : this.header.keySet()) {
                void var3_3;
                Intrinsics.checkNotNull((Object)key);
                String string = this.header.get(var3_3);
                Intrinsics.checkNotNull((Object)string);
                builder.addHeader(key, string);
            }
        }
        if (this.tag != null) {
            builder.tag(this.tag);
        }
        this.request = var1_1.url(this.url).build();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final RequestBody getRequestBody() {
        void var1_1;
        if (!StringUtils.isEmpty((CharSequence)this.json)) {
            String string = this.json;
            Intrinsics.checkNotNull((Object)string);
            return RequestBody.Companion.create(string, MediaType.Companion.get("application/json; charset=utf-8"));
        }
        FormBody.Builder formBody = new FormBody.Builder(null, 1, null);
        Map<String, String> map = this.params;
        boolean bl = map != null ? !map.isEmpty() : false;
        if (bl) {
            for (String key : this.params.keySet()) {
                void var3_3;
                Intrinsics.checkNotNull((Object)key);
                String string = this.params.get(var3_3);
                Intrinsics.checkNotNull((Object)string);
                formBody.add(key, string);
            }
        }
        return (RequestBody)var1_1.build();
    }

    private final void setParams() {
        String string;
        String string2;
        String string3;
        this.url = this.url + "?";
        Map<String, String> map = this.params;
        boolean bl = map != null ? !map.isEmpty() : false;
        if (bl) {
            for (String key : this.params.keySet()) {
                this.url = this.url + key + "=" + this.params.get(string3) + "&";
            }
        }
        string3 = this.url;
        Utils utils = Utils.INSTANCE;
        boolean bl2 = true;
        String string4 = string3;
        if (string4 != null && string4.length() > 1) {
            String string5 = string4.substring(0, string4.length() - 1);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string2 = string = string4;
        }
        if (string2 == null) {
            string = "";
        }
        this.url = string;
    }

    public final OkResult execute(OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        try {
            OkResult okResult;
            Closeable closeable;
            Request request = this.request;
            Intrinsics.checkNotNull((Object)request);
            closeable = (Closeable)closeable.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                okResult = new OkResult(response.code(), response.body().string(), okResult.headers().toMultimap());
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return okResult;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            SpiderDebug.log("request fail path:" + iOException.getMessage());
            return new OkResult();
        }
    }
}

