/*
 * Decompiled with CFR 0.152.
 */
package com.corner.catvodcore.loader;

import androidx.compose.runtime.internal.StabilityInferred;
import com.corner.catvodcore.Constant;
import com.corner.catvodcore.config.ApiConfig;
import com.corner.catvodcore.util.Http;
import com.corner.catvodcore.util.Paths;
import com.corner.catvodcore.util.Urls;
import com.corner.catvodcore.util.Utils;
import com.github.catvod.crawler.Spider;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nJ\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nH\u0002J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\n2\u0006\u0010#\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\nH\u0002J&\u0010(\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u0010\u0010+\u001a\u00020%2\u0006\u0010#\u001a\u00020\nH\u0002J'\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0/\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\nR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R'\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR'\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0012\u0010\rR'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\rR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lcom/corner/catvodcore/loader/JarLoader;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "loaders", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/net/URLClassLoader;", "getLoaders", "()Ljava/util/concurrent/ConcurrentHashMap;", "loaders$delegate", "Lkotlin/Lazy;", "methods", "Ljava/lang/reflect/Method;", "getMethods", "methods$delegate", "spiders", "Lcom/github/catvod/crawler/Spider;", "getSpiders", "spiders$delegate", "recent", "getRecent", "()Ljava/lang/String;", "setRecent", "(Ljava/lang/String;)V", "clear", "", "loadJar", "key", "spider", "parseJarUrl", "jar", "load", "Ljava/io/File;", "putProxy", "invokeInit", "getSpider", "api", "ext", "download", "proxyInvoke", "", "params", "", "(Ljava/util/Map;)[Ljava/lang/Object;", "SetRecent", "composeApp"})
@StabilityInferred(parameters=0)
public final class JarLoader {
    public static final JarLoader INSTANCE = new JarLoader();
    private static final Logger log = LoggerFactory.getLogger(INSTANCE.getClass());
    private static final Lazy loaders$delegate = LazyKt.lazy(JarLoader::loaders_delegate$lambda$0);
    private static final Lazy methods$delegate = LazyKt.lazy(JarLoader::methods_delegate$lambda$1);
    private static final Lazy spiders$delegate = LazyKt.lazy(JarLoader::spiders_delegate$lambda$2);
    private static String recent;

    private JarLoader() {
    }

    private static ConcurrentHashMap<String, URLClassLoader> getLoaders() {
        Lazy lazy = loaders$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    private static ConcurrentHashMap<String, Method> getMethods() {
        Lazy lazy = methods$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    private static ConcurrentHashMap<String, Spider> getSpiders() {
        Lazy lazy = spiders$delegate;
        return (ConcurrentHashMap)lazy.getValue();
    }

    public final void clear() {
        JarLoader.getLoaders().clear();
        JarLoader.getMethods().clear();
        JarLoader.getSpiders().clear();
        recent = null;
    }

    public final void loadJar(String key, String spider) {
        while (true) {
            String string;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)spider, (String)"spider");
            if (StringUtils.isBlank((CharSequence)spider)) {
                return;
            }
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = Constant.INSTANCE.getMd5Split();
            List texts = StringsKt.split$default((CharSequence)spider, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            String md5 = texts.size() <= 1 ? "" : ((Object)StringsKt.trim((CharSequence)((String)texts.get(1)))).toString();
            Object jar = (String)texts.get(0);
            if (((CharSequence)md5).length() > 0 && Utils.INSTANCE.equals(JarLoader.parseJarUrl((String)jar), (String)stringArray2)) {
                this.load(key, Paths.INSTANCE.jar(JarLoader.parseJarUrl((String)jar)));
                return;
            }
            if (StringsKt.startsWith$default((String)jar, (String)"file", (boolean)false, (int)2, null)) {
                this.load(key, Paths.local((String)jar));
                return;
            }
            if (StringsKt.startsWith$default((String)jar, (String)"http", (boolean)false, (int)2, null)) {
                String string2 = key;
                key = jar;
                jar = Paths.INSTANCE.jar(key);
                log.debug("download jar file {} to:{}", (Object)key, jar);
                this.load(string2, Paths.write((File)jar, Http.Companion.Get$default$5d66b39a(Http.Companion, key, null, null, 6).execute().body().bytes()));
                return;
            }
            String string3 = ApiConfig.INSTANCE.getApi().getUrl();
            Intrinsics.checkNotNull((Object)string3);
            string = Urls.convert(string3, string);
        }
    }

    private static String parseJarUrl(String jar) {
        String string;
        if (StringsKt.startsWith$default((String)jar, (String)"file", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)jar, (String)"http", (boolean)false, (int)2, null)) {
            return jar;
        }
        String string2 = ApiConfig.INSTANCE.getApi().getUrl();
        Intrinsics.checkNotNull((Object)string2);
        return Urls.convert(string2, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void load(String key, File jar) {
        void var1_1;
        void var2_2;
        log.debug("load jar {}", (Object)jar);
        Map map = JarLoader.getLoaders();
        URL[] uRLArray = new URL[1];
        Object object = uRLArray;
        uRLArray[0] = var2_2.toURI().toURL();
        object = new URLClassLoader((URL[])object, this.getClass().getClassLoader());
        map.put(key, object);
        this.putProxy(key);
        this.invokeInit((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void putProxy(String key) {
        try {
            void var1_1;
            URLClassLoader uRLClassLoader = JarLoader.getLoaders().get(key);
            Class[] classArray = uRLClassLoader != null ? uRLClassLoader.loadClass(Constant.INSTANCE.getCatVodProxy()) : null;
            Class[] classArray2 = classArray;
            Intrinsics.checkNotNull(classArray);
            Class[] classArray3 = new Class[1];
            classArray2 = classArray3;
            classArray3[0] = Map.class;
            Method method = classArray.getMethod("proxy", classArray2);
            ((Map)JarLoader.getMethods()).put(var1_1, classArray2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeInit(String key) {
        try {
            Method method;
            URLClassLoader uRLClassLoader = JarLoader.getLoaders().get(key);
            Class<?> clazz = uRLClassLoader != null ? uRLClassLoader.loadClass(Constant.INSTANCE.getCatVodInit()) : null;
            Method method2 = method = clazz != null ? clazz.getMethod("init", new Class[0]) : null;
            if (method2 != null) {
                void var1_1;
                method2.invoke((Object)var1_1, new Object[0]);
                return;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Spider getSpider(String key, String api, String ext, String jar) {
        Exception exception;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        try {
            void var2_2;
            void var3_3;
            String jaKey = Utils.md5(jar);
            String spKey = jaKey + key;
            if (JarLoader.getSpiders().containsKey(spKey)) {
                Spider spider = JarLoader.getSpiders().get(spKey);
                Intrinsics.checkNotNull((Object)spider);
                return spider;
            }
            if (JarLoader.getLoaders().get(jaKey) == null) {
                this.loadJar(jaKey, jar);
            }
            URLClassLoader loader = JarLoader.getLoaders().get(jaKey);
            String classPath = Constant.INSTANCE.getCatVodSpider() + "." + StringsKt.replace$default((String)api, (String)"csp_", (String)"", (boolean)false, (int)4, null);
            URLClassLoader uRLClassLoader = loader;
            Intrinsics.checkNotNull((Object)uRLClassLoader);
            classPath = uRLClassLoader.loadClass(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNull(classPath, (String)"null cannot be cast to non-null type com.github.catvod.crawler.Spider");
            Spider spider = (Spider)((Object)classPath);
            spider.init((String)var3_3);
            ((Map)JarLoader.getSpiders()).put(exception, spider);
            return var2_2;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return new Spider();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Object[] proxyInvoke(Map<String, String> params) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        try {
            Object object;
            String string = recent;
            if (string == null) {
                string = "";
            }
            String md5 = Utils.md5(string);
            Object[] objectArray2 = objectArray = JarLoader.getMethods().get(objectArray);
            if (objectArray2 != null) {
                void var1_1;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = var1_1;
                object = objectArray2.invoke(null, objectArray);
            } else {
                object = null;
            }
            Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        }
        catch (Exception exception) {
            objectArray = exception;
            exception.printStackTrace();
            objectArray = null;
        }
        return objectArray;
    }

    public static void SetRecent(String jar) {
        recent = jar;
    }

    private static final ConcurrentHashMap loaders_delegate$lambda$0() {
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap methods_delegate$lambda$1() {
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap spiders_delegate$lambda$2() {
        return new ConcurrentHashMap();
    }
}

