/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.io.RefCountingCopyTracker;
import kotlinx.io.Segment;
import kotlinx.io.SegmentCopyTracker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\tH\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0007J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006$"}, d2={"Lkotlinx/io/SegmentPool;", "", "<init>", "()V", "MAX_SIZE", "", "getMAX_SIZE", "()I", "LOCK", "Lkotlinx/io/Segment;", "HASH_BUCKET_COUNT", "getHASH_BUCKET_COUNT$kotlinx_io_core", "HASH_BUCKET_COUNT_L2", "DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE", "", "SECOND_LEVEL_POOL_TOTAL_SIZE", "getSECOND_LEVEL_POOL_TOTAL_SIZE$kotlinx_io_core", "SECOND_LEVEL_POOL_BUCKET_SIZE", "hashBuckets", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "hashBucketsL2", "byteCount", "getByteCount", "take", "takeL2", "recycle", "", "segment", "recycleL2", "tracker", "Lkotlinx/io/SegmentCopyTracker;", "l1BucketId", "l2BucketId", "bucketId", "mask", "", "kotlinx-io-core"})
public final class SegmentPool {
    private static SegmentPool INSTANCE = new SegmentPool();
    private static final int MAX_SIZE = 65536;
    private static final Segment LOCK;
    private static final int HASH_BUCKET_COUNT;
    private static final int HASH_BUCKET_COUNT_L2;
    private static final String DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE;
    private static final int SECOND_LEVEL_POOL_TOTAL_SIZE;
    private static final int SECOND_LEVEL_POOL_BUCKET_SIZE;
    private static final AtomicReferenceArray<Segment> hashBuckets;
    private static final AtomicReferenceArray<Segment> hashBucketsL2;

    private SegmentPool() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Segment take() {
        void var2_2;
        void var1_1;
        void var0;
        Segment first2;
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        while (Intrinsics.areEqual((Object)(first2 = buckets.getAndSet(bucketId, LOCK)), (Object)LOCK)) {
        }
        if (first2 == null) {
            buckets.set(bucketId, null);
            if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                Segment segment;
                block5: {
                    buckets = hashBucketsL2;
                    bucketId = INSTANCE.l2BucketId();
                    int first2 = 0;
                    while (true) {
                        if (Intrinsics.areEqual((Object)(segment = buckets.getAndSet(bucketId, LOCK)), (Object)LOCK)) {
                            continue;
                        }
                        if (segment != null) break block5;
                        buckets.set(bucketId, null);
                        if (first2 >= HASH_BUCKET_COUNT_L2) break;
                        bucketId = bucketId + 1 & HASH_BUCKET_COUNT_L2 - 1;
                        ++first2;
                    }
                    return Segment.Companion.new$kotlinx_io_core();
                }
                buckets.set(bucketId, segment.getNext());
                segment.setNext(null);
                segment.setLimit(0);
                return segment;
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        var0.set((int)var1_1, first2.getNext());
        first2.setNext(null);
        first2.setLimit(0);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void recycle(Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (!(segment.getNext() == null && segment.getPrev() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentCopyTracker segmentCopyTracker = segment.getCopyTracker$kotlinx_io_core();
        boolean bl = segmentCopyTracker != null ? segmentCopyTracker.removeCopy() : false;
        if (bl) {
            return;
        }
        AtomicReferenceArray<Segment> buckets2 = hashBuckets;
        int bucketId2 = INSTANCE.l1BucketId();
        segment.setPos(0);
        segment.owner = true;
        while (true) {
            void var3_6;
            Segment first2;
            if ((first2 = buckets2.get(bucketId2)) == LOCK) {
                continue;
            }
            Segment segment2 = first2;
            int firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit >= MAX_SIZE) {
                if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                    segment.setPos(0);
                    segment.owner = true;
                    int buckets2 = INSTANCE.l2BucketId();
                    AtomicReferenceArray<Segment> bucketId2 = hashBucketsL2;
                    int first2 = 0;
                    while (true) {
                        if ((firstLimit = bucketId2.get(buckets2)) == LOCK) {
                            continue;
                        }
                        Segment segment3 = firstLimit;
                        int n = segment3 != null ? segment3.getLimit() : 0;
                        if (n + 8192 > SECOND_LEVEL_POOL_BUCKET_SIZE) {
                            if (first2 < HASH_BUCKET_COUNT_L2) {
                                ++first2;
                                buckets2 = buckets2 + 1 & HASH_BUCKET_COUNT_L2 - 1;
                                continue;
                            }
                            return;
                        }
                        segment.setNext(firstLimit);
                        segment.setLimit(n + 8192);
                        if (bucketId2.compareAndSet(buckets2, firstLimit, segment)) break;
                    }
                }
                return;
            }
            segment.setNext(first2);
            segment.setLimit(firstLimit + 8192);
            if (buckets2.compareAndSet(bucketId2, (Segment)var3_6, segment)) break;
        }
    }

    @JvmStatic
    public static final SegmentCopyTracker tracker() {
        return new RefCountingCopyTracker();
    }

    private final int l1BucketId() {
        return SegmentPool.bucketId((long)HASH_BUCKET_COUNT - 1L);
    }

    private final int l2BucketId() {
        return SegmentPool.bucketId((long)HASH_BUCKET_COUNT_L2 - 1L);
    }

    private static int bucketId(long mask) {
        long l;
        return (int)(Thread.currentThread().getId() & l);
    }

    static {
        boolean bl = false;
        Object var0_1 = null;
        boolean bl2 = false;
        bl2 = false;
        Object object = new byte[]{};
        Intrinsics.checkNotNullParameter((Object)object, (String)"data");
        LOCK = new Segment((byte[])object, 0, 0, null, false, 0);
        HASH_BUCKET_COUNT = Integer.highestOneBit((Runtime.getRuntime().availableProcessors() << 1) - 1);
        HASH_BUCKET_COUNT_L2 = RangesKt.coerceAtLeast((int)(HASH_BUCKET_COUNT / 2), (int)1);
        DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE = Intrinsics.areEqual((Object)System.getProperty("java.vm.name"), (Object)"Dalvik") ? "0" : "4194304";
        String string = System.getProperty("kotlinx.io.pool.size.bytes", DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        object = n;
        SECOND_LEVEL_POOL_TOTAL_SIZE = n != null ? RangesKt.coerceAtLeast((int)object.intValue(), (int)0) : 0;
        SECOND_LEVEL_POOL_BUCKET_SIZE = RangesKt.coerceAtLeast((int)(SECOND_LEVEL_POOL_TOTAL_SIZE / HASH_BUCKET_COUNT_L2), (int)8192);
        hashBuckets = new AtomicReferenceArray(HASH_BUCKET_COUNT);
        hashBucketsL2 = new AtomicReferenceArray(HASH_BUCKET_COUNT_L2);
    }
}

