/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.publicsuffix;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Queues;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.Deque;

@GwtCompatible
final class TrieParser {
    private static final Joiner PREFIX_JOINER = Joiner.on("");

    /*
     * WARNING - void declaration
     */
    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence encoded) {
        void var1_1;
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(Queues.newArrayDeque(), encoded, idx, builder)) {
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    private static int doParseTrieToBuilder(Deque<CharSequence> stack, CharSequence encoded, int start, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        void var2_2;
        Deque<CharSequence> deque;
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c = '\u0000';
        for (idx = start; idx < encodedLen && (c = encoded.charAt(idx)) != '&' && c != '?' && c != '!' && c != ':' && c != ','; ++idx) {
        }
        stack.push(TrieParser.reverse(encoded.subSequence(start, idx)));
        if ((c == '!' || c == '?' || c == ':' || c == ',') && (domain = PREFIX_JOINER.join(stack)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c));
        }
        ++idx;
        if (c != '?' && c != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack, encoded, idx, builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        deque.pop();
        return idx - var2_2;
    }

    private static CharSequence reverse(CharSequence s) {
        CharSequence charSequence;
        return new StringBuilder(charSequence).reverse();
    }
}

