/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class WrappingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    /*
     * WARNING - void declaration
     */
    protected WrappingExecutorService(ExecutorService delegate) {
        void var1_1;
        this.delegate = (ExecutorService)Preconditions.checkNotNull(var1_1);
    }

    protected abstract <T> Callable<T> wrapTask(Callable<T> var1);

    protected Runnable wrapTask(Runnable command) {
        Callable<Object> callable;
        callable = this.wrapTask(Executors.callable((Runnable)((Object)callable), null));
        return () -> {
            try {
                callable.call();
                return;
            }
            catch (Exception exception) {
                Exception exception2;
                Exception e = exception;
                Throwables.throwIfUnchecked(exception);
                throw new RuntimeException(exception2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private <T> ImmutableList<Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks) {
        void var2_2;
        Iterator iterator;
        ImmutableList.Builder builder = ImmutableList.builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Callable task = (Callable)iterator.next();
            builder.add(this.wrapTask((Callable<T>)var3_3));
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command) {
        void var1_1;
        this.delegate.execute(this.wrapTask((Runnable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        void var1_1;
        return this.delegate.submit(this.wrapTask((Callable)Preconditions.checkNotNull(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<?> submit(Runnable task) {
        void var1_1;
        return this.delegate.submit(this.wrapTask((Runnable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> Future<T> submit(Runnable task, @ParametricNullness T result) {
        void var2_2;
        void var1_1;
        return this.delegate.submit(this.wrapTask((Runnable)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        void var1_1;
        return this.delegate.invokeAll(this.wrapTasks((Collection<? extends Callable<T>>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        void var2_2;
        void var1_1;
        return this.delegate.invokeAll(this.wrapTasks((Collection<? extends Callable<T>>)var1_1), (long)var2_2, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        void var1_1;
        return this.delegate.invokeAny(this.wrapTasks((Collection<? extends Callable<T>>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var2_2;
        void var1_1;
        return this.delegate.invokeAny(this.wrapTasks((Collection<? extends Callable<T>>)var1_1), (long)var2_2, unit);
    }

    @Override
    public final void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        void var3_2;
        void var1_1;
        return this.delegate.awaitTermination((long)var1_1, (TimeUnit)var3_2);
    }
}

